/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.config;

import org.arquillian.cube.docker.impl.client.config.Image;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ImageParserTest {
    @Test
    public void shouldParseSimpleImages() {
        Image image = Image.valueOf((String)"my_image");
        Assert.assertThat((Object)image.getName(), (Matcher)CoreMatchers.is((Object)"my_image"));
        Assert.assertThat((Object)image.getTag(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldParseSimpleImagesWithTag() {
        Image image = Image.valueOf((String)"my_image:tag");
        Assert.assertThat((Object)image.getName(), (Matcher)CoreMatchers.is((Object)"my_image"));
        Assert.assertThat((Object)image.getTag(), (Matcher)CoreMatchers.is((Object)"tag"));
    }

    @Test
    public void shouldParseOrganizationImages() {
        Image image = Image.valueOf((String)"organization/my_image");
        Assert.assertThat((Object)image.getName(), (Matcher)CoreMatchers.is((Object)"organization/my_image"));
        Assert.assertThat((Object)image.getTag(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldParseOrganizationalImagesWithTag() {
        Image image = Image.valueOf((String)"organization/my_image:tag");
        Assert.assertThat((Object)image.getName(), (Matcher)CoreMatchers.is((Object)"organization/my_image"));
        Assert.assertThat((Object)image.getTag(), (Matcher)CoreMatchers.is((Object)"tag"));
    }

    @Test
    public void shouldParseRepositoryImages() {
        Image image = Image.valueOf((String)"localhost:5000/organization/my_image");
        Assert.assertThat((Object)image.getName(), (Matcher)CoreMatchers.is((Object)"localhost:5000/organization/my_image"));
        Assert.assertThat((Object)image.getTag(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldParseRepositoryImagesAndSeveralOrganizationLevels() {
        Image image = Image.valueOf((String)"localhost:5000/organization/organization2/my_image");
        Assert.assertThat((Object)image.getName(), (Matcher)CoreMatchers.is((Object)"localhost:5000/organization/organization2/my_image"));
        Assert.assertThat((Object)image.getTag(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldParseRepositoryImagesWithTag() {
        Image image = Image.valueOf((String)"localhost:5000/organization/my_image:tag");
        Assert.assertThat((Object)image.getName(), (Matcher)CoreMatchers.is((Object)"localhost:5000/organization/my_image"));
        Assert.assertThat((Object)image.getTag(), (Matcher)CoreMatchers.is((Object)"tag"));
    }

    @Test
    public void shouldParseRepositoryImagesWithTagAndSeveralOrganizationLevels() {
        Image image = Image.valueOf((String)"localhost:5000/organization/organization2/my_image:tag");
        Assert.assertThat((Object)image.getName(), (Matcher)CoreMatchers.is((Object)"localhost:5000/organization/organization2/my_image"));
        Assert.assertThat((Object)image.getTag(), (Matcher)CoreMatchers.is((Object)"tag"));
    }
}

