/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.requirement;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.arquillian.cube.docker.impl.client.CubeDockerConfigurationResolver;
import org.arquillian.cube.docker.impl.requirement.DockerRequirement;
import org.arquillian.cube.docker.impl.util.CommandLineExecutor;
import org.arquillian.cube.spi.requirement.UnsatisfiedRequirementException;
import org.arquillian.spacelift.execution.ExecutionException;
import org.awaitility.Awaitility;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DockerRequirementTest {
    @ClassRule
    public static final EnvironmentVariables environmentVariables = new EnvironmentVariables();
    @Mock
    CubeDockerConfigurationResolver configResolver;
    @Mock
    CommandLineExecutor commandLineExecutor;

    @BeforeClass
    public static void beforeEach() {
        environmentVariables.clear(new String[]{"DOCKER_HOST", "DOCKER_MACHINE_NAME", "DOCKER_TLS_VERIFY", "DOCKER_CERT_PATH"});
    }

    @Test(expected=UnsatisfiedRequirementException.class)
    public void testDockerRequirementCheckWhenExecutionExceptionThrown() throws UnsatisfiedRequirementException {
        Mockito.when((Object)this.configResolver.resolve(ArgumentMatchers.anyMap())).thenThrow(ExecutionException.class);
        DockerRequirement requirement = new DockerRequirement(this.commandLineExecutor, this.configResolver);
        requirement.check(null);
    }

    @Test(expected=UnsatisfiedRequirementException.class)
    public void testDockerRequirementCheckWhenDockerURLIsNull() throws UnsatisfiedRequirementException {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("serverUri", null);
        Mockito.when((Object)this.configResolver.resolve(ArgumentMatchers.anyMap())).thenReturn(configMap);
        DockerRequirement requirement = new DockerRequirement(this.commandLineExecutor, this.configResolver);
        requirement.check(null);
    }

    @Test(expected=UnsatisfiedRequirementException.class)
    public void testDockerRequirementCheckWhenDockerURLIsEmpty() throws UnsatisfiedRequirementException {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("serverUri", "");
        Mockito.when((Object)this.configResolver.resolve(ArgumentMatchers.anyMap())).thenReturn(configMap);
        DockerRequirement requirement = new DockerRequirement(this.commandLineExecutor, this.configResolver);
        requirement.check(null);
    }

    @Test(expected=UnsatisfiedRequirementException.class)
    public void testDockerRequirementCheckWhenDockerURLIsInvalid() throws UnsatisfiedRequirementException {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("serverUri", "tcp://nonexistanthostname:9999");
        Mockito.when((Object)this.configResolver.resolve(ArgumentMatchers.anyMap())).thenReturn(configMap);
        DockerRequirement requirement = new DockerRequirement(this.commandLineExecutor, this.configResolver);
        requirement.check(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDockerRequirementCheckDockerURLIsValid() throws Exception {
        FakeDockerServer server = new FakeDockerServer();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("serverUri", server.getConnectionString());
        Mockito.when((Object)this.configResolver.resolve(ArgumentMatchers.anyMap())).thenReturn(configMap);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(server);
        try {
            DockerRequirement requirement = new DockerRequirement(this.commandLineExecutor, this.configResolver);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> {
                try {
                    requirement.check(null);
                    return true;
                }
                catch (UnsatisfiedRequirementException e) {
                    return false;
                }
            });
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private class FakeDockerServer
    implements Runnable {
        private final ServerSocket serverSocket = new ServerSocket(0);

        private FakeDockerServer() throws IOException {
        }

        public String getConnectionString() {
            return "tcp://127.0.0.1:" + this.serverSocket.getLocalPort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (Socket socket = this.serverSocket.accept();){
                socket.getInputStream().read();
                try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));){
                    String versionJSON = "{\"Client\":{\"Version\":\"0.0.0\",\"ApiVersion\":\"0.00\"}}";
                    writer.println("HTTP/1.1 200 OK");
                    writer.println("Content-Type: application/json");
                    writer.println("Content-Length: " + versionJSON.length());
                    writer.println();
                    writer.println(versionJSON);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't create socket connection " + e.getMessage());
            }
        }
    }
}

