/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.DefinitionFormat;
import org.arquillian.cube.docker.impl.util.AutoStartOrderUtil;
import org.junit.Assert;
import org.junit.Test;

public class AutoStartOrderUtilTestCase {
    private static final String SCENARIO_NO_KNOWN_LINK = "A:\n  links:\n    - B:B\n";
    private static final String SCENARIO_SINGLE_LINK = "A:\n  links:\n    - B:B\nB:\n  image: a\n";
    private static final String SCENARIO_MULTIPLE_ROOTS = "A:\n  image: a\nB:\n  image: a\n";
    private static final String SCENARIO_MULTIPLE_ROOTS_AND_SINGLE_LINK = "A:\n  links:\n    - B:B\nB:\n  image: a\nC:\n  image: a\n";
    private static final String SCENARIO_SINGLE_ROOT_AND_MULTIPLE_LINKS = "A:\n  links:\n    - B:B\nB:\n  image: a\nC:\n  links:\n    - B:B\n";
    private static final String SCENARIO_SINGLE_ROOT_AND_MULTIPLE_DEPENDS = "A:\n  dependsOn:\n    - B\nB:\n  image: a\nC:\n  dependsOn:\n    - B\n";
    private static final String SCENARIO_SINGLE_ROOT_AND_MULTIPLE_DEPENDS_AND_LINK = "A:\n  dependsOn:\n    - B\nB:\n  image: a\nC:\n  links:\n    - A:A\n  dependsOn:\n    - B\n";
    private static final String SCENARIO_MULTI_ROOT_AND_MULTIPLE_LINKS = "A:\n  links:\n    - B:B\n    - D:D\nB:\n  image: a\nC:\n  links:\n    - B:B\nD:\n  links:\n    - E:E\nE:\n  image: a\nF:\n  links:\n    - E:E\n    - C:C\n";
    private static final String SCENARIO_RECURSIVE_LINKS = "A:\n  links:\n    - B:B\nB:\n  links:\n    - A:A\n";

    @Test
    public void shouldSortNoKnownLinks() throws Exception {
        List sorted = AutoStartOrderUtil.getAutoStartOrder((CubeDockerConfiguration)this.create(SCENARIO_NO_KNOWN_LINK, "A"));
        this.assertExecutionSteps(sorted, new String[][]{{"A"}});
    }

    @Test
    public void shouldSortSingleLink() throws Exception {
        List sorted = AutoStartOrderUtil.getAutoStartOrder((CubeDockerConfiguration)this.create(SCENARIO_SINGLE_LINK, "A"));
        this.assertExecutionSteps(sorted, {"B"}, {"A"});
    }

    @Test
    public void shouldSortSingleNonLinkedRoots() throws Exception {
        List sorted = AutoStartOrderUtil.getAutoStartOrder((CubeDockerConfiguration)this.create(SCENARIO_MULTIPLE_ROOTS, "A"));
        this.assertExecutionSteps(sorted, new String[][]{{"A"}});
    }

    @Test
    public void shouldSortMultipleNonLinkedRoots() throws Exception {
        List sorted = AutoStartOrderUtil.getAutoStartOrder((CubeDockerConfiguration)this.create(SCENARIO_MULTIPLE_ROOTS, "A", "B"));
        this.assertExecutionSteps(sorted, new String[][]{{"A", "B"}});
    }

    @Test
    public void shouldSortMultipleRootWithSingleLinks() throws Exception {
        List sorted = AutoStartOrderUtil.getAutoStartOrder((CubeDockerConfiguration)this.create(SCENARIO_MULTIPLE_ROOTS_AND_SINGLE_LINK, "C", "A"));
        this.assertExecutionSteps(sorted, {"B", "C"}, {"A"});
    }

    @Test
    public void shouldSortSingleRootWithMultipleLinks() throws Exception {
        List sorted = AutoStartOrderUtil.getAutoStartOrder((CubeDockerConfiguration)this.create(SCENARIO_SINGLE_ROOT_AND_MULTIPLE_LINKS, "C", "A"));
        this.assertExecutionSteps(sorted, {"B"}, {"A", "C"});
    }

    @Test
    public void shouldSortSingleRootWithMultipleDependsOn() throws Exception {
        List sorted = AutoStartOrderUtil.getAutoStartOrder((CubeDockerConfiguration)this.create(SCENARIO_SINGLE_ROOT_AND_MULTIPLE_DEPENDS, "C", "A"));
        this.assertExecutionSteps(sorted, {"B"}, {"A", "C"});
    }

    @Test
    public void shouldSortSingleRootWithMultipleDependsOnMustHavePriorityOverLinks() throws Exception {
        List sorted = AutoStartOrderUtil.getAutoStartOrder((CubeDockerConfiguration)this.create(SCENARIO_SINGLE_ROOT_AND_MULTIPLE_DEPENDS_AND_LINK, "C", "A"));
        this.assertExecutionSteps(sorted, {"B"}, {"A", "C"});
    }

    @Test
    public void shouldSortMultiRootWithMultipleLinks() throws Exception {
        List sorted = AutoStartOrderUtil.getAutoStartOrder((CubeDockerConfiguration)this.create(SCENARIO_MULTI_ROOT_AND_MULTIPLE_LINKS, "A", "F"));
        this.assertExecutionSteps(sorted, {"B", "E"}, {"D", "C"}, {"A", "F"});
    }

    @Test
    public void shouldSortInReverseMultiRootWithMultipleLinks() throws Exception {
        List sorted = AutoStartOrderUtil.getAutoStopOrder((CubeDockerConfiguration)this.create(SCENARIO_MULTI_ROOT_AND_MULTIPLE_LINKS, "A", "F"));
        this.assertExecutionSteps(sorted, {"A", "F"}, {"D", "C"}, {"B", "E"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailOnRecursiveLinks() throws Exception {
        AutoStartOrderUtil.getAutoStartOrder((CubeDockerConfiguration)this.create(SCENARIO_RECURSIVE_LINKS, "A", "B"));
    }

    private void assertExecutionSteps(List<String[]> actuals, String[] ... expecteds) {
        Assert.assertEquals((String)"Number of steps to should match", (long)expecteds.length, (long)actuals.size());
        for (int i = 0; i < actuals.size(); ++i) {
            List<String> actual = Arrays.asList(actuals.get(i));
            String[] expected = expecteds[i];
            Assert.assertEquals((String)("Number of cubes in step[" + i + "] should match"), (long)expected.length, (long)actual.size());
            for (String expectedId : expected) {
                Assert.assertTrue((String)("Cube[" + expectedId + "] should have been in step[" + i + "] Found[" + this.join(actual) + "]"), (boolean)actual.contains(expectedId));
            }
        }
    }

    private CubeDockerConfiguration create(String setup, String ... autoStart) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (autoStart != null && autoStart.length > 0) {
            config.put("autoStartContainers", this.join(autoStart));
        }
        config.put("dockerContainers", setup);
        config.put("definitionFormat", DefinitionFormat.CUBE.name());
        return CubeDockerConfiguration.fromMap(config, null);
    }

    private String join(Collection<String> strings) {
        return this.join(strings.toArray(new String[0]));
    }

    private String join(String ... auto) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < auto.length; ++i) {
            sb.append(auto[i]);
            if (i >= auto.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

