/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.util.List;
import org.arquillian.cube.containerobject.Cube;
import org.arquillian.cube.containerobject.Environment;
import org.arquillian.cube.docker.impl.util.ContainerObjectUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class ContainerObjectUtilTest {
    @Test
    public void shouldReturnFirstValue() throws NoSuchMethodException {
        String value = (String)ContainerObjectUtil.getTopCubeAttribute(SecondClassAnnotated.class, (String)"value", Cube.class, (Object)"");
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)"secondValue"));
    }

    @Test
    public void shouldReturnTopValue() throws NoSuchMethodException {
        String value = (String)ContainerObjectUtil.getTopCubeAttribute(FirstClassAnnotated.class, (String)"value", Cube.class, (Object)"");
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)"firstValue"));
    }

    @Test
    public void shouldReturnNullIfNoClassAnnotated() throws NoSuchMethodException {
        String value = (String)ContainerObjectUtil.getTopCubeAttribute(EmptyClassAnnotation.class, (String)"value", Cube.class, (Object)"");
        Assert.assertThat((Object)value, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldReturnParentValueIfClassNotAnnotated() throws NoSuchMethodException {
        String value = (String)ContainerObjectUtil.getTopCubeAttribute(ParentWithAnnotation.class, (String)"value", Cube.class, (Object)"");
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)"secondValue"));
    }

    @Test
    public void shouldReturnDefaultValueInCaseOfDefaults() throws NoSuchMethodException {
        String value = (String)ContainerObjectUtil.getTopCubeAttribute(DefaultAnnotation.class, (String)"value", Cube.class, (Object)"");
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldReturnParentValueIfCurrentIsDefault() throws NoSuchMethodException {
        String value = (String)ContainerObjectUtil.getTopCubeAttribute(DefaultAnnotationWithExtension.class, (String)"value", Cube.class, (Object)"");
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)"secondValue"));
    }

    @Test
    public void shouldReturnArrays() throws NoSuchMethodException {
        String[] ports = (String[])ContainerObjectUtil.getTopCubeAttribute(FirstClassWithArray.class, (String)"portBinding", Cube.class, (Object)new String[0]);
        Assert.assertThat((Object)ports[0], (Matcher)Is.is((Object)"2222->22/tcp"));
    }

    @Test
    public void shouldReturnAnnotationsFromRootObject() {
        List environments = ContainerObjectUtil.getAllAnnotations(SecondEnvironmentAnnotation.class, Environment.class);
        Assert.assertThat((Object)environments.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldReturnAggregationAnnotationsOfAllObjectHierarchy() {
        List environments = ContainerObjectUtil.getAllAnnotations(FirstEnvironmentAnnotation.class, Environment.class);
        Assert.assertThat((Object)environments.size(), (Matcher)Is.is((Object)2));
    }

    @Cube(value="secondValue")
    private static class SecondClassAnnotated {
        private SecondClassAnnotated() {
        }
    }

    @Cube(value="firstValue")
    private static class FirstClassAnnotated
    extends SecondClassAnnotated {
        private FirstClassAnnotated() {
        }
    }

    private static class EmptyClassAnnotation {
        private EmptyClassAnnotation() {
        }
    }

    private static class ParentWithAnnotation
    extends SecondClassAnnotated {
        private ParentWithAnnotation() {
        }
    }

    @Cube
    private static class DefaultAnnotation {
        private DefaultAnnotation() {
        }
    }

    @Cube
    private static class DefaultAnnotationWithExtension
    extends SecondClassAnnotated {
        private DefaultAnnotationWithExtension() {
        }
    }

    @Cube(portBinding={"2222->22/tcp"})
    private static class FirstClassWithArray {
        private FirstClassWithArray() {
        }
    }

    @Environment(key="A", value="B")
    public static class SecondEnvironmentAnnotation {
    }

    @Environment(key="C", value="D")
    public static class FirstEnvironmentAnnotation
    extends SecondEnvironmentAnnotation {
    }
}

