/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.io.IOException;
import org.arquillian.cube.docker.impl.util.Top;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TopTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void shouldStopSpinningIfRunningInsideDocker() throws IOException {
        this.temporaryFolder.newFile("docker.sock");
        this.temporaryFolder.newFile(".dockerenv");
        this.temporaryFolder.newFile(".dockerinit");
        Top top = new Top(this.temporaryFolder.getRoot().getAbsolutePath(), this.temporaryFolder.getRoot().getAbsolutePath());
        Assert.assertThat((Object)top.isSpinning(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotStopSpinningIfRunningInsideDocker() throws IOException {
        this.temporaryFolder.newFile(".dockerenv");
        this.temporaryFolder.newFile(".dockerinit");
        Top top = new Top(this.temporaryFolder.getRoot().getAbsolutePath(), this.temporaryFolder.getRoot().getAbsolutePath());
        Assert.assertThat((Object)top.isSpinning(), (Matcher)Is.is((Object)false));
    }
}

