/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.arquillian.cube.docker.impl.client.DefinitionFormat;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.docker.compose.DockerComposeConverter;
import org.arquillian.cube.docker.impl.docker.cube.CubeConverter;
import org.arquillian.cube.impl.util.IOUtil;

public class DockerContainerDefinitionParser {
    private static final Logger logger = Logger.getLogger(DockerContainerDefinitionParser.class.getName());
    private static final String DEFAULT_CUBE_DEFINITION_FILE = "cube";
    private static final String DEFAULT_DOCKER_COMPOSE_DEFINITION_FILE = "docker-compose";

    private DockerContainerDefinitionParser() {
    }

    public static DockerCompositions convert(Path definitionFilePath, DefinitionFormat definitionFormat) throws IOException {
        switch (definitionFormat) {
            case COMPOSE: {
                DockerComposeConverter dockerComposeConverter = DockerComposeConverter.create(definitionFilePath);
                return dockerComposeConverter.convert();
            }
            case CUBE: {
                CubeConverter cubeConverter = CubeConverter.create(definitionFilePath);
                return cubeConverter.convert();
            }
        }
        CubeConverter cubeConverter = CubeConverter.create(definitionFilePath);
        return cubeConverter.convert();
    }

    public static DockerCompositions convert(DefinitionFormat definitionFormat, URI ... uris) throws IOException {
        DockerCompositions finalDefinition = new DockerCompositions();
        for (URI uri : uris) {
            DockerCompositions convertedDocument = DockerContainerDefinitionParser.convert(uri, definitionFormat);
            finalDefinition.merge(convertedDocument);
        }
        return finalDefinition;
    }

    private static DockerCompositions convert(URI uri, DefinitionFormat definitionFormat) throws IOException {
        try {
            Path definitionFilePath = uri.getScheme() == null ? Paths.get(uri.toString(), new String[0]).toAbsolutePath() : Paths.get(uri);
            return DockerContainerDefinitionParser.convert(definitionFilePath, definitionFormat);
        }
        catch (FileSystemNotFoundException e) {
            String content = "";
            if (uri.isAbsolute()) {
                content = IOUtil.asStringPreservingNewLines((InputStream)uri.toURL().openStream());
            } else {
                String fileContent = uri.toString();
                content = IOUtil.asStringPreservingNewLines((InputStream)new FileInputStream(fileContent));
            }
            return DockerContainerDefinitionParser.convert(content, definitionFormat);
        }
        catch (IllegalArgumentException e) {
            String content = "";
            if (uri.isAbsolute()) {
                content = IOUtil.asStringPreservingNewLines((InputStream)uri.toURL().openStream());
            } else {
                String fileContent = uri.toString();
                content = IOUtil.asStringPreservingNewLines((InputStream)new FileInputStream(fileContent));
            }
            return DockerContainerDefinitionParser.convert(content, definitionFormat);
        }
    }

    public static DockerCompositions convert(String content, DefinitionFormat definitionFormat) {
        switch (definitionFormat) {
            case COMPOSE: {
                DockerComposeConverter dockerComposeConverter = DockerComposeConverter.create(content);
                return dockerComposeConverter.convert();
            }
            case CUBE: {
                CubeConverter cubeConverter = CubeConverter.create(content);
                return cubeConverter.convert();
            }
        }
        CubeConverter cubeConverter = CubeConverter.create(content);
        return cubeConverter.convert();
    }

    public static DockerCompositions convertDefault(DefinitionFormat definitionFormat) throws IOException {
        URI defaultUri = null;
        switch (definitionFormat) {
            case COMPOSE: {
                defaultUri = DockerContainerDefinitionParser.getDefaultFileLocation(DEFAULT_DOCKER_COMPOSE_DEFINITION_FILE);
                break;
            }
            case CUBE: {
                defaultUri = DockerContainerDefinitionParser.getDefaultFileLocation(DEFAULT_CUBE_DEFINITION_FILE);
                break;
            }
            default: {
                defaultUri = DockerContainerDefinitionParser.getDefaultFileLocation(DEFAULT_DOCKER_COMPOSE_DEFINITION_FILE);
            }
        }
        if (defaultUri == null) {
            logger.fine("No Docker container definitions has been found. Probably you have defined some Containers using Container Object pattern and @Cube annotation");
            return new DockerCompositions();
        }
        return DockerContainerDefinitionParser.convert(defaultUri, definitionFormat);
    }

    private static URI getDefaultFileLocation(String filename) {
        URI docker = DockerContainerDefinitionParser.checkSrcTestAndMainResources(filename, "docker");
        if (docker == null && (docker = DockerContainerDefinitionParser.checkRoot(filename)) == null && (docker = DockerContainerDefinitionParser.checkDistributionDirectory(filename)) == null && (docker = DockerContainerDefinitionParser.checkSrcTestAndMainResources(filename, "resources/docker")) == null) {
            docker = DockerContainerDefinitionParser.checkSrcTestAndMainResources(filename, "resources");
        }
        return docker;
    }

    private static URI checkRoot(String filename) {
        Path rootPath = Paths.get(filename, new String[0]);
        Path finalPath = DockerContainerDefinitionParser.resolveDockerDefinition(rootPath);
        if (finalPath != null) {
            return finalPath.toUri();
        }
        return null;
    }

    private static URI checkDistributionDirectory(String filename) {
        Path rootPath = Paths.get("src", "distribution", filename);
        Path finalPath = DockerContainerDefinitionParser.resolveDockerDefinition(rootPath);
        if (finalPath != null) {
            return finalPath.toUri();
        }
        return null;
    }

    static URI checkSrcTestAndMainResources(String filename, String outerDirectory) {
        Path testPath = Paths.get("src", "test", outerDirectory, filename);
        Path testDefinitionPath = DockerContainerDefinitionParser.resolveDockerDefinition(testPath);
        if (testDefinitionPath != null) {
            return testDefinitionPath.toUri();
        }
        Path mainPath = Paths.get("src", "main", outerDirectory, filename);
        Path mainDefinitionPath = DockerContainerDefinitionParser.resolveDockerDefinition(mainPath);
        if (mainDefinitionPath != null) {
            return mainDefinitionPath.toUri();
        }
        return null;
    }

    private static Path resolveDockerDefinition(Path fullpath) {
        Path ymlPath = fullpath.resolveSibling(String.valueOf(fullpath.getFileName()) + ".yml");
        if (Files.exists(ymlPath, new LinkOption[0])) {
            return ymlPath;
        }
        Path yamlPath = fullpath.resolveSibling(String.valueOf(fullpath.getFileName()) + ".yaml");
        if (Files.exists(yamlPath, new LinkOption[0])) {
            return yamlPath;
        }
        return null;
    }
}

