/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.config;

import java.util.ArrayList;
import java.util.Collection;

public class ExposedPort {
    private int exposed;
    private String type = "tcp";

    public ExposedPort(int exposed, String type) {
        this.exposed = exposed;
        if (type != null) {
            this.type = type;
        }
    }

    public ExposedPort(String exp) {
        ExposedPort parsed = ExposedPort.valueOf(exp);
        this.exposed = parsed.exposed;
        this.type = parsed.type;
    }

    public static ExposedPort valueOf(String exp) {
        String type = null;
        String[] parts = exp.split("/");
        int exposed = Integer.parseInt(parts[0].trim());
        if (parts.length > 1) {
            type = parts[1].trim();
        }
        return new ExposedPort(exposed, type);
    }

    public static ExposedPort valueOf(int port) {
        return new ExposedPort(port, null);
    }

    public static Collection<ExposedPort> valuesOf(Collection<String> ports) {
        if (ports == null) {
            return null;
        }
        ArrayList<ExposedPort> result = new ArrayList<ExposedPort>();
        for (String port : ports) {
            result.add(ExposedPort.valueOf(port));
        }
        return result;
    }

    public int getExposed() {
        return this.exposed;
    }

    public void setExposed(int exposed) {
        this.exposed = exposed;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.exposed + "/" + this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.exposed;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExposedPort other = (ExposedPort)obj;
        if (this.exposed != other.exposed) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

