/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.config;

public class Image {
    private String name;
    private String tag;

    public Image(String name, String tag) {
        this.name = name;
        this.tag = tag;
    }

    public Image(String nameAndTag) {
        Image parsed = Image.valueOf(nameAndTag);
        this.name = parsed.name;
        this.tag = parsed.tag;
    }

    public static Image valueOf(String image) {
        Object name = null;
        String tag = null;
        String[] parts = image.split(":");
        switch (parts.length) {
            case 1: {
                name = image;
                break;
            }
            case 2: {
                if (Image.isPort(parts[1])) {
                    name = parts[0] + ":" + parts[1];
                    break;
                }
                name = parts[0];
                tag = parts[1];
                break;
            }
            case 3: {
                name = parts[0] + ":" + parts[1];
                tag = parts[2];
            }
        }
        return new Image((String)name, tag);
    }

    private static boolean isPort(String postColonPart) {
        return postColonPart.contains("/");
    }

    public String getName() {
        return this.name;
    }

    public String getTag() {
        return this.tag;
    }

    public String toImageRef() {
        return this.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Image other = (Image)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
    }

    public String toString() {
        return this.name + (String)(this.tag != null ? ":" + this.tag : "");
    }
}

