/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.config.PortBinding;

public class StarOperator {
    private static Random random = new Random();

    private StarOperator() {
    }

    public static void adaptPortBindingToParallelRun(CubeContainer cubeContainer) {
        Collection<PortBinding> portBindings = cubeContainer.getPortBindings();
        if (portBindings == null) {
            return;
        }
        for (PortBinding portBinding : portBindings) {
            int randomPrivatePort = StarOperator.generateRandomPrivatePort();
            portBinding.setBound(randomPrivatePort);
        }
    }

    public static void adaptLinksToParallelRun(UUID uuid, CubeContainer cubeContainer) {
        Collection<Link> links = cubeContainer.getLinks();
        if (links == null) {
            return;
        }
        for (Link link : links) {
            Collection<String> env;
            if (!link.getName().endsWith("*")) continue;
            String linkTemplate = link.getName().substring(0, link.getName().lastIndexOf(42));
            link.setName(StarOperator.generateNewName(linkTemplate, uuid));
            String environmentVariable = linkTemplate.toUpperCase() + "_HOSTNAME=" + link.getName();
            if (link.isAliasSet()) {
                link.setAlias(StarOperator.generateNewName(link.getAlias(), uuid));
                environmentVariable = linkTemplate.toUpperCase() + "_HOSTNAME=" + link.getAlias();
            }
            if ((env = cubeContainer.getEnv()) != null) {
                if (env.contains(environmentVariable)) {
                    env.remove(environmentVariable);
                }
            } else {
                cubeContainer.setEnv(new ArrayList<String>());
            }
            cubeContainer.getEnv().add(environmentVariable);
        }
    }

    public static void adaptDependenciesToParallelRun(UUID uuid, CubeContainer cubeContainer) {
        Collection<String> dependencies = cubeContainer.getDependsOn();
        if (dependencies == null) {
            return;
        }
        ArrayList<String> adjustedDependsOn = new ArrayList<String>();
        for (String dependency : dependencies) {
            if (dependency.endsWith("*")) {
                String dependencyTemplate = dependency.substring(0, dependency.lastIndexOf(42));
                adjustedDependsOn.add(StarOperator.generateNewName(dependencyTemplate, uuid));
                continue;
            }
            adjustedDependsOn.add(dependency);
        }
        cubeContainer.setDependsOn(adjustedDependsOn);
    }

    public static void adaptNetworksToParalledRun(Map<String, String> networkResolutions, CubeContainer cubeContainer) {
        String networkMode = cubeContainer.getNetworkMode();
        if (networkMode != null && networkResolutions.containsKey(networkMode)) {
            cubeContainer.setNetworkMode(networkResolutions.get(networkMode));
        }
        if (cubeContainer.getNetworks() != null) {
            ArrayList<String> networks = new ArrayList<String>();
            for (String network : cubeContainer.getNetworks()) {
                networks.add(networkResolutions.getOrDefault(network, network));
            }
            cubeContainer.setNetworks(networks);
        }
    }

    public static String generateNewName(String containerName, UUID uuid) {
        return containerName + "_" + String.valueOf(uuid);
    }

    public static int generateRandomPrivatePort() {
        int randomPort = random.nextInt(16383);
        return randomPort + 49152;
    }
}

