/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.docker.compose;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.arquillian.cube.docker.impl.client.config.BuildImage;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.Device;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.client.config.ExposedPort;
import org.arquillian.cube.docker.impl.client.config.Image;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.client.config.RestartPolicy;
import org.arquillian.cube.docker.impl.docker.compose.DockerComposeConverter;
import org.arquillian.cube.docker.impl.docker.compose.GitOperations;
import org.arquillian.cube.docker.impl.util.YamlUtil;

public class ContainerBuilder {
    private static final String IMAGE = "image";
    private static final String BUILD = "build";
    private static final String COMMAND = "command";
    private static final String LINKS = "links";
    private static final String EXTERNAL_LINKS = "external_links";
    private static final String LABELS = "labels";
    private static final String LOG_DRIVER = "log_driver";
    private static final String SECURITY_OPT = "security_opt";
    private static final String DOCKERFILE = "dockerfile";
    private static final String READ_ONLY = "read_only";
    private static final String EXTENDS = "extends";
    private static final String PORTS = "ports";
    private static final String EXPOSE = "expose";
    private static final String VOLUMES = "volumes";
    private static final String VOLUMES_FROM = "volumes_from";
    private static final String ENVIRONMENT = "environment";
    private static final String ENV_FILE = "env_file";
    private static final String NET = "net";
    private static final String DNS = "dns";
    private static final String CAP_ADD = "cap_add";
    private static final String CAP_DROP = "cap_drop";
    private static final String DNS_SEARCH = "dns_search";
    private static final String WORKING_DIR = "working_dir";
    private static final String ENTRYPOINT = "entrypoint";
    private static final String PID = "pid";
    private static final String USER = "user";
    private static final String HOSTNAME = "hostname";
    private static final String DOMAINNAME = "domainname";
    private static final String MEM_LIMIT = "mem_limit";
    private static final String MEM_SWAP_LIMIT = "memswap_limit";
    private static final String SHM_SIZE = "shm_size";
    private static final String PRIVILEGED = "privileged";
    private static final String RESTART = "restart";
    private static final String STDIN_OPEN = "stdin_open";
    private static final String TTY = "tty";
    private static final String CPU_SHARES = "cpu_shares";
    private static final String CPU_SET = "cpuset";
    private static final String CPU_QUOTA = "cpu_quota";
    private static final String EXTRA_HOSTS = "extra_hosts";
    private static final String DEVICES = "devices";
    private static final String CONTAINERNAME = "container_name";
    private static final String DEPENDS_ON = "depends_on";
    private static final String CONTEXT = "context";
    private static final String NETWORKS = "networks";
    private static List<String> AVAILABLE_COMMANDS = Arrays.asList("image", "build", "command", "links", "external_links", "dockerfile", "extends", "ports", "expose", "volumes", "volumes_from", "environment", "env_file", "net", "dns", "cap_add", "cap_drop", "dns_search", "working_dir", "entrypoint", "user", "hostname", "mem_limit", "privileged", "restart", "stdin_open", "tty", "cpuset", "cpu_shares", "cpu_quota", "extra_hosts", "devices", "container_name", "depends_on", "memswap_limit", "shm_size", "networks");
    private static final Logger log = Logger.getLogger(ContainerBuilder.class.getName());
    private Random random = new Random();
    private CubeContainer configuration;
    private Path dockerComposeRootLocation;
    GitOperations gitOperations;

    public ContainerBuilder(Path dockerComposeRootLocation) {
        this(dockerComposeRootLocation, new CubeContainer());
    }

    protected ContainerBuilder(Path dockerComposeRootLocation, CubeContainer configuration) {
        this.dockerComposeRootLocation = dockerComposeRootLocation;
        this.configuration = configuration;
    }

    public CubeContainer build(Map<String, Object> dockerComposeContainerDefinition) {
        return this.build(dockerComposeContainerDefinition, null);
    }

    public CubeContainer build(Map<String, Object> dockerComposeContainerDefinition, String version) {
        Object dns;
        if (dockerComposeContainerDefinition.containsKey(EXTENDS)) {
            Map<String, Object> extendsDefinition = YamlUtil.asMap(dockerComposeContainerDefinition, EXTENDS);
            this.extend(Paths.get(YamlUtil.asString(extendsDefinition, "file"), new String[0]), YamlUtil.asString(extendsDefinition, "service"));
        }
        if (dockerComposeContainerDefinition.containsKey(IMAGE)) {
            this.addImage(YamlUtil.asString(dockerComposeContainerDefinition, IMAGE));
        }
        if (dockerComposeContainerDefinition.containsKey(BUILD)) {
            if ("2".equals(version)) {
                Object o = dockerComposeContainerDefinition.get(BUILD);
                if (o instanceof String) {
                    String dockerfile = dockerComposeContainerDefinition.containsKey(DOCKERFILE) ? YamlUtil.asString(dockerComposeContainerDefinition, DOCKERFILE) : null;
                    this.addBuild(YamlUtil.asString(dockerComposeContainerDefinition, BUILD), dockerfile);
                } else if (o instanceof Map) {
                    String dockerfile;
                    Map<String, Object> buildDefinition = YamlUtil.asMap(dockerComposeContainerDefinition, BUILD);
                    String context = buildDefinition.containsKey(CONTEXT) ? YamlUtil.asString(buildDefinition, CONTEXT) : null;
                    String string = dockerfile = buildDefinition.containsKey(DOCKERFILE) ? YamlUtil.asString(buildDefinition, DOCKERFILE) : null;
                    if (context != null) {
                        File directory = new File(context);
                        if (directory.isDirectory()) {
                            this.addBuild(YamlUtil.asString(buildDefinition, CONTEXT), dockerfile);
                        } else if (this.gitOperations == null) {
                            log.log(Level.INFO, String.format("Starting cloning git repository %s defined in docker-compose", context));
                            GitOperations gitOperations = new GitOperations();
                            File clonedDirectory = gitOperations.cloneRepo(context);
                            log.log(Level.INFO, String.format("Finished cloning git repository %s defined in docker-compose", context));
                            this.addBuild(clonedDirectory.getParentFile().getAbsolutePath(), dockerfile);
                        }
                    } else {
                        log.log(Level.WARNING, "build configuration is provided as object but no context definition is found.");
                    }
                }
            } else {
                String dockerfile = dockerComposeContainerDefinition.containsKey(DOCKERFILE) ? YamlUtil.asString(dockerComposeContainerDefinition, DOCKERFILE) : null;
                this.addBuild(YamlUtil.asString(dockerComposeContainerDefinition, BUILD), dockerfile);
            }
        }
        if (dockerComposeContainerDefinition.containsKey(COMMAND)) {
            if (dockerComposeContainerDefinition.get(COMMAND) instanceof List) {
                this.addCommands(YamlUtil.asListOfString(dockerComposeContainerDefinition, COMMAND));
            } else {
                this.addCommand(YamlUtil.asString(dockerComposeContainerDefinition, COMMAND));
            }
        }
        if (dockerComposeContainerDefinition.containsKey(DEPENDS_ON)) {
            this.addDependsOn(YamlUtil.asListOfString(dockerComposeContainerDefinition, DEPENDS_ON));
        }
        if (dockerComposeContainerDefinition.containsKey(LINKS)) {
            this.addLinks(YamlUtil.asListOfString(dockerComposeContainerDefinition, LINKS));
        }
        if (dockerComposeContainerDefinition.containsKey(EXTERNAL_LINKS)) {
            this.addLinks(YamlUtil.asListOfString(dockerComposeContainerDefinition, EXTERNAL_LINKS));
        }
        if (dockerComposeContainerDefinition.containsKey(PORTS)) {
            this.addPorts(YamlUtil.asListOfString(dockerComposeContainerDefinition, PORTS));
        }
        if (dockerComposeContainerDefinition.containsKey(EXPOSE)) {
            this.addExpose(YamlUtil.asListOfString(dockerComposeContainerDefinition, EXPOSE));
        }
        if (dockerComposeContainerDefinition.containsKey(VOLUMES)) {
            Collection<String> volumes = YamlUtil.asListOfString(dockerComposeContainerDefinition, VOLUMES);
            this.addVolumes(volumes);
            this.addBinds(this.normalizePaths(volumes));
        }
        if (dockerComposeContainerDefinition.containsKey(LABELS)) {
            this.addLabels(YamlUtil.asMapOfStrings(dockerComposeContainerDefinition, LABELS));
        }
        if (dockerComposeContainerDefinition.containsKey(VOLUMES_FROM)) {
            this.addVolumesFrom(YamlUtil.asListOfString(dockerComposeContainerDefinition, VOLUMES_FROM));
        }
        if (dockerComposeContainerDefinition.containsKey(ENVIRONMENT)) {
            try {
                this.addEnvironment(YamlUtil.asListOfString(dockerComposeContainerDefinition, ENVIRONMENT));
            }
            catch (ClassCastException e) {
                this.addEnvironment(YamlUtil.asListOfString(YamlUtil.asMap(dockerComposeContainerDefinition, ENVIRONMENT)));
            }
        }
        if (dockerComposeContainerDefinition.containsKey(ENV_FILE)) {
            if (dockerComposeContainerDefinition.get(ENV_FILE) instanceof List) {
                this.addEnvFile(YamlUtil.asListOfString(dockerComposeContainerDefinition, ENV_FILE));
            } else {
                this.addEnvFile(Arrays.asList(YamlUtil.asString(dockerComposeContainerDefinition, ENV_FILE)));
            }
        }
        if (dockerComposeContainerDefinition.containsKey(NET)) {
            this.addNet(YamlUtil.asString(dockerComposeContainerDefinition, NET));
        }
        if (dockerComposeContainerDefinition.containsKey(EXTRA_HOSTS)) {
            this.addExtraHosts(YamlUtil.asListOfString(dockerComposeContainerDefinition, EXTRA_HOSTS));
        }
        if (dockerComposeContainerDefinition.containsKey(DNS)) {
            dns = dockerComposeContainerDefinition.get(DNS);
            if (dns instanceof List) {
                this.addDns((List)dns);
            } else {
                this.addDns((String)dns);
            }
        }
        if (dockerComposeContainerDefinition.containsKey(CAP_ADD)) {
            this.addCapAdd(YamlUtil.asListOfString(dockerComposeContainerDefinition, CAP_ADD));
        }
        if (dockerComposeContainerDefinition.containsKey(CAP_DROP)) {
            this.addCapDrop(YamlUtil.asListOfString(dockerComposeContainerDefinition, CAP_DROP));
        }
        if (dockerComposeContainerDefinition.containsKey(DNS_SEARCH)) {
            dns = dockerComposeContainerDefinition.get(DNS_SEARCH);
            if (dns instanceof List) {
                this.addDnsSearch((List)dns);
            } else {
                this.addDnsSearch((String)dns);
            }
        }
        if (dockerComposeContainerDefinition.containsKey(WORKING_DIR)) {
            this.addWorkingDir(YamlUtil.asString(dockerComposeContainerDefinition, WORKING_DIR));
        }
        if (dockerComposeContainerDefinition.containsKey(ENTRYPOINT)) {
            try {
                this.addEntrypoint(YamlUtil.asString(dockerComposeContainerDefinition, ENTRYPOINT));
            }
            catch (ClassCastException e) {
                this.addEntrypoint(YamlUtil.asListOfString(dockerComposeContainerDefinition, ENTRYPOINT));
            }
        }
        if (dockerComposeContainerDefinition.containsKey(USER)) {
            this.addUser(YamlUtil.asString(dockerComposeContainerDefinition, USER));
        }
        if (dockerComposeContainerDefinition.containsKey(HOSTNAME)) {
            this.addHostname(YamlUtil.asString(dockerComposeContainerDefinition, HOSTNAME));
        }
        if (dockerComposeContainerDefinition.containsKey(MEM_LIMIT)) {
            this.addMemLimit(YamlUtil.asLong(dockerComposeContainerDefinition, MEM_LIMIT));
        }
        if (dockerComposeContainerDefinition.containsKey(MEM_SWAP_LIMIT)) {
            this.addMemSwapLimit(YamlUtil.asLong(dockerComposeContainerDefinition, MEM_SWAP_LIMIT));
        }
        if (dockerComposeContainerDefinition.containsKey(SHM_SIZE)) {
            this.addShmSize(YamlUtil.asLong(dockerComposeContainerDefinition, SHM_SIZE));
        }
        if (dockerComposeContainerDefinition.containsKey(PRIVILEGED)) {
            this.addPrivileged(YamlUtil.asBoolean(dockerComposeContainerDefinition, PRIVILEGED));
        }
        if (dockerComposeContainerDefinition.containsKey(RESTART)) {
            this.addRestart(YamlUtil.asString(dockerComposeContainerDefinition, RESTART));
        }
        if (dockerComposeContainerDefinition.containsKey(STDIN_OPEN)) {
            this.addStdinOpen(YamlUtil.asBoolean(dockerComposeContainerDefinition, STDIN_OPEN));
        }
        if (dockerComposeContainerDefinition.containsKey(TTY)) {
            this.addTty(YamlUtil.asBoolean(dockerComposeContainerDefinition, TTY));
        }
        if (dockerComposeContainerDefinition.containsKey(CPU_SHARES)) {
            this.addCpuShares(YamlUtil.asInt(dockerComposeContainerDefinition, CPU_SHARES));
        }
        if (dockerComposeContainerDefinition.containsKey(CPU_SET)) {
            this.addCpuSet(YamlUtil.asString(dockerComposeContainerDefinition, CPU_SET));
        }
        if (dockerComposeContainerDefinition.containsKey(CPU_QUOTA)) {
            this.addCpuQuota(YamlUtil.asInt(dockerComposeContainerDefinition, CPU_QUOTA));
        }
        if (dockerComposeContainerDefinition.containsKey(DEVICES)) {
            this.addDevices(YamlUtil.asListOfString(dockerComposeContainerDefinition, DEVICES));
        }
        if (dockerComposeContainerDefinition.containsKey(DOMAINNAME)) {
            this.addDomainName(YamlUtil.asString(dockerComposeContainerDefinition, DOMAINNAME));
        }
        if (dockerComposeContainerDefinition.containsKey(READ_ONLY)) {
            this.addReadOnly(YamlUtil.asBoolean(dockerComposeContainerDefinition, READ_ONLY));
        }
        if (dockerComposeContainerDefinition.containsKey(CONTAINERNAME)) {
            this.addContainerName(YamlUtil.asString(dockerComposeContainerDefinition, CONTAINERNAME));
        }
        if (dockerComposeContainerDefinition.containsKey(NETWORKS)) {
            if (dockerComposeContainerDefinition.get(NETWORKS) instanceof ArrayList) {
                this.addNetworks(YamlUtil.asListOfString(dockerComposeContainerDefinition, NETWORKS));
            } else {
                Map<String, Object> networks = YamlUtil.asMap(dockerComposeContainerDefinition, NETWORKS);
                this.addNetworks(networks.keySet());
            }
        }
        this.logUnsupportedOperations(dockerComposeContainerDefinition.keySet());
        return this.build();
    }

    private Collection<String> normalizePaths(Collection<String> volumes) {
        ArrayList<String> expanded = new ArrayList<String>(volumes.size());
        for (String volume : volumes) {
            String[] split = volume.split(":");
            try {
                expanded.add(volume.replace(split[0], this.normalizePath(split[0])));
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed to normalize volume: " + volume, e);
                expanded.add(volume);
            }
        }
        return expanded;
    }

    private String normalizePath(String bind) throws IOException {
        Object absolutePath;
        if (bind.startsWith("//")) {
            bind = bind.substring(2).replaceFirst("/", ":/");
        }
        if (':' == ((String)(absolutePath = new File(bind).getCanonicalPath().replace("\\", "/"))).charAt(1)) {
            absolutePath = "//" + ((String)absolutePath).replaceFirst(":", "");
        }
        return absolutePath;
    }

    private ContainerBuilder addNetworks(Collection<String> networks) {
        if (this.configuration.getNetworks() != null) {
            this.configuration.getNetworks().addAll(networks);
        } else {
            this.configuration.setNetworks(new HashSet<String>(networks));
        }
        return this;
    }

    private ContainerBuilder addShmSize(long shmSize) {
        this.configuration.setShmSize(shmSize);
        return this;
    }

    private ContainerBuilder addMemSwapLimit(long memSwapLimit) {
        this.configuration.setMemorySwap(memSwapLimit);
        return this;
    }

    private ContainerBuilder addDevices(Collection<String> devices) {
        HashSet<Device> devicesDefinition = new HashSet<Device>();
        for (String device : devices) {
            String[] deviceSplitted = device.split(":");
            Device def = new Device();
            switch (deviceSplitted.length) {
                case 3: {
                    def.setcGroupPermissions(deviceSplitted[2]);
                }
                case 2: {
                    def.setPathOnHost(deviceSplitted[0]);
                    def.setPathInContainer(deviceSplitted[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Device definition %s is incorrect. It should follow the format <hostPath>:<containerPath>:(optional)<permissions>", device));
                }
            }
            devicesDefinition.add(def);
        }
        this.configuration.setDevices(devicesDefinition);
        return this;
    }

    public ContainerBuilder addExtraHosts(Collection<String> extraHosts) {
        if (this.configuration.getExtraHosts() != null) {
            Collection<String> oldExtraHosts = this.configuration.getExtraHosts();
            oldExtraHosts.addAll(extraHosts);
        } else {
            this.configuration.setExtraHosts(new HashSet<String>(extraHosts));
        }
        return this;
    }

    public ContainerBuilder addImage(String image) {
        this.configuration.setImage(Image.valueOf(image));
        return this;
    }

    public ContainerBuilder addContainerName(String name) {
        this.configuration.setContainerName(name);
        return this;
    }

    public ContainerBuilder addReadOnly(boolean b) {
        this.configuration.setReadonlyRootfs(b);
        return this;
    }

    public ContainerBuilder addBuild(String buildPath, String dockerfile) {
        Path calculatedPath;
        Path buildPathPath = Paths.get(buildPath, new String[0]);
        if (buildPathPath.isAbsolute()) {
            calculatedPath = buildPathPath;
        } else {
            Path fullDirectory = this.dockerComposeRootLocation.resolve(buildPath);
            calculatedPath = this.dockerComposeRootLocation.relativize(fullDirectory);
        }
        BuildImage buildImage = new BuildImage(calculatedPath.toString(), dockerfile, true, true);
        this.configuration.setBuildImage(buildImage);
        return this;
    }

    public ContainerBuilder addCommand(String command) {
        this.addCommands(Arrays.asList(command.split("\\ ")));
        return this;
    }

    public ContainerBuilder addCommands(Collection<String> commands) {
        this.configuration.setCmd(commands);
        return this;
    }

    public ContainerBuilder addDependsOn(Collection<String> dependsOn) {
        HashSet<String> listOfDependsOn = new HashSet<String>();
        for (String link : dependsOn) {
            listOfDependsOn.add(link);
        }
        if (this.configuration.getDependsOn() != null) {
            Collection<String> oldDependsOn = this.configuration.getDependsOn();
            oldDependsOn.addAll(listOfDependsOn);
        } else {
            this.configuration.setDependsOn(listOfDependsOn);
        }
        return this;
    }

    public ContainerBuilder addLinks(Collection<String> links) {
        HashSet<Link> listOfLinks = new HashSet<Link>();
        for (String link : links) {
            listOfLinks.add(Link.valueOf(link));
        }
        if (this.configuration.getLinks() != null) {
            Collection<Link> oldLinks = this.configuration.getLinks();
            oldLinks.addAll(listOfLinks);
        } else {
            this.configuration.setLinks(listOfLinks);
        }
        return this;
    }

    public ContainerBuilder addPorts(Collection<String> ports) {
        HashSet<PortBinding> listOfPorts = new HashSet<PortBinding>();
        for (String port : ports) {
            String[] elements = port.split(":");
            switch (elements.length) {
                case 1: {
                    if (port.contains("-")) {
                        this.getExpandedPorts(port).stream().forEach(expandedPort -> listOfPorts.add(PortBinding.valueOf(this.getRandomPort() + "->" + expandedPort)));
                        break;
                    }
                    listOfPorts.add(PortBinding.valueOf(this.getRandomPort() + "->" + elements[0]));
                    break;
                }
                case 2: {
                    if (port.contains("-")) {
                        listOfPorts.addAll(this.addPairPortRange(elements[0], elements[1], null));
                        break;
                    }
                    listOfPorts.add(PortBinding.valueOf(port.replaceAll(":", "->")));
                    break;
                }
                case 3: {
                    if (port.contains("-")) {
                        listOfPorts.addAll(this.addPairPortRange(elements[1], elements[2], elements[0]));
                        break;
                    }
                    listOfPorts.add(PortBinding.valueOf(elements[0] + ":" + elements[1] + "->" + elements[2]));
                }
            }
        }
        if (this.configuration.getPortBindings() != null) {
            Collection<PortBinding> oldPortBindings = this.configuration.getPortBindings();
            oldPortBindings.addAll(listOfPorts);
        } else {
            this.configuration.setPortBindings(listOfPorts);
        }
        return this;
    }

    private Collection<PortBinding> addPairPortRange(String hostRangePorts, String containerRangePorts, String host) {
        ArrayList<PortBinding> listOfPorts = new ArrayList<PortBinding>();
        List<String> expandedHostPorts = this.getExpandedPorts(hostRangePorts);
        List<String> expandedContainerPorts = this.getExpandedPorts(containerRangePorts);
        if (expandedContainerPorts.size() != expandedHostPorts.size()) {
            throw new IllegalArgumentException("Port ranges from host and container side should contain same number of ports");
        }
        for (int i = 0; i < expandedHostPorts.size(); ++i) {
            if (host == null) {
                listOfPorts.add(PortBinding.valueOf(expandedHostPorts.get(i) + "->" + expandedContainerPorts.get(i)));
                continue;
            }
            listOfPorts.add(PortBinding.valueOf(host + ":" + expandedHostPorts.get(i) + "->" + expandedContainerPorts.get(i)));
        }
        return listOfPorts;
    }

    private List<String> getExpandedPorts(String expression) {
        String[] portRange = expression.split("-");
        if (portRange.length != 2) {
            throw new IllegalArgumentException("Expected Port Range expression but found " + expression);
        }
        int initialPort = Integer.parseInt(portRange[0].trim());
        int endPort = Integer.parseInt(portRange[1].trim()) + 1;
        return IntStream.range(initialPort, endPort).boxed().map(String::valueOf).collect(Collectors.toList());
    }

    public ContainerBuilder addExpose(Collection<String> exposes) {
        HashSet<ExposedPort> ports = new HashSet<ExposedPort>();
        for (String exposed : exposes) {
            ports.add(ExposedPort.valueOf(exposed));
        }
        if (this.configuration.getExposedPorts() != null) {
            Collection<ExposedPort> oldExposedPorts = this.configuration.getExposedPorts();
            oldExposedPorts.addAll(ports);
        } else {
            this.configuration.setExposedPorts(ports);
        }
        return this;
    }

    public ContainerBuilder addVolumes(Collection<String> volumes) {
        if (this.configuration.getVolumes() != null) {
            Collection<String> oldVolumes = this.configuration.getVolumes();
            oldVolumes.addAll(volumes);
        } else {
            this.configuration.setVolumes(new HashSet<String>(volumes));
        }
        return this;
    }

    public ContainerBuilder addBinds(Collection<String> volumes) {
        if (this.configuration.getBinds() != null) {
            Collection<String> oldBinds = this.configuration.getBinds();
            oldBinds.addAll(volumes);
        } else {
            this.configuration.setBinds(new HashSet<String>(volumes));
        }
        return this;
    }

    public ContainerBuilder addVolumesFrom(Collection<String> volumesFrom) {
        if (this.configuration.getVolumesFrom() != null) {
            Collection<String> oldVolumes = this.configuration.getVolumesFrom();
            oldVolumes.addAll(volumesFrom);
        } else {
            this.configuration.setVolumesFrom(new HashSet<String>(volumesFrom));
        }
        return this;
    }

    public ContainerBuilder addLabels(Map<String, String> labels) {
        if (this.configuration.getLabels() != null) {
            Map<String, String> oldLabels = this.configuration.getLabels();
            oldLabels.putAll(labels);
        } else {
            this.configuration.setLabels(labels);
        }
        return this;
    }

    public ContainerBuilder addEnvironment(Collection<String> environments) {
        this.addEnvironment(this.getProperties(environments));
        return this;
    }

    private void addEnvironment(Properties properties) {
        if (this.configuration.getEnv() != null) {
            Properties oldProperties = this.getProperties(this.configuration.getEnv());
            oldProperties.putAll((Map<?, ?>)properties);
            this.configuration.setEnv(this.toEnvironment(oldProperties));
        } else {
            this.configuration.setEnv(this.toEnvironment(properties));
        }
    }

    public ContainerBuilder addEnvFile(Collection<String> environmentPaths) {
        for (String environmentPath : environmentPaths) {
            try {
                Properties properties = new Properties();
                Path environmentLocation = Paths.get(environmentPath, new String[0]);
                File environmentFile = this.dockerComposeRootLocation.resolve(environmentLocation).toFile();
                FileInputStream inStream = new FileInputStream(environmentFile);
                properties.load(inStream);
                inStream.close();
                this.addEnvironment(properties);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this;
    }

    public ContainerBuilder addNet(String net) {
        this.configuration.setNetworkMode(net);
        return this;
    }

    public ContainerBuilder addDns(String dns) {
        this.configuration.setDns(Arrays.asList(dns));
        return this;
    }

    public ContainerBuilder addDns(Collection<String> dns) {
        if (this.configuration.getDns() != null) {
            Collection<String> oldDns = this.configuration.getDns();
            oldDns.addAll(dns);
        } else {
            this.configuration.setDns(new HashSet<String>(dns));
        }
        return this;
    }

    public ContainerBuilder addCapAdd(Collection<String> capAdds) {
        if (this.configuration.getCapAdd() != null) {
            Collection<String> oldCapAdd = this.configuration.getCapAdd();
            oldCapAdd.addAll(capAdds);
        } else {
            this.configuration.setCapAdd(new HashSet<String>(capAdds));
        }
        return this;
    }

    public ContainerBuilder addCapDrop(Collection<String> capDrops) {
        if (this.configuration.getCapDrop() != null) {
            Collection<String> oldCapDrops = this.configuration.getCapDrop();
            oldCapDrops.addAll(capDrops);
        } else {
            this.configuration.setCapDrop(new HashSet<String>(capDrops));
        }
        return this;
    }

    public ContainerBuilder addDnsSearch(String dnsSearch) {
        this.configuration.setDnsSearch(Arrays.asList(dnsSearch));
        return this;
    }

    public ContainerBuilder addDnsSearch(Collection<String> dnsSearch) {
        if (this.configuration.getDnsSearch() != null) {
            Collection<String> oldDnsSearch = this.configuration.getDnsSearch();
            oldDnsSearch.addAll(dnsSearch);
        } else {
            this.configuration.setDnsSearch(new HashSet<String>(dnsSearch));
        }
        return this;
    }

    public ContainerBuilder addCpuShares(int cpuShares) {
        this.configuration.setCpuShares(cpuShares);
        return this;
    }

    private ContainerBuilder addCpuSet(String cpuSet) {
        this.configuration.setCpuSet(cpuSet);
        return this;
    }

    public ContainerBuilder addCpuQuota(int cpuQuota) {
        this.configuration.setCpuQuota(cpuQuota);
        return this;
    }

    public ContainerBuilder addTty(boolean tty) {
        this.configuration.setTty(tty);
        return this;
    }

    public ContainerBuilder addStdinOpen(boolean stdinOpen) {
        this.configuration.setStdinOpen(stdinOpen);
        return this;
    }

    public ContainerBuilder extend(Path location, String service) {
        Path extendLocation = this.dockerComposeRootLocation.resolve(location);
        DockerCompositions dockerCompositions = DockerComposeConverter.create(extendLocation).convert();
        CubeContainer cubeContainer = dockerCompositions.getContainers().get(service);
        if (cubeContainer == null) {
            throw new IllegalArgumentException(String.format("Service name %s is not present at %s", service, extendLocation.toAbsolutePath()));
        }
        ContainerBuilder containerBuilder = new ContainerBuilder(this.dockerComposeRootLocation, this.configuration);
        this.configuration.merge(cubeContainer);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ContainerBuilder addRestart(String restart) {
        RestartPolicy restartPolicy = new RestartPolicy();
        if (restart.startsWith("on-failure")) {
            String[] element = restart.split(":");
            if (element.length == 1) {
                restartPolicy.setName(restart);
                restartPolicy.setMaximumRetryCount(0);
            } else {
                if (element.length != 2) throw new IllegalArgumentException("on-failure restart should be on-failure or with optional retries on-failure:retries");
                restartPolicy.setName(element[0]);
                restartPolicy.setMaximumRetryCount(Integer.parseInt(element[1]));
            }
        } else {
            restartPolicy.setName(restart);
        }
        this.configuration.setRestartPolicy(restartPolicy);
        return this;
    }

    public ContainerBuilder addPrivileged(boolean privileged) {
        this.configuration.setPrivileged(privileged);
        return this;
    }

    public ContainerBuilder addMemLimit(Long memLimit) {
        this.configuration.setMemoryLimit(memLimit);
        return this;
    }

    public ContainerBuilder addDomainName(String domainName) {
        this.configuration.setDomainName(domainName);
        return this;
    }

    public ContainerBuilder addHostname(String hostname) {
        this.configuration.setHostName(hostname);
        return this;
    }

    public ContainerBuilder addUser(String user) {
        this.configuration.setUser(user);
        return this;
    }

    public ContainerBuilder addEntrypoint(String entrypoint) {
        this.configuration.setEntryPoint(Arrays.asList(entrypoint));
        return this;
    }

    public ContainerBuilder addEntrypoint(Collection<String> entrypoint) {
        this.configuration.setEntryPoint(entrypoint);
        return this;
    }

    public ContainerBuilder addWorkingDir(String workingDir) {
        this.configuration.setWorkingDir(workingDir);
        return this;
    }

    public CubeContainer buildFromExtension() {
        return this.configuration;
    }

    public CubeContainer build() {
        return this.configuration;
    }

    private String getRandomPort() {
        int shiftedRandomPort = this.random.nextInt(28232);
        return Integer.toString(shiftedRandomPort + 32768);
    }

    private Properties getProperties(Collection<String> properties) {
        Properties allProperties = new Properties();
        for (String property : properties) {
            int keySeparator = property.indexOf("=");
            allProperties.put(property.substring(0, keySeparator), property.substring(keySeparator + 1, property.length()));
        }
        return allProperties;
    }

    private Collection<String> toEnvironment(Properties properties) {
        HashSet<String> listOfEnvironment = new HashSet<String>();
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            listOfEnvironment.add(String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue()));
        }
        return listOfEnvironment;
    }

    private void logUnsupportedOperations(Set<String> keys) {
        for (String key : keys) {
            if (AVAILABLE_COMMANDS.contains(key)) continue;
            log.info(String.format("Key: %s is not implemented in Cube.", keys));
        }
    }
}

