/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.istio.impl;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientFactory;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.arquillian.cube.istio.impl.IstioClientAdapter;
import org.arquillian.cube.istio.impl.IstioResource;
import org.arquillian.cube.kubernetes.impl.utils.ResourceFilter;
import org.awaitility.Awaitility;

public class IstioAssistant {
    private final HttpClient.Factory httpClientFactory = new JdkHttpClientFactory();
    private final HttpClient httpClient = this.httpClientFactory.newBuilder().build();
    private final IstioClientAdapter istioClientAdapter;

    public IstioAssistant(IstioClientAdapter istioClientAdapter) {
        this.istioClientAdapter = istioClientAdapter;
    }

    public List<IstioResource> deployIstioResources(InputStream inputStream) {
        return this.istioClientAdapter.registerCustomResources(inputStream);
    }

    public void undeployIstioResource(IstioResource istioResource) {
        this.istioClientAdapter.unregisterCustomResource(istioResource);
    }

    public void undeployIstioResources(List<IstioResource> istioResources) {
        for (IstioResource istioResource : istioResources) {
            this.undeployIstioResource(istioResource);
        }
    }

    public List<IstioResource> deployIstioResources(URL ... urls) throws IOException {
        ArrayList<IstioResource> istioResources = new ArrayList<IstioResource>();
        for (URL url : urls) {
            try (InputStream inputStream = url.openStream();){
                istioResources.addAll(this.deployIstioResources(inputStream));
            }
        }
        return istioResources;
    }

    public List<IstioResource> deployIstioResourcesFromClasspathPattern(String pattern) {
        ArrayList<IstioResource> istioResources = new ArrayList<IstioResource>();
        FastClasspathScanner fastClasspathScanner = new FastClasspathScanner(new String[0]);
        fastClasspathScanner.matchFilenamePattern(pattern, (relativePath, inputStream, lengthBytes) -> {
            istioResources.addAll(this.deployIstioResources(inputStream));
            inputStream.close();
        }).scan();
        return istioResources;
    }

    public List<IstioResource> deployIstioResources(Path directory) throws IOException {
        ArrayList<IstioResource> istioResources = new ArrayList<IstioResource>();
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s should be a directory", directory));
        }
        Files.list(directory).filter(ResourceFilter::filterKubernetesResource).map(p -> {
            try {
                return Files.newInputStream(p, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }).forEach(is -> {
            try {
                istioResources.addAll(this.deployIstioResources((InputStream)is));
                is.close();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        });
        return istioResources;
    }

    public List<IstioResource> deployIstioResources(String content) {
        return this.istioClientAdapter.registerCustomResources(content);
    }

    public void await(URL url, Function<HttpResponse<String>, Boolean> checker) throws URISyntaxException {
        HttpRequest request = this.httpClient.newHttpRequestBuilder().uri(url.toURI().toString()).build();
        this.await(request, checker);
    }

    public void await(HttpRequest request, Function<HttpResponse<String>, Boolean> checker) {
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).ignoreExceptions().until(() -> (Boolean)checker.apply((HttpResponse)this.httpClient.sendAsync(request, String.class).get()));
    }
}

