/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.istio.impl;

import io.fabric8.istio.client.IstioClient;
import io.fabric8.istio.client.V1alpha3APIGroupDSL;
import io.fabric8.istio.client.V1beta1APIGroupDSL;
import io.fabric8.kubernetes.api.model.APIGroup;
import io.fabric8.kubernetes.api.model.APIGroupList;
import io.fabric8.kubernetes.api.model.APIResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.http.HttpClient;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.arquillian.cube.istio.impl.IstioResource;
import org.arquillian.cube.istio.impl.IstioResourceList;

public class IstioClientAdapter
implements IstioClient {
    private final IstioClient istioClient;
    private final MixedOperation<IstioResource, IstioResourceList, Resource<IstioResource>> resourceOperation;

    public IstioClientAdapter(IstioClient istioClient) {
        this.istioClient = istioClient;
        this.resourceOperation = istioClient.resources(IstioResource.class, IstioResourceList.class);
    }

    public List<IstioResource> registerCustomResources(InputStream resource) {
        return Collections.singletonList((IstioResource)((Object)((Resource)this.resourceOperation.load(resource)).create()));
    }

    public List<IstioResource> registerCustomResources(String resource) {
        return Collections.singletonList((IstioResource)((Object)((Resource)this.resourceOperation.load(resource)).create()));
    }

    public Boolean unregisterCustomResource(IstioResource istioResource) {
        return ((Resource)this.resourceOperation.resource((Object)istioResource)).delete().stream().allMatch(d -> d.getCauses().isEmpty());
    }

    public IstioClient unwrap() {
        return this.istioClient;
    }

    public V1beta1APIGroupDSL v1beta1() {
        return this.unwrap().v1beta1();
    }

    public V1alpha3APIGroupDSL v1alpha3() {
        return this.unwrap().v1alpha3();
    }

    public <C extends Client> Boolean isAdaptable(Class<C> type) {
        return this.unwrap().isAdaptable(type);
    }

    public <R extends KubernetesResource> boolean supports(Class<R> type) {
        return this.unwrap().supports(type);
    }

    public boolean supports(String apiVersion, String kind) {
        return this.unwrap().supports(apiVersion, kind);
    }

    public boolean hasApiGroup(String apiGroup, boolean exact) {
        return this.unwrap().hasApiGroup(apiGroup, exact);
    }

    public <C extends Client> C adapt(Class<C> type) {
        return (C)this.unwrap().adapt(type);
    }

    public URL getMasterUrl() {
        return this.unwrap().getMasterUrl();
    }

    public String getApiVersion() {
        return this.unwrap().getApiVersion();
    }

    public String getNamespace() {
        return this.unwrap().getNamespace();
    }

    public RootPaths rootPaths() {
        return this.unwrap().rootPaths();
    }

    public boolean supportsApiPath(String path) {
        return this.unwrap().supportsApiPath(path);
    }

    public void close() {
        this.unwrap().close();
    }

    public APIGroupList getApiGroups() {
        return this.unwrap().getApiGroups();
    }

    public APIGroup getApiGroup(String name) {
        return this.unwrap().getApiGroup(name);
    }

    public APIResourceList getApiResources(String groupVersion) {
        return this.unwrap().getApiResources(groupVersion);
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> MixedOperation<T, L, R> resources(Class<T> resourceType, Class<L> listClass, Class<R> resourceClass) {
        return this.unwrap().resources(resourceType, listClass, resourceClass);
    }

    public Client newClient(RequestConfig requestConfig) {
        return this.unwrap().newClient(requestConfig);
    }

    public HttpClient getHttpClient() {
        return this.unwrap().getHttpClient();
    }

    public Config getConfiguration() {
        return this.unwrap().getConfiguration();
    }

    public String raw(String uri, String method, Object payload) {
        return this.unwrap().raw(uri, method, payload);
    }
}

