/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.istio.impl;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.istio.api.RestoreIstioResource;
import org.arquillian.cube.istio.impl.IstioClientAdapter;
import org.arquillian.cube.istio.impl.IstioResource;
import org.arquillian.cube.istio.impl.IstioResourcesApplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class IstioResourcesApplierTest {
    @Mock
    private IstioClientAdapter istioClientAdapter;
    @Mock
    private IstioResource istioResource;
    @Mock
    private IstioResource istioResource2;
    @Mock
    private ObjectMeta meta;
    @Mock
    private ObjectMeta meta2;

    @Test
    public void should_apply_tests_with_istio_resources() {
        BeforeClass beforeClass = new BeforeClass(TestWithIstioResource.class);
        IstioResourcesApplier istioResourceApplier = this.createIstioResourceApplier();
        Mockito.when((Object)this.istioClientAdapter.registerCustomResources((InputStream)ArgumentMatchers.any(InputStream.class))).thenReturn(Arrays.asList(this.istioResource));
        istioResourceApplier.applyIstioResourcesAtClassScope(beforeClass, this.istioClientAdapter);
        ((IstioClientAdapter)Mockito.verify((Object)this.istioClientAdapter, (VerificationMode)Mockito.times((int)1))).registerCustomResources((InputStream)ArgumentMatchers.any(InputStream.class));
        ((MapAssert)Assertions.assertThat((Map)istioResourceApplier.getResourcesMap()).hasSize(1)).containsValue(Collections.singletonList(this.istioResource));
        Assertions.assertThat((Map)istioResourceApplier.getRestoredResourcesMap()).hasSize(0);
    }

    @Test
    public void should_apply_tests_with_istio_resources_and_restore() {
        BeforeClass beforeClass = new BeforeClass(TestWithIstioResourceAndRestore.class);
        IstioResourcesApplier istioResourceApplier = this.createIstioResourceApplier();
        Mockito.when((Object)this.istioClientAdapter.registerCustomResources((InputStream)ArgumentMatchers.any(InputStream.class))).thenReturn(Arrays.asList(this.istioResource));
        istioResourceApplier.applyIstioResourcesAtClassScope(beforeClass, this.istioClientAdapter);
        ((IstioClientAdapter)Mockito.verify((Object)this.istioClientAdapter, (VerificationMode)Mockito.times((int)1))).registerCustomResources((InputStream)ArgumentMatchers.any(InputStream.class));
        ((MapAssert)Assertions.assertThat((Map)istioResourceApplier.getResourcesMap()).isNotNull()).containsValue(Arrays.asList(this.istioResource));
        Assertions.assertThat((Map)istioResourceApplier.getRestoredResourcesMap()).hasSize(0);
    }

    @Test
    public void should_delete_registered_istio_resources() {
        BeforeClass beforeClass = new BeforeClass(TestWithIstioResource.class);
        IstioResourcesApplier istioResourceApplier = this.createIstioResourceApplier();
        Mockito.when((Object)this.istioClientAdapter.registerCustomResources((InputStream)ArgumentMatchers.any(InputStream.class))).thenReturn(Arrays.asList(this.istioResource));
        istioResourceApplier.applyIstioResourcesAtClassScope(beforeClass, this.istioClientAdapter);
        istioResourceApplier.removeIstioResourcesAtClassScope(new AfterClass(TestWithIstioResource.class), this.istioClientAdapter);
        ((IstioClientAdapter)Mockito.verify((Object)this.istioClientAdapter, (VerificationMode)Mockito.times((int)1))).unregisterCustomResource(this.istioResource);
    }

    @Test
    public void should_delete_registered_istio_resources_and_restore() {
        BeforeClass beforeClass = new BeforeClass(TestWithIstioResourceAndRestore.class);
        IstioResourcesApplier istioResourceApplier = this.createIstioResourceApplier();
        Mockito.when((Object)this.istioClientAdapter.registerCustomResources((InputStream)ArgumentMatchers.any(InputStream.class))).thenReturn(Arrays.asList(this.istioResource));
        istioResourceApplier.applyIstioResourcesAtClassScope(beforeClass, this.istioClientAdapter);
        istioResourceApplier.removeIstioResourcesAtClassScope(new AfterClass(TestWithIstioResourceAndRestore.class), this.istioClientAdapter);
        ((IstioClientAdapter)Mockito.verify((Object)this.istioClientAdapter, (VerificationMode)Mockito.times((int)2))).registerCustomResources((InputStream)ArgumentMatchers.any(InputStream.class));
        ((IstioClientAdapter)Mockito.verify((Object)this.istioClientAdapter, (VerificationMode)Mockito.times((int)0))).unregisterCustomResource(this.istioResource);
    }

    @Test
    public void should_delete_registered_istio_resources_and_not_restore_if_resource_is_different() {
        BeforeClass beforeClass = new BeforeClass(TestWithIstioResourceAndRestore.class);
        IstioResourcesApplier istioResourceApplier = this.createIstioResourceApplier();
        Mockito.when((Object)this.istioClientAdapter.registerCustomResources((InputStream)ArgumentMatchers.any(InputStream.class))).thenReturn(Arrays.asList(this.istioResource), (Object[])new List[]{Arrays.asList(this.istioResource2)});
        istioResourceApplier.applyIstioResourcesAtClassScope(beforeClass, this.istioClientAdapter);
        istioResourceApplier.removeIstioResourcesAtClassScope(new AfterClass(TestWithIstioResourceAndRestore.class), this.istioClientAdapter);
        ((IstioClientAdapter)Mockito.verify((Object)this.istioClientAdapter, (VerificationMode)Mockito.times((int)2))).registerCustomResources((InputStream)ArgumentMatchers.any(InputStream.class));
        ((IstioClientAdapter)Mockito.verify((Object)this.istioClientAdapter, (VerificationMode)Mockito.times((int)1))).unregisterCustomResource(this.istioResource);
    }

    private IstioResourcesApplier createIstioResourceApplier() {
        Mockito.when((Object)this.istioResource.getMetadata()).thenReturn((Object)this.meta);
        Mockito.when((Object)this.meta.getName()).thenReturn((Object)"recommendation");
        Mockito.when((Object)this.meta.getNamespace()).thenReturn((Object)"tutorial");
        Mockito.when((Object)this.istioResource2.getMetadata()).thenReturn((Object)this.meta2);
        Mockito.when((Object)this.meta2.getName()).thenReturn((Object)"different");
        Mockito.lenient().when((Object)this.meta2.getNamespace()).thenReturn((Object)"tutorial");
        Mockito.when((Object)this.istioClientAdapter.unregisterCustomResource((IstioResource)ArgumentMatchers.any(IstioResource.class))).thenReturn((Object)true);
        return new IstioResourcesApplier();
    }

    @org.arquillian.cube.istio.api.IstioResource(value="classpath:virtual-service.yml")
    class TestWithIstioResource {
        TestWithIstioResource() {
        }
    }

    @org.arquillian.cube.istio.api.IstioResource(value="classpath:virtual-service.yml")
    @RestoreIstioResource(value="classpath:virtual-service.yml")
    class TestWithIstioResourceAndRestore {
        TestWithIstioResourceAndRestore() {
        }
    }
}

