/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.istio.impl;

import io.fabric8.istio.client.IstioClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.arquillian.cube.istio.impl.IstioClientAdapter;
import org.arquillian.cube.istio.impl.IstioResource;
import org.arquillian.cube.istio.impl.IstioResourceList;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class IstioClientAdapterTest {
    @Mock
    Resource<IstioResource> loadedResource;
    @Mock
    MixedOperation<IstioResource, IstioResourceList, Resource<IstioResource>> resources;
    @Mock
    private IstioClient istioClient;

    @Before
    public void setup_mock_expectations() {
        Mockito.when((Object)this.istioClient.resources(IstioResource.class, IstioResourceList.class)).thenReturn(this.resources);
        Mockito.when((Object)((Resource)this.resources.load((InputStream)ArgumentMatchers.any(InputStream.class)))).thenReturn(this.loadedResource);
        Mockito.when((Object)((Resource)this.resources.load((String)ArgumentMatchers.any(String.class)))).thenReturn(this.loadedResource);
        Mockito.when((Object)((Resource)this.resources.resource((Object)((IstioResource)ArgumentMatchers.any(IstioResource.class))))).thenReturn(this.loadedResource);
        Mockito.when((Object)((IstioResource)this.loadedResource.create())).thenReturn((Object)new IstioResource());
        Mockito.when((Object)this.loadedResource.delete()).thenReturn(Collections.emptyList());
    }

    @Test
    public void should_deploy_from_input_stream() throws IOException {
        IstioClientAdapter istioClientAdapter = new IstioClientAdapter(this.istioClient);
        URL resource = Thread.currentThread().getContextClassLoader().getResource("route-rule-reviews-test-v2.yaml");
        try (InputStream is = resource.openStream();){
            List istioResources = istioClientAdapter.registerCustomResources(is);
            Assertions.assertThat((List)istioResources).isNotNull();
            Assertions.assertThat((List)istioResources).isNotEmpty();
            Assertions.assertThat((List)istioResources).hasSize(1);
        }
    }

    @Test
    public void should_deploy_from_string() throws IOException {
        IstioClientAdapter istioClientAdapter = new IstioClientAdapter(this.istioClient);
        URL resource = Thread.currentThread().getContextClassLoader().getResource("route-rule-reviews-test-v2.yaml");
        try (InputStream in = resource.openStream();){
            byte[] bytes = in.readAllBytes();
            List istioResources = istioClientAdapter.registerCustomResources(new String(bytes, StandardCharsets.UTF_8));
            Assertions.assertThat((List)istioResources).isNotNull();
            Assertions.assertThat((List)istioResources).isNotEmpty();
            Assertions.assertThat((List)istioResources).hasSize(1);
        }
    }

    @Test
    public void should_undeploy() throws IOException {
        IstioClientAdapter istioClientAdapter = new IstioClientAdapter(this.istioClient);
        URL resource = Thread.currentThread().getContextClassLoader().getResource("route-rule-reviews-test-v2.yaml");
        try (InputStream is = resource.openStream();){
            List istioResources = istioClientAdapter.registerCustomResources(is);
            Boolean result = istioClientAdapter.unregisterCustomResource((IstioResource)istioResources.get(0));
            Assertions.assertThat((Boolean)result).isTrue();
        }
    }

    @Test
    public void should_unwrap() {
        IstioClientAdapter istioClientAdapter = new IstioClientAdapter(this.istioClient);
        IstioClient unwrapped = istioClientAdapter.unwrap();
        Assertions.assertThat((Object)unwrapped).isNotNull();
        Assertions.assertThat((Object)unwrapped).isInstanceOf(IstioClient.class);
    }
}

