/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.istio.impl;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.arquillian.cube.istio.api.IstioResource;
import org.arquillian.cube.istio.api.RestoreIstioResource;
import org.arquillian.cube.istio.impl.IstioClientAdapter;
import org.arquillian.cube.istio.impl.IstioResource;
import org.arquillian.cube.kubernetes.impl.resolver.ResourceResolver;
import org.arquillian.cube.kubernetes.impl.resources.KubernetesResourcesApplier;
import org.arquillian.cube.kubernetes.impl.utils.RunnerExpressionParser;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class IstioResourcesApplier {
    private static final Logger log = Logger.getLogger(KubernetesResourcesApplier.class.getName());
    private Map<String, List<IstioResource>> resourcesMap = new ConcurrentHashMap<String, List<IstioResource>>();
    private Map<String, List<IstioResource>> restoredResourcesMap = new ConcurrentHashMap<String, List<IstioResource>>();

    public void applyIstioResourcesAtClassScope(@Observes(precedence=-20) BeforeClass beforeClass, IstioClientAdapter istioClient) {
        TestClass testClass = beforeClass.getTestClass();
        log.info(String.format("Creating Istio resource for %s", testClass.getName()));
        this.createResources(this.createResourceKey(testClass), istioClient, this.findAnnotations(testClass));
    }

    public void applyIstioResourcesAtMethodScope(@Observes(precedence=-20) Before beforeMethod, IstioClientAdapter istioClient) {
        TestClass testClass = beforeMethod.getTestClass();
        Method testMethod = beforeMethod.getTestMethod();
        log.info(String.format("Creating Istio resource for %s method %s", testClass.getName(), testMethod.getName()));
        this.createResources(this.createResourceKey(testMethod), istioClient, this.findAnnotations(testMethod));
    }

    public void removeIstioResourcesAtClassScope(@Observes(precedence=20) AfterClass afterClass, IstioClientAdapter istioClient) {
        TestClass testClass = afterClass.getTestClass();
        log.info(String.format("Deleting Istio resource for %s", testClass.getName()));
        this.deleteResources(this.createResourceKey(testClass), istioClient, this.findRestoreAnnotations(testClass));
    }

    public void removeIstioResourcesAtMethodScope(@Observes(precedence=20) After afterMethod, IstioClientAdapter istioClient) {
        TestClass testClass = afterMethod.getTestClass();
        Method testMethod = afterMethod.getTestMethod();
        log.info(String.format("Deleting Istio resource for %s method %s", testClass.getName(), testMethod.getName()));
        this.deleteResources(this.createResourceKey(testMethod), istioClient, this.findRestoreAnnotations(testMethod));
    }

    private String createResourceKey(TestClass testClass) {
        return testClass.getJavaClass().getName();
    }

    private String createResourceKey(Method testMethod) {
        return testMethod.getDeclaringClass().getName() + "_" + testMethod.getName();
    }

    private void createResources(String resourceKey, IstioClientAdapter istioClient, org.arquillian.cube.istio.api.IstioResource[] annotations) {
        Arrays.stream(annotations).map(org.arquillian.cube.istio.api.IstioResource::value).map(RunnerExpressionParser::parseExpressions).map(ResourceResolver::resolve).forEach(istioResource -> {
            try (BufferedInputStream istioResourceStream = new BufferedInputStream(istioResource.openStream());){
                this.resourcesMap.put(resourceKey, istioClient.registerCustomResources(istioResourceStream));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteResources(String resourceKey, IstioClientAdapter istioClient, RestoreIstioResource[] annotations) {
        this.createRestoreResources(resourceKey, istioClient, annotations);
        if (!this.resourcesMap.containsKey(resourceKey)) {
            return;
        }
        try {
            List<IstioResource> istioResources = this.resourcesMap.get(resourceKey);
            for (IstioResource resource : istioResources) {
                if (this.restoredResourcesMap.containsKey(resourceKey) && this.restored(resourceKey, resource.getMetadata())) continue;
                istioClient.unregisterCustomResource(resource);
            }
        }
        finally {
            this.resourcesMap.remove(resourceKey);
        }
    }

    private boolean restored(String resourceKey, ObjectMeta istioResourceToDelete) {
        List<IstioResource> listRestoredIstioResources = this.restoredResourcesMap.get(resourceKey);
        for (IstioResource restoredIstioResources : listRestoredIstioResources) {
            ObjectMeta restoredMetadata = restoredIstioResources.getMetadata();
            if (!restoredMetadata.getName().equals(istioResourceToDelete.getName()) || !restoredMetadata.getNamespace().equals(istioResourceToDelete.getNamespace())) continue;
            return true;
        }
        return false;
    }

    private void createRestoreResources(String resourceKey, IstioClientAdapter istioClient, RestoreIstioResource[] annotations) {
        Arrays.stream(annotations).map(RestoreIstioResource::value).map(RunnerExpressionParser::parseExpressions).map(ResourceResolver::resolve).forEach(istioResource -> {
            try (BufferedInputStream istioResourceStream = new BufferedInputStream(istioResource.openStream());){
                this.restoredResourcesMap.put(resourceKey, istioClient.registerCustomResources(istioResourceStream));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private org.arquillian.cube.istio.api.IstioResource[] findAnnotations(TestClass testClass) {
        if (testClass.isAnnotationPresent(org.arquillian.cube.istio.api.IstioResource.class)) {
            return new org.arquillian.cube.istio.api.IstioResource[]{(org.arquillian.cube.istio.api.IstioResource)testClass.getAnnotation(org.arquillian.cube.istio.api.IstioResource.class)};
        }
        if (testClass.isAnnotationPresent(IstioResource.List.class)) {
            return ((IstioResource.List)testClass.getAnnotation(IstioResource.List.class)).value();
        }
        return new org.arquillian.cube.istio.api.IstioResource[0];
    }

    private org.arquillian.cube.istio.api.IstioResource[] findAnnotations(Method testMethod) {
        if (testMethod.isAnnotationPresent(org.arquillian.cube.istio.api.IstioResource.class)) {
            return new org.arquillian.cube.istio.api.IstioResource[]{testMethod.getAnnotation(org.arquillian.cube.istio.api.IstioResource.class)};
        }
        if (testMethod.isAnnotationPresent(IstioResource.List.class)) {
            return testMethod.getAnnotation(IstioResource.List.class).value();
        }
        return new org.arquillian.cube.istio.api.IstioResource[0];
    }

    private RestoreIstioResource[] findRestoreAnnotations(TestClass testClass) {
        if (testClass.isAnnotationPresent(RestoreIstioResource.class)) {
            return new RestoreIstioResource[]{(RestoreIstioResource)testClass.getAnnotation(RestoreIstioResource.class)};
        }
        if (testClass.isAnnotationPresent(RestoreIstioResource.List.class)) {
            return ((RestoreIstioResource.List)testClass.getAnnotation(RestoreIstioResource.List.class)).value();
        }
        return new RestoreIstioResource[0];
    }

    private RestoreIstioResource[] findRestoreAnnotations(Method testMethod) {
        if (testMethod.isAnnotationPresent(RestoreIstioResource.class)) {
            return new RestoreIstioResource[]{testMethod.getAnnotation(RestoreIstioResource.class)};
        }
        if (testMethod.isAnnotationPresent(RestoreIstioResource.List.class)) {
            return testMethod.getAnnotation(RestoreIstioResource.List.class).value();
        }
        return new RestoreIstioResource[0];
    }

    public Map<String, List<IstioResource>> getResourcesMap() {
        return Collections.unmodifiableMap(this.resourcesMap);
    }

    public Map<String, List<IstioResource>> getRestoredResourcesMap() {
        return Collections.unmodifiableMap(this.restoredResourcesMap);
    }
}

