/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.istio.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.arquillian.cube.istio.impl.IstioAssistant;
import org.arquillian.cube.istio.impl.IstioClientAdapter;
import org.arquillian.cube.istio.impl.IstioResource;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class IstioAssistantTest {
    @Mock
    private IstioClientAdapter istioClientAdapter;
    @Mock
    private IstioResource istioResource;

    @Before
    public void setup_mock_expectations() {
        Mockito.when((Object)this.istioClientAdapter.registerCustomResources((InputStream)ArgumentMatchers.any(InputStream.class))).thenReturn(Arrays.asList(this.istioResource));
    }

    @Test
    public void should_load_route_from_url() throws IOException {
        IstioAssistant istioAssistant = new IstioAssistant(this.istioClientAdapter);
        URL resource = Thread.currentThread().getContextClassLoader().getResource("route-rule-reviews-test-v2.yaml");
        List istioResources = istioAssistant.deployIstioResources(new URL[]{resource});
        Assertions.assertThat((List)istioResources).isNotNull();
    }

    @Test
    public void should_load_all_routes_from_classpath() {
        IstioAssistant istioAssistant = new IstioAssistant(this.istioClientAdapter);
        List istioResources = istioAssistant.deployIstioResourcesFromClasspathPattern("route-rule-.*");
        Assertions.assertThat((List)istioResources).hasSize(2);
    }

    @Test
    public void should_load_all_routes_from_path() throws IOException {
        IstioAssistant istioAssistant = new IstioAssistant(this.istioClientAdapter);
        List istioResources = istioAssistant.deployIstioResources(Paths.get(".", "src", "test", "resources"));
        Assertions.assertThat((List)istioResources).hasSize(3);
    }
}

