/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.fabric8.impl.annotation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.arquillian.cube.impl.util.IOUtil;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.kubernetes.api.AnnotationProvider;
import org.arquillian.cube.kubernetes.api.Logger;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;

public class Fabric8AnnotationProvider
implements AnnotationProvider {
    public static final String GIT_COMMIT = "fabric8.io/git-commit";
    public static final String GIT_URL = "fabric8.io/git-url";
    public static final String GIT_BRANCH = "fabric8.io/git-branch";
    public static final String PROJECT_PREFIX = "fabric8.io/project-";
    @Inject
    @ApplicationScoped
    Instance<Logger> logger;

    public Map<String, String> create(String sessionId, String status) {
        HashMap<String, String> annotations = new HashMap<String, String>();
        annotations.put("arquillian.org/test-session-id", sessionId);
        annotations.put("arquillian.org/test-session-status", status);
        File baseDir = Fabric8AnnotationProvider.getProjectBaseDir();
        String gitUrl = this.getGitUrl(baseDir);
        if (Strings.isNotNullOrEmpty((String)gitUrl)) {
            annotations.put(GIT_URL, gitUrl);
        }
        annotations.putAll(this.getPomProperties(baseDir));
        return annotations;
    }

    private Map<String, String> getPomProperties(File baseDir) {
        HashMap<String, String> annotations = new HashMap<String, String>();
        File pomProperties = new File(baseDir, "target/maven-archiver/pom.properties");
        if (pomProperties.isFile()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(pomProperties));
                for (Object o : properties.keySet()) {
                    String key = String.valueOf(o);
                    String value = String.valueOf(properties.get(o));
                    if (!Strings.isNotNullOrEmpty((String)key) || !Strings.isNotNullOrEmpty((String)value)) continue;
                    annotations.put(PROJECT_PREFIX + key, value);
                }
            }
            catch (IOException e) {
                ((Logger)this.logger.get()).warn("Failed to load:[ " + pomProperties + "] file to annotate the namespace. Due to: " + e);
            }
        }
        return annotations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getGitUrl(File basedir) {
        File parentFile;
        File gitConfig;
        if (basedir.exists() && basedir.isDirectory() && (gitConfig = new File(basedir, ".git/config")).isFile() && gitConfig.exists()) {
            try (FileInputStream is = new FileInputStream(gitConfig);){
                String text = IOUtil.asString((InputStream)is);
                if (text != null) {
                    String string = Fabric8AnnotationProvider.getGitUrl(text);
                    return string;
                }
            }
            catch (IOException e) {
                ((Logger)this.logger.get()).warn("Failed to read:[ " + gitConfig + "] file to annotate the namespace. Due to: " + e);
            }
        }
        if ((parentFile = basedir.getParentFile()) == null) return null;
        return this.getGitUrl(parentFile);
    }

    private static File getProjectBaseDir() {
        String basedir = SystemEnvironmentVariables.getPropertyVariable((String)"basedir", (String)".");
        return new File(basedir);
    }

    private static String getGitUrl(String configText) {
        String remote = null;
        String lastUrl = null;
        String firstUrl = null;
        BufferedReader reader = new BufferedReader(new StringReader(configText));
        HashMap<String, String> remoteUrls = new HashMap<String, String>();
        while (true) {
            String[] parts;
            String trimmed;
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (line == null) break;
            if (line.startsWith("[remote ")) {
                String[] parts2 = line.split("\"");
                if (parts2.length <= 1) continue;
                remote = parts2[1];
                continue;
            }
            if (line.startsWith("[")) {
                remote = null;
                continue;
            }
            if (remote == null || line.length() <= 0 || !Character.isWhitespace(line.charAt(0)) || !(trimmed = line.trim()).startsWith("url ") || (parts = trimmed.split("=", 2)).length <= 1) continue;
            lastUrl = parts[1].trim();
            if (firstUrl == null) {
                firstUrl = lastUrl;
            }
            remoteUrls.put(remote, lastUrl);
        }
        String answer = null;
        if (remoteUrls.size() == 1) {
            return lastUrl;
        }
        if (remoteUrls.size() > 1 && (answer = (String)remoteUrls.get("origin")) == null) {
            answer = firstUrl;
        }
        return answer;
    }
}

