/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.fabric8.impl.visitor;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.fabric8.impl.SecretKeys;
import org.arquillian.cube.kubernetes.impl.utils.Secrets;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

public class SecretsAndServiceAccountVisitor
implements Visitor {
    @Inject
    Instance<KubernetesClient> client;
    @Inject
    Instance<Configuration> configuration;

    public void visit(Object element) {
        String serviceAccount = null;
        LinkedHashSet<Secret> secrets = new LinkedHashSet<Secret>();
        if (element instanceof PodBuilder) {
            PodBuilder builder = (PodBuilder)element;
            serviceAccount = builder.getSpec().getServiceAccountName();
            secrets.addAll(this.generateSecrets(builder.getMetadata()));
        } else if (element instanceof PodTemplateSpecBuilder) {
            PodTemplateSpecBuilder builder = (PodTemplateSpecBuilder)element;
            serviceAccount = builder.getSpec().getServiceAccountName();
            secrets.addAll(this.generateSecrets(builder.getMetadata()));
        }
    }

    private void createServiceAccount(String serviceAccount, Set<Secret> secrets) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        Configuration configuration = (Configuration)this.configuration.get();
        ArrayList<ObjectReference> refs = new ArrayList<ObjectReference>();
        for (Secret secret : secrets) {
            refs.add(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withNamespace(configuration.getNamespace())).withName(secret.getMetadata().getName())).build());
        }
        if (((ClientResource)((ClientNonNamespaceOperation)client.serviceAccounts().inNamespace(configuration.getNamespace())).withName(serviceAccount)).get() == null) {
            ((DoneableServiceAccount)((DoneableServiceAccount)((ServiceAccountFluent.MetadataNested)((DoneableServiceAccount)((ClientNonNamespaceOperation)client.serviceAccounts().inNamespace(configuration.getNamespace())).createNew()).withNewMetadata().withName(serviceAccount)).endMetadata()).withSecrets(refs)).done();
        } else {
            ((DoneableServiceAccount)((DoneableServiceAccount)((ClientResource)((ClientNonNamespaceOperation)client.serviceAccounts().inNamespace(configuration.getNamespace())).withName(serviceAccount)).edit()).withSecrets(refs)).done();
        }
    }

    private Set<Secret> generateSecrets(ObjectMeta meta) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        Configuration configuration = (Configuration)this.configuration.get();
        HashSet<Secret> secrets = new HashSet<Secret>();
        Map annotations = meta.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            for (Map.Entry entry : annotations.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!SecretKeys.isSecretKey(key)) continue;
                SecretKeys keyType = SecretKeys.fromValue(key);
                for (String name : Secrets.getNames((String)value)) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    Secret secret = null;
                    try {
                        secret = (Secret)((ClientResource)((ClientNonNamespaceOperation)client.secrets().inNamespace(configuration.getNamespace())).withName(name)).get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (secret != null) continue;
                    for (String c : Secrets.getContents((String)value, (String)name)) {
                        data.put(c, keyType.generate());
                    }
                    secret = ((DoneableSecret)((DoneableSecret)((SecretFluent.MetadataNested)((DoneableSecret)((ClientNonNamespaceOperation)client.secrets().inNamespace(configuration.getNamespace())).createNew()).withNewMetadata().withName(name)).endMetadata()).withData(data)).done();
                    secrets.add(secret);
                }
            }
        }
        return secrets;
    }
}

