/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.fabric8.impl;

import java.security.KeyPairGenerator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public enum SecretKeys {
    GPG_KEY("fabric8.io/secret-gpg-key"){

        @Override
        public String generate() {
            return "";
        }
    }
    ,
    SSH_KEY("fabric8.io/secret-ssh-key"){

        @Override
        public String generate() {
            try {
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
                keyGen.initialize(512);
                byte[] publicKey = keyGen.genKeyPair().getPublic().getEncoded();
                return new String(Base64.encodeBase64((byte[])publicKey));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
    ,
    SSH_PUBLIC_KEY("fabric8.io/secret-ssh-public-key"){

        @Override
        public String generate() {
            try {
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
                keyGen.initialize(512);
                byte[] publicKey = keyGen.genKeyPair().getPublic().getEncoded();
                return new String(Base64.encodeBase64((byte[])publicKey));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    };

    private static final Map<String, SecretKeys> map;
    private final String value;

    private SecretKeys(String value) {
        this.value = value;
    }

    public static boolean isSecretKey(String key) {
        return map.containsKey(key);
    }

    public static SecretKeys fromValue(String v) {
        return map.get(v);
    }

    public abstract String generate();

    static {
        map = new HashMap<String, SecretKeys>();
        for (SecretKeys s : SecretKeys.values()) {
            map.put(s.value, s);
        }
    }
}

