/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.fabric8.impl.visitor;

import io.fabric8.kubernetes.api.builder.v4_0.Visitor;
import io.fabric8.kubernetes.api.model.v4_0.DoneableSecret;
import io.fabric8.kubernetes.api.model.v4_0.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.v4_0.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_0.ObjectReference;
import io.fabric8.kubernetes.api.model.v4_0.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_0.PodBuilder;
import io.fabric8.kubernetes.api.model.v4_0.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v4_0.Secret;
import io.fabric8.kubernetes.api.model.v4_0.SecretFluent;
import io.fabric8.kubernetes.api.model.v4_0.ServiceAccountFluent;
import io.fabric8.kubernetes.clnt.v4_0.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_0.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_0.dsl.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.fabric8.impl.SecretKeys;
import org.arquillian.cube.kubernetes.fabric8.impl.utils.Secrets;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

public class SecretsAndServiceAccountVisitor
implements Visitor {
    @Inject
    Instance<KubernetesClient> client;
    @Inject
    Instance<Configuration> configuration;

    public void visit(Object element) {
        String serviceAccount = null;
        LinkedHashSet<Secret> secrets = new LinkedHashSet<Secret>();
        if (element instanceof PodBuilder) {
            PodBuilder builder = (PodBuilder)element;
            serviceAccount = builder.getSpec().getServiceAccountName();
            secrets.addAll(this.generateSecrets(builder.getMetadata()));
        } else if (element instanceof PodTemplateSpecBuilder) {
            PodTemplateSpecBuilder builder = (PodTemplateSpecBuilder)element;
            serviceAccount = builder.getSpec().getServiceAccountName();
            secrets.addAll(this.generateSecrets(builder.getMetadata()));
        }
    }

    private void createServiceAccount(String serviceAccount, Set<Secret> secrets) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        Configuration configuration = (Configuration)this.configuration.get();
        ArrayList<ObjectReference> refs = new ArrayList<ObjectReference>();
        for (Secret secret : secrets) {
            refs.add(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withNamespace(configuration.getNamespace())).withName(secret.getMetadata().getName())).build());
        }
        if (((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(configuration.getNamespace())).withName(serviceAccount)).get() == null) {
            ((DoneableServiceAccount)((DoneableServiceAccount)((ServiceAccountFluent.MetadataNested)((DoneableServiceAccount)((NonNamespaceOperation)client.serviceAccounts().inNamespace(configuration.getNamespace())).createNew()).withNewMetadata().withName(serviceAccount)).endMetadata()).withSecrets(refs)).done();
        } else {
            ((DoneableServiceAccount)((DoneableServiceAccount)((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(configuration.getNamespace())).withName(serviceAccount)).edit()).withSecrets(refs)).done();
        }
    }

    private Set<Secret> generateSecrets(ObjectMeta meta) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        Configuration configuration = (Configuration)this.configuration.get();
        HashSet<Secret> secrets = new HashSet<Secret>();
        Map annotations = meta.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            for (Map.Entry entry : annotations.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!SecretKeys.isSecretKey(key)) continue;
                SecretKeys keyType = SecretKeys.fromValue(key);
                for (String name : Secrets.getNames(value)) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    Secret secret = null;
                    try {
                        secret = (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(configuration.getNamespace())).withName(name)).get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (secret != null) continue;
                    for (String c : Secrets.getContents(value, name)) {
                        data.put(c, keyType.generate());
                    }
                    secret = ((DoneableSecret)((DoneableSecret)((SecretFluent.MetadataNested)((DoneableSecret)((NonNamespaceOperation)client.secrets().inNamespace(configuration.getNamespace())).createNew()).withNewMetadata().withName(name)).endMetadata()).withData(data)).done();
                    secrets.add(secret);
                }
            }
        }
        return secrets;
    }
}

