/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.fabric8.impl.annotation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.arquillian.cube.impl.util.IOUtil;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.kubernetes.api.AnnotationProvider;
import org.arquillian.cube.kubernetes.api.Logger;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Validate;

public class Fabric8AnnotationProvider
implements AnnotationProvider {
    public static final String GIT_COMMIT = "fabric8.io/git-commit";
    public static final String GIT_URL = "fabric8.io/git-url";
    public static final String GIT_BRANCH = "fabric8.io/git-branch";
    public static final String PROJECT_PREFIX = "fabric8.io/project-";
    @Inject
    @ApplicationScoped
    Instance<Logger> logger;
    private AnnotationProvider delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationProvider toImmutable() {
        if (this.delegate != null) {
            return this.delegate;
        }
        Fabric8AnnotationProvider fabric8AnnotationProvider = this;
        synchronized (fabric8AnnotationProvider) {
            if (this.delegate == null) {
                this.delegate = new ImmutableFabric8AnnotationProvider((Logger)this.logger.get());
            }
        }
        return this.delegate;
    }

    public Map<String, String> create(String sessionId, String status) {
        return this.toImmutable().create(sessionId, status);
    }

    public static class ImmutableFabric8AnnotationProvider
    implements AnnotationProvider {
        private final Logger logger;

        private ImmutableFabric8AnnotationProvider(Logger logger) {
            Validate.notNull((Object)logger, (String)"A Logger instance is required.");
            this.logger = logger;
        }

        public Map<String, String> create(String sessionId, String status) {
            HashMap<String, String> annotations = new HashMap<String, String>();
            annotations.put("arquillian.org/test-session-id", sessionId);
            annotations.put("arquillian.org/test-session-status", status);
            File baseDir = ImmutableFabric8AnnotationProvider.getProjectBaseDir();
            String gitUrl = this.getGitUrl(baseDir);
            if (Strings.isNotNullOrEmpty((String)gitUrl)) {
                annotations.put(Fabric8AnnotationProvider.GIT_URL, gitUrl);
            }
            annotations.putAll(this.getPomProperties(baseDir));
            return annotations;
        }

        private Map<String, String> getPomProperties(File baseDir) {
            HashMap<String, String> annotations = new HashMap<String, String>();
            File pomProperties = new File(baseDir, "target/maven-archiver/pom.properties");
            if (pomProperties.isFile()) {
                try {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(pomProperties));
                    for (Object o : properties.keySet()) {
                        String key = String.valueOf(o);
                        String value = String.valueOf(properties.get(o));
                        if (!Strings.isNotNullOrEmpty((String)key) || !Strings.isNotNullOrEmpty((String)value)) continue;
                        annotations.put(Fabric8AnnotationProvider.PROJECT_PREFIX + key, value);
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Failed to load:[ " + String.valueOf(pomProperties) + "] file to annotate the namespace. Due to: " + String.valueOf(e));
                }
            }
            return annotations;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getGitUrl(File basedir) {
            File parentFile;
            File gitConfig;
            if (basedir.exists() && basedir.isDirectory() && (gitConfig = new File(basedir, ".git/config")).isFile() && gitConfig.exists()) {
                try (FileInputStream is = new FileInputStream(gitConfig);){
                    String text = IOUtil.asString((InputStream)is);
                    if (text != null) {
                        String string = ImmutableFabric8AnnotationProvider.getGitUrl(text);
                        return string;
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Failed to read:[ " + String.valueOf(gitConfig) + "] file to annotate the namespace. Due to: " + String.valueOf(e));
                }
            }
            if ((parentFile = basedir.getParentFile()) == null) return null;
            return this.getGitUrl(parentFile);
        }

        private static File getProjectBaseDir() {
            String basedir = SystemEnvironmentVariables.getPropertyVariable((String)"basedir", (String)".");
            return new File(basedir);
        }

        private static String getGitUrl(String configText) {
            String remote = null;
            String lastUrl = null;
            String firstUrl = null;
            BufferedReader reader = new BufferedReader(new StringReader(configText));
            HashMap<String, String> remoteUrls = new HashMap<String, String>();
            while (true) {
                String[] parts;
                String trimmed;
                String line = null;
                try {
                    line = reader.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (line == null) break;
                if (line.startsWith("[remote ")) {
                    String[] parts2 = line.split("\"");
                    if (parts2.length <= 1) continue;
                    remote = parts2[1];
                    continue;
                }
                if (line.startsWith("[")) {
                    remote = null;
                    continue;
                }
                if (remote == null || line.length() <= 0 || !Character.isWhitespace(line.charAt(0)) || !(trimmed = line.trim()).startsWith("url ") || (parts = trimmed.split("=", 2)).length <= 1) continue;
                lastUrl = parts[1].trim();
                if (firstUrl == null) {
                    firstUrl = lastUrl;
                }
                remoteUrls.put(remote, lastUrl);
            }
            String answer = null;
            if (remoteUrls.size() == 1) {
                return lastUrl;
            }
            if (remoteUrls.size() > 1 && (answer = (String)remoteUrls.get("origin")) == null) {
                answer = firstUrl;
            }
            return answer;
        }

        public AnnotationProvider toImmutable() {
            return this;
        }
    }
}

