/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.fabric8.impl.label;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.cube.kubernetes.api.LabelProvider;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Validate;

public class Fabric8LabelProvider
implements LabelProvider {
    @Inject
    Instance<KubernetesClient> client;
    LabelProvider delegate;

    public Map<String, String> getLabels() {
        return this.toImmutable().getLabels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LabelProvider toImmutable() {
        if (this.delegate != null) {
            return this.delegate;
        }
        Fabric8LabelProvider fabric8LabelProvider = this;
        synchronized (fabric8LabelProvider) {
            if (this.delegate == null) {
                this.delegate = new ImmutableFabric8LabelProvider((KubernetesClient)this.client.get());
            }
        }
        return this.delegate;
    }

    public static class ImmutableFabric8LabelProvider
    implements LabelProvider {
        private final KubernetesClient client;

        private ImmutableFabric8LabelProvider(KubernetesClient client) {
            Validate.notNull((Object)client, (String)"A KubernetesClient instance is required.");
            this.client = client;
        }

        public Map<String, String> getLabels() {
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("project", this.client.getNamespace());
            labels.put("framework", "arquillian");
            labels.put("provider", "fabric8");
            labels.put("component", "integrationTest");
            return labels;
        }

        public LabelProvider toImmutable() {
            return this;
        }
    }
}

