/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.fabric8.impl.visitor;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.fabric8.impl.SecretKeys;
import org.arquillian.cube.kubernetes.fabric8.impl.utils.Secrets;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

public class SecretsAndServiceAccountVisitor
implements Visitor {
    @Inject
    Instance<KubernetesClient> client;
    @Inject
    Instance<Configuration> configuration;

    public void visit(Object element) {
        String serviceAccount = null;
        LinkedHashSet<Secret> secrets = new LinkedHashSet<Secret>();
        if (element instanceof PodBuilder) {
            PodBuilder builder = (PodBuilder)element;
            serviceAccount = builder.buildSpec().getServiceAccountName();
            secrets.addAll(this.generateSecrets(builder.buildMetadata()));
        } else if (element instanceof PodTemplateSpecBuilder) {
            PodTemplateSpecBuilder builder = (PodTemplateSpecBuilder)element;
            serviceAccount = builder.buildSpec().getServiceAccountName();
            secrets.addAll(this.generateSecrets(builder.buildMetadata()));
        }
    }

    private void createServiceAccount(String serviceAccount, Set<Secret> secrets) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        Configuration configuration = (Configuration)this.configuration.get();
        ArrayList<ObjectReference> refs = new ArrayList<ObjectReference>();
        for (Secret secret : secrets) {
            refs.add(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withNamespace(configuration.getNamespace())).withName(secret.getMetadata().getName())).build());
        }
        if (((ServiceAccountResource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(configuration.getNamespace())).withName(serviceAccount)).get() == null) {
            ((NonNamespaceOperation)client.serviceAccounts().inNamespace(configuration.getNamespace())).create((Object)((ServiceAccountBuilder)((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName(serviceAccount)).endMetadata()).withSecrets(refs)).build());
        } else {
            ((ServiceAccountResource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(configuration.getNamespace())).withName(serviceAccount)).edit(s -> ((ServiceAccountBuilder)new ServiceAccountBuilder(s).withSecrets(refs)).build());
        }
    }

    private Set<Secret> generateSecrets(ObjectMeta meta) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        Configuration configuration = (Configuration)this.configuration.get();
        HashSet<Secret> secrets = new HashSet<Secret>();
        Map annotations = meta.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            for (Map.Entry entry : annotations.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!SecretKeys.isSecretKey(key)) continue;
                SecretKeys keyType = SecretKeys.fromValue(key);
                for (String name : Secrets.getNames(value)) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    Secret secret = null;
                    try {
                        secret = (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(configuration.getNamespace())).withName(name)).get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (secret != null) continue;
                    for (String c : Secrets.getContents(value, name)) {
                        data.put(c, keyType.generate());
                    }
                    secret = (Secret)((NonNamespaceOperation)client.secrets().inNamespace(configuration.getNamespace())).create((Object)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(name)).endMetadata()).withData(data)).build());
                    secrets.add(secret);
                }
            }
        }
        return secrets;
    }
}

