package org.arquillian.cube.kubernetes.impl;

import java.util.ArrayList;
import java.util.RandomAccess;
import org.arquillian.cube.kubernetes.api.Configuration;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.net.URL;
import java.util.AbstractList;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class DefaultConfigurationFluentImpl<A extends DefaultConfigurationFluent<A>> extends BaseFluent<A> implements DefaultConfigurationFluent<A>{

     String sessionId;     String namespace;     URL masterUrl;     URL environmentConfigUrl;     List<URL> environmentDependencies = new ArrayList();     boolean namespaceLazyCreateEnabled;     boolean namespaceCleanupEnabled;     long namespaceCleanupTimeout;     boolean namespaceCleanupConfirmationEnabled;     long waitTimeout;     long waitPollInterval;     boolean waitForServiceConnectionEnabled;     List<String> waitForServiceList = new ArrayList();     long waitForServiceConnectionTimeout;     boolean ansiLoggerEnabled;     boolean environmentInitEnabled;     String kubernetesDomain;     String dockerRegistry;
public DefaultConfigurationFluentImpl(){
    
}
public DefaultConfigurationFluentImpl( DefaultConfiguration instance ){
    this.withSessionId(instance.getSessionId()); this.withMasterUrl(instance.getMasterUrl()); this.withNamespace(instance.getNamespace()); this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl()); this.withEnvironmentDependencies(instance.getEnvironmentDependencies()); this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled()); this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled()); this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout()); this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled()); this.withWaitTimeout(instance.getWaitTimeout()); this.withWaitPollInterval(instance.getWaitPollInterval()); this.withWaitForServiceConnectionEnabled(instance.isWaitForServiceConnectionEnabled()); this.withWaitForServiceList(instance.getWaitForServiceList()); this.withWaitForServiceConnectionTimeout(instance.getWaitForServiceConnectionTimeout()); this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled()); this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled()); this.withKubernetesDomain(instance.getKubernetesDomain()); this.withDockerRegistry(instance.getDockerRegistry()); 
}

    public String getSessionId(){
    return this.sessionId;
    }
    public A withSessionId( String sessionId){
    this.sessionId=sessionId; return (A) this;
    }
    public String getNamespace(){
    return this.namespace;
    }
    public A withNamespace( String namespace){
    this.namespace=namespace; return (A) this;
    }
    public URL getMasterUrl(){
    return this.masterUrl;
    }
    public A withMasterUrl( URL masterUrl){
    this.masterUrl=masterUrl; return (A) this;
    }
    public URL getEnvironmentConfigUrl(){
    return this.environmentConfigUrl;
    }
    public A withEnvironmentConfigUrl( URL environmentConfigUrl){
    this.environmentConfigUrl=environmentConfigUrl; return (A) this;
    }
    public A addToEnvironmentDependencies( URL ...items){
    for (URL item : items) {this.environmentDependencies.add(item);} return (A)this;
    }
    public A removeFromEnvironmentDependencies( URL ...items){
    for (URL item : items) {this.environmentDependencies.remove(item);} return (A)this;
    }
    public List<URL> getEnvironmentDependencies(){
    return this.environmentDependencies;
    }
    public A withEnvironmentDependencies( List<URL> environmentDependencies){
    this.environmentDependencies.clear();if (environmentDependencies != null) {for (URL item : environmentDependencies){this.addToEnvironmentDependencies(item);}} return (A) this;
    }
    public A withEnvironmentDependencies( URL ...environmentDependencies){
    this.environmentDependencies.clear(); if (environmentDependencies != null) {for (URL item :environmentDependencies){ this.addToEnvironmentDependencies(item);}} return (A) this;
    }
    public boolean isNamespaceLazyCreateEnabled(){
    return this.namespaceLazyCreateEnabled;
    }
    public A withNamespaceLazyCreateEnabled( boolean namespaceLazyCreateEnabled){
    this.namespaceLazyCreateEnabled=namespaceLazyCreateEnabled; return (A) this;
    }
    public boolean isNamespaceCleanupEnabled(){
    return this.namespaceCleanupEnabled;
    }
    public A withNamespaceCleanupEnabled( boolean namespaceCleanupEnabled){
    this.namespaceCleanupEnabled=namespaceCleanupEnabled; return (A) this;
    }
    public long getNamespaceCleanupTimeout(){
    return this.namespaceCleanupTimeout;
    }
    public A withNamespaceCleanupTimeout( long namespaceCleanupTimeout){
    this.namespaceCleanupTimeout=namespaceCleanupTimeout; return (A) this;
    }
    public boolean isNamespaceCleanupConfirmationEnabled(){
    return this.namespaceCleanupConfirmationEnabled;
    }
    public A withNamespaceCleanupConfirmationEnabled( boolean namespaceCleanupConfirmationEnabled){
    this.namespaceCleanupConfirmationEnabled=namespaceCleanupConfirmationEnabled; return (A) this;
    }
    public long getWaitTimeout(){
    return this.waitTimeout;
    }
    public A withWaitTimeout( long waitTimeout){
    this.waitTimeout=waitTimeout; return (A) this;
    }
    public long getWaitPollInterval(){
    return this.waitPollInterval;
    }
    public A withWaitPollInterval( long waitPollInterval){
    this.waitPollInterval=waitPollInterval; return (A) this;
    }
    public boolean isWaitForServiceConnectionEnabled(){
    return this.waitForServiceConnectionEnabled;
    }
    public A withWaitForServiceConnectionEnabled( boolean waitForServiceConnectionEnabled){
    this.waitForServiceConnectionEnabled=waitForServiceConnectionEnabled; return (A) this;
    }
    public A addToWaitForServiceList( String ...items){
    for (String item : items) {this.waitForServiceList.add(item);} return (A)this;
    }
    public A removeFromWaitForServiceList( String ...items){
    for (String item : items) {this.waitForServiceList.remove(item);} return (A)this;
    }
    public List<String> getWaitForServiceList(){
    return this.waitForServiceList;
    }
    public A withWaitForServiceList( List<String> waitForServiceList){
    this.waitForServiceList.clear();if (waitForServiceList != null) {for (String item : waitForServiceList){this.addToWaitForServiceList(item);}} return (A) this;
    }
    public A withWaitForServiceList( String ...waitForServiceList){
    this.waitForServiceList.clear(); if (waitForServiceList != null) {for (String item :waitForServiceList){ this.addToWaitForServiceList(item);}} return (A) this;
    }
    public long getWaitForServiceConnectionTimeout(){
    return this.waitForServiceConnectionTimeout;
    }
    public A withWaitForServiceConnectionTimeout( long waitForServiceConnectionTimeout){
    this.waitForServiceConnectionTimeout=waitForServiceConnectionTimeout; return (A) this;
    }
    public boolean isAnsiLoggerEnabled(){
    return this.ansiLoggerEnabled;
    }
    public A withAnsiLoggerEnabled( boolean ansiLoggerEnabled){
    this.ansiLoggerEnabled=ansiLoggerEnabled; return (A) this;
    }
    public boolean isEnvironmentInitEnabled(){
    return this.environmentInitEnabled;
    }
    public A withEnvironmentInitEnabled( boolean environmentInitEnabled){
    this.environmentInitEnabled=environmentInitEnabled; return (A) this;
    }
    public String getKubernetesDomain(){
    return this.kubernetesDomain;
    }
    public A withKubernetesDomain( String kubernetesDomain){
    this.kubernetesDomain=kubernetesDomain; return (A) this;
    }
    public String getDockerRegistry(){
    return this.dockerRegistry;
    }
    public A withDockerRegistry( String dockerRegistry){
    this.dockerRegistry=dockerRegistry; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DefaultConfigurationFluentImpl that = (DefaultConfigurationFluentImpl) o;
if (sessionId != null ? !sessionId.equals(that.sessionId) :that.sessionId != null) return false;
if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
if (masterUrl != null ? !masterUrl.equals(that.masterUrl) :that.masterUrl != null) return false;
if (environmentConfigUrl != null ? !environmentConfigUrl.equals(that.environmentConfigUrl) :that.environmentConfigUrl != null) return false;
if (environmentDependencies != null ? !environmentDependencies.equals(that.environmentDependencies) :that.environmentDependencies != null) return false;
if (namespaceLazyCreateEnabled != that.namespaceLazyCreateEnabled) return false;
if (namespaceCleanupEnabled != that.namespaceCleanupEnabled) return false;
if (namespaceCleanupTimeout != that.namespaceCleanupTimeout) return false;
if (namespaceCleanupConfirmationEnabled != that.namespaceCleanupConfirmationEnabled) return false;
if (waitTimeout != that.waitTimeout) return false;
if (waitPollInterval != that.waitPollInterval) return false;
if (waitForServiceConnectionEnabled != that.waitForServiceConnectionEnabled) return false;
if (waitForServiceList != null ? !waitForServiceList.equals(that.waitForServiceList) :that.waitForServiceList != null) return false;
if (waitForServiceConnectionTimeout != that.waitForServiceConnectionTimeout) return false;
if (ansiLoggerEnabled != that.ansiLoggerEnabled) return false;
if (environmentInitEnabled != that.environmentInitEnabled) return false;
if (kubernetesDomain != null ? !kubernetesDomain.equals(that.kubernetesDomain) :that.kubernetesDomain != null) return false;
if (dockerRegistry != null ? !dockerRegistry.equals(that.dockerRegistry) :that.dockerRegistry != null) return false;
return true;

    }



}
