/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.api;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import java.net.URL;
import java.util.List;

public interface Configuration {
    public static final String KUBERNETES_MASTER = "kubernetes.master";
    public static final String KUBERNETES_NAMESPACE = "kubernetes.namespace";
    public static final String KUBERNETES_DOMAIN = "kubernetes.domain";
    public static final String MASTER_URL = "master.url";
    public static final String NAMESPACE = "namespace";
    public static final String DOMAIN = "domain";
    public static final String DOCKER_REGISTY = "docker.registry";
    public static final String DOCKER_REGISTRY_HOST = "DOCKER_REGISTRY_HOST";
    public static final String DOCKER_REGISTRY_PORT = "DOCKER_REGISTRY_PORT";
    public static final String DOCKER_REGISTRY_FORMAT = "%s:%s";
    public static final String NAMESPACE_LAZY_CREATE_ENABLED = "namespace.lazy.enabled";
    public static final String NAMESPACE_CLEANUP_TIMEOUT = "namespace.cleanup.timeout";
    public static final String NAMESPACE_CLEANUP_CONFIRM_ENABLED = "namespace.cleanup.confirm.enabled";
    public static final String NAMESPACE_CLEANUP_ENABLED = "namespace.cleanup.enabled";
    public static final String NAMESPACE_TO_USE = "namespace.use.existing";
    public static final String NAMESPACE_PREFIX = "namespace.prefix";
    public static final String ENVIRONMENT_INIT_ENABLED = "env.init.enabled";
    public static final String ENVIRONMENT_CONFIG_URL = "env.config.url";
    public static final String ENVIRONMENT_CONFIG_RESOURCE_NAME = "env.config.resource.name";
    public static final String ENVIRONMENT_DEPENDENCIES = "env.dependencies";
    public static final String WAIT_TIMEOUT = "wait.timeout";
    public static final String WAIT_POLL_INTERVAL = "wait.poll.interval";
    public static final String WAIT_FOR_SERVICE_LIST = "wait.for.service.list";
    public static final String WAIT_FOR_SERVICE_CONNECTION_ENABLED = "wait.for.service.connection.enabled";
    public static final String WAIT_FOR_SERVICE_CONNECTION_TIMEOUT = "wait.for.service.connection.timeout";
    public static final String ANSI_LOGGER_ENABLED = "ansi.logger.enabled";
    public static final Boolean DEFAULT_WAIT_FOR_SERVICE_CONNECTION_ENABLED = false;
    public static final Long DEFAULT_WAIT_FOR_SERVICE_CONNECTION_TIMEOUT = 10000L;
    public static final Long DEFAULT_WAIT_TIMEOUT = 300000L;
    public static final Long DEFAULT_WAIT_POLL_INTERVAL = 5000L;
    public static final String DEFAULT_CONFIG_FILE_NAME = "kubernetes.json";
    public static final Long DEFAULT_NAMESPACE_CLEANUP_TIMEOUT = 0L;
    public static final Boolean DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED = true;
    public static final Config FALLBACK_CLIENT_CONFIG = new ConfigBuilder().build();

    public URL getMasterUrl();

    public URL getEnvironmentConfigUrl();

    public List<URL> getEnvironmentDependencies();

    public String getSessionId();

    public String getNamespace();

    public boolean isNamespaceLazyCreateEnabled();

    public boolean isNamespaceCleanupEnabled();

    public long getNamespaceCleanupTimeout();

    public boolean isNamespaceCleanupConfirmationEnabled();

    public long getWaitTimeout();

    public long getWaitPollInterval();

    public boolean isWaitForServiceConnectionEnabled();

    public List<String> getWaitForServiceList();

    public long getWaitForServiceConnectionTimeout();

    public boolean isAnsiLoggerEnabled();

    public boolean isEnvironmentInitEnabled();

    public String getKubernetesDomain();

    public String getDockerRegistry();
}

