/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.client.utils.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.arquillian.cube.impl.util.ConfigUtil;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationBuilder;

public class DefaultConfiguration
implements Configuration {
    private final String sessionId;
    private final String namespace;
    private final URL masterUrl;
    private final URL environmentConfigUrl;
    private final List<URL> environmentDependencies;
    private final boolean namespaceLazyCreateEnabled;
    private final boolean namespaceCleanupEnabled;
    private final long namespaceCleanupTimeout;
    private final boolean namespaceCleanupConfirmationEnabled;
    private final long waitTimeout;
    private final long waitPollInterval;
    private final boolean waitForServiceConnectionEnabled;
    private final List<String> waitForServiceList;
    private final long waitForServiceConnectionTimeout;
    private final boolean ansiLoggerEnabled;
    private final boolean environmentInitEnabled;
    private final String kubernetesDomain;
    private final String dockerRegistry;

    public static DefaultConfiguration fromMap(Map<String, String> map) {
        try {
            String sessionId = UUID.randomUUID().toString();
            String namespace = ConfigUtil.getStringProperty((String)"namespace.use.existing", map, null);
            if (Strings.isNullOrEmpty((String)namespace)) {
                namespace = ConfigUtil.getStringProperty((String)"namespace.prefix", map, (String)"itest") + "-" + sessionId;
            }
            return ((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)((DefaultConfigurationBuilder)new DefaultConfigurationBuilder().withSessionId(sessionId)).withNamespace(namespace)).withMasterUrl(new URL(ConfigUtil.getStringProperty((String)"master.url", (String)"kubernetes.master", map, (String)FALLBACK_CLIENT_CONFIG.getMasterUrl())))).withEnvironmentInitEnabled(ConfigUtil.getBooleanProperty((String)"env.init.enabled", map, (Boolean)true))).withEnvironmentConfigUrl(DefaultConfiguration.getKubernetesConfigurationUrl(map))).withEnvironmentDependencies(ConfigUtil.asURL((List)Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"env.dependencies", map, (String)""), (String)" ")))).withNamespaceLazyCreateEnabled(ConfigUtil.getBooleanProperty((String)"namespace.lazy.enabled", map, (Boolean)DEFAULT_NAMESPACE_LAZY_CREATE_ENABLED))).withNamespaceCleanupEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.enabled", map, (Boolean)namespace.contains(sessionId)))).withNamespaceCleanupConfirmationEnabled(ConfigUtil.getBooleanProperty((String)"namespace.cleanup.confirm.enabled", map, (Boolean)false))).withNamespaceCleanupTimeout(ConfigUtil.getLongProperty((String)"namespace.cleanup.timeout", map, (Long)DEFAULT_NAMESPACE_CLEANUP_TIMEOUT))).withWaitTimeout(ConfigUtil.getLongProperty((String)"wait.timeout", map, (Long)DEFAULT_WAIT_TIMEOUT))).withWaitPollInterval(ConfigUtil.getLongProperty((String)"wait.poll.interval", map, (Long)DEFAULT_WAIT_POLL_INTERVAL))).withWaitForServiceList(Strings.splitAndTrimAsList((String)ConfigUtil.getStringProperty((String)"wait.for.service.list", map, (String)""), (String)" "))).withWaitForServiceConnectionEnabled(ConfigUtil.getBooleanProperty((String)"wait.for.service.connection.enabled", map, (Boolean)DEFAULT_WAIT_FOR_SERVICE_CONNECTION_ENABLED))).withWaitForServiceConnectionTimeout(ConfigUtil.getLongProperty((String)"wait.for.service.connection.timeout", map, (Long)DEFAULT_WAIT_FOR_SERVICE_CONNECTION_TIMEOUT))).withAnsiLoggerEnabled(ConfigUtil.getBooleanProperty((String)"ansi.logger.enabled", map, (Boolean)true))).withKubernetesDomain(ConfigUtil.getStringProperty((String)"domain", (String)"kubernetes.domain", map, null))).withDockerRegistry(DefaultConfiguration.getDockerRegistry(map))).build();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public DefaultConfiguration(String sessionId, URL masterUrl, String namespace, URL environmentConfigUrl, List<URL> environmentDependencies, boolean namespaceLazyCreateEnabled, boolean namespaceCleanupEnabled, long namespaceCleanupTimeout, boolean namespaceCleanupConfirmationEnabled, long waitTimeout, long waitPollInterval, boolean waitForServiceConnectionEnabled, List<String> waitForServiceList, long waitForServiceConnectionTimeout, boolean ansiLoggerEnabled, boolean environmentInitEnabled, String kubernetesDomain, String dockerRegistry) {
        this.masterUrl = masterUrl;
        this.environmentDependencies = environmentDependencies;
        this.environmentConfigUrl = environmentConfigUrl;
        this.sessionId = sessionId;
        this.namespace = namespace;
        this.namespaceLazyCreateEnabled = namespaceLazyCreateEnabled;
        this.namespaceCleanupEnabled = namespaceCleanupEnabled;
        this.namespaceCleanupTimeout = namespaceCleanupTimeout;
        this.namespaceCleanupConfirmationEnabled = namespaceCleanupConfirmationEnabled;
        this.waitTimeout = waitTimeout;
        this.waitPollInterval = waitPollInterval;
        this.waitForServiceConnectionEnabled = waitForServiceConnectionEnabled;
        this.waitForServiceList = waitForServiceList;
        this.waitForServiceConnectionTimeout = waitForServiceConnectionTimeout;
        this.ansiLoggerEnabled = ansiLoggerEnabled;
        this.environmentInitEnabled = environmentInitEnabled;
        this.kubernetesDomain = kubernetesDomain;
        this.dockerRegistry = dockerRegistry;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public URL getEnvironmentConfigUrl() {
        return this.environmentConfigUrl;
    }

    @Override
    public List<URL> getEnvironmentDependencies() {
        return this.environmentDependencies;
    }

    @Override
    public boolean isNamespaceLazyCreateEnabled() {
        return this.namespaceLazyCreateEnabled;
    }

    @Override
    public boolean isNamespaceCleanupEnabled() {
        return this.namespaceCleanupEnabled;
    }

    @Override
    public long getNamespaceCleanupTimeout() {
        return this.namespaceCleanupTimeout;
    }

    @Override
    public boolean isNamespaceCleanupConfirmationEnabled() {
        return this.namespaceCleanupConfirmationEnabled;
    }

    @Override
    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public long getWaitPollInterval() {
        return this.waitPollInterval;
    }

    @Override
    public boolean isWaitForServiceConnectionEnabled() {
        return this.waitForServiceConnectionEnabled;
    }

    @Override
    public List<String> getWaitForServiceList() {
        return this.waitForServiceList;
    }

    @Override
    public long getWaitForServiceConnectionTimeout() {
        return this.waitForServiceConnectionTimeout;
    }

    @Override
    public boolean isAnsiLoggerEnabled() {
        return this.ansiLoggerEnabled;
    }

    @Override
    public boolean isEnvironmentInitEnabled() {
        return this.environmentInitEnabled;
    }

    @Override
    public String getKubernetesDomain() {
        return this.kubernetesDomain;
    }

    @Override
    public String getDockerRegistry() {
        return this.dockerRegistry;
    }

    public static String getDockerRegistry(Map<String, String> map) throws MalformedURLException {
        if (map.containsKey("docker.registry")) {
            return map.get("docker.registry");
        }
        String registry = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)"docker.registry");
        if (Strings.isNotNullOrEmpty((String)registry)) {
            return registry;
        }
        String registryHost = SystemEnvironmentVariables.getEnvironmentVariable((String)"DOCKER_REGISTRY_HOST");
        String registryPort = SystemEnvironmentVariables.getEnvironmentVariable((String)"DOCKER_REGISTRY_PORT");
        if (Strings.isNotNullOrEmpty((String)registry) && Strings.isNotNullOrEmpty((String)registryPort)) {
            return String.format("%s:%s", registryHost, registryPort);
        }
        return null;
    }

    public static URL getKubernetesConfigurationUrl(Map<String, String> map) throws MalformedURLException {
        if (map.containsKey("env.config.url")) {
            return new URL(map.get("env.config.url"));
        }
        if (map.containsKey("env.config.resource.name")) {
            String resourceName = map.get("env.config.resource.name");
            return DefaultConfiguration.findConfigResource(resourceName);
        }
        if (Strings.isNotNullOrEmpty((String)Utils.getSystemPropertyOrEnvVar((String)"env.config.url", (String)""))) {
            return new URL(Utils.getSystemPropertyOrEnvVar((String)"env.config.url", (String)""));
        }
        String defaultValue = "/kubernetes.json";
        String resourceName = Utils.getSystemPropertyOrEnvVar((String)"env.config.resource.name", (String)defaultValue);
        URL answer = DefaultConfiguration.findConfigResource(resourceName);
        if (answer == null) {
            // empty if block
        }
        return answer;
    }

    public static URL findConfigResource(String resourceName) {
        return resourceName.startsWith("/") ? DefaultConfiguration.class.getResource(resourceName) : DefaultConfiguration.class.getResource("/" + resourceName);
    }
}

