/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.await;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.impl.await.CompositeCondition;
import org.arquillian.cube.kubernetes.impl.await.SessionPodsAreReady;
import org.arquillian.cube.kubernetes.impl.await.SessionServicesAreReady;

public class WaitStrategy
implements Visitor {
    private static final int POD_READY = 1;
    private static final int SERIVCE_READY = 2;
    private final KubernetesClient client;
    private final Session session;
    private final Configuration configuration;
    private final Callable<Boolean> sessionPodsReady;
    private final Callable<Boolean> servicesReady;
    private final Map<Integer, Callable<Boolean>> conditions = new TreeMap<Integer, Callable<Boolean>>();

    public WaitStrategy(KubernetesClient client, Session session, Configuration configuration) {
        this.client = client;
        this.session = session;
        this.configuration = configuration;
        this.sessionPodsReady = new SessionPodsAreReady(client, session);
        this.servicesReady = new SessionServicesAreReady(client, session, configuration);
    }

    public boolean await() throws Exception {
        long start = System.currentTimeMillis();
        CompositeCondition condition = new CompositeCondition(this.conditions.values());
        while (!Thread.interrupted() && System.currentTimeMillis() - start <= this.configuration.getWaitTimeout()) {
            try {
                if (((Boolean)condition.call()).booleanValue()) {
                    return true;
                }
                Thread.sleep(this.configuration.getWaitPollInterval());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    public void visit(Object o) {
        if (o instanceof ContainerBuilder) {
            this.conditions.put(1, this.sessionPodsReady);
        } else if (o instanceof ServiceBuilder) {
            this.conditions.put(2, this.servicesReady);
        }
    }
}

