/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.enricher;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import org.arquillian.cube.kubernetes.annotations.Port;
import org.arquillian.cube.kubernetes.annotations.PortForward;
import org.arquillian.cube.kubernetes.annotations.Scheme;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.api.SessionListener;
import org.arquillian.cube.kubernetes.impl.enricher.AbstractKubernetesResourceProvider;
import org.arquillian.cube.kubernetes.impl.portforward.PortForwarder;
import org.jboss.arquillian.test.api.ArquillianResource;

public class UrlResourceProvider
extends AbstractKubernetesResourceProvider {
    private static final String SERVICE_PATH = "api.service.kubernetes.io/path";
    private static final String SERVICE_SCHEME = "api.service.kubernetes.io/scheme";
    private static final String DEFAULT_SCHEME = "http";
    private static final String DEFAULT_PATH = "/";
    private static final String POD = "Pod";
    private static final String LOCALHOST = "localhost";
    private static final Random RANDOM = new Random();

    public boolean canProvide(Class<?> type) {
        return URL.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        String name = this.getName(qualifiers);
        String namespace = this.getSession().getNamespace();
        Service service = (Service)((ClientResource)((ClientNonNamespaceOperation)this.getClient().services().inNamespace(namespace)).withName(name)).get();
        String scheme = UrlResourceProvider.getScheme(service, qualifiers);
        String path = UrlResourceProvider.getPath(service, qualifiers);
        String ip = service.getSpec().getClusterIP();
        int port = 0;
        if (UrlResourceProvider.isPortForwardingEnabled(qualifiers)) {
            Pod pod = UrlResourceProvider.getRandomPod(this.getClient(), name, namespace);
            int containerPort = UrlResourceProvider.getContainerPort(service, qualifiers);
            port = this.portForward(this.getClient(), this.getSession(), pod.getMetadata().getName(), containerPort);
            ip = LOCALHOST;
        } else {
            port = UrlResourceProvider.getPort(service, qualifiers);
        }
        try {
            if (port > 0) {
                return new URL(scheme, ip, port, path);
            }
            return new URL(scheme, ip, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot resolve URL for service: [" + name + "] in namespace:[" + namespace + "].");
        }
    }

    private int portForward(KubernetesClient client, Session session, String podName, int targetPort) {
        return this.portForward(client, session, podName, UrlResourceProvider.findRandomFreeLocalPort(), targetPort);
    }

    private int portForward(KubernetesClient client, Session session, String podName, int sourcePort, int targetPort) {
        try {
            final PortForwarder portForwarder = new PortForwarder(this.getClient().getConfiguration(), podName);
            portForwarder.forwardPort(sourcePort, targetPort);
            session.addListener(new SessionListener(){

                @Override
                public void onClose() {
                    portForwarder.close();
                }
            });
            return sourcePort;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isPortForwardingEnabled(Annotation ... qualifiers) {
        for (Annotation q : qualifiers) {
            if (!(q instanceof PortForward)) continue;
            return true;
        }
        return false;
    }

    private static ServicePort findQualifiedServicePort(Service service, Annotation ... qualifiers) {
        Port port = null;
        for (Annotation q : qualifiers) {
            if (!(q instanceof Port)) continue;
            port = (Port)q;
        }
        if (service.getSpec() != null && service.getSpec().getPorts() != null) {
            for (ServicePort servicePort : service.getSpec().getPorts()) {
                if (port == null) {
                    return servicePort;
                }
                if (servicePort.getName() == null || !servicePort.getName().equals(port.name())) continue;
                return servicePort;
            }
        }
        return null;
    }

    private static int getPort(Service service, Annotation ... qualifiers) {
        for (Annotation q : qualifiers) {
            Port port;
            if (!(q instanceof Port) || (port = (Port)q).value() <= 0) continue;
            return port.value();
        }
        ServicePort servicePort = UrlResourceProvider.findQualifiedServicePort(service, qualifiers);
        if (servicePort != null) {
            return servicePort.getPort();
        }
        return 0;
    }

    private static int getContainerPort(Service service, Annotation ... qualifiers) {
        for (Annotation q : qualifiers) {
            Port port;
            if (!(q instanceof Port) || (port = (Port)q).value() <= 0) continue;
            return port.value();
        }
        ServicePort servicePort = UrlResourceProvider.findQualifiedServicePort(service, qualifiers);
        if (servicePort != null) {
            return servicePort.getTargetPort().getIntVal();
        }
        return 0;
    }

    private static String getScheme(Service service, Annotation ... qualifiers) {
        String s;
        for (Annotation q : qualifiers) {
            if (!(q instanceof Scheme)) continue;
            return ((Scheme)q).value();
        }
        if (service.getMetadata() != null && service.getMetadata().getAnnotations() != null && (s = (String)service.getMetadata().getAnnotations().get(SERVICE_SCHEME)) != null && s.isEmpty()) {
            return s;
        }
        return DEFAULT_SCHEME;
    }

    private static String getPath(Service service, Annotation ... qualifiers) {
        String s;
        for (Annotation q : qualifiers) {
            if (!(q instanceof Scheme)) continue;
            return ((Scheme)q).value();
        }
        if (service.getMetadata() != null && service.getMetadata().getAnnotations() != null && (s = (String)service.getMetadata().getAnnotations().get(SERVICE_SCHEME)) != null && s.isEmpty()) {
            return s;
        }
        return DEFAULT_PATH;
    }

    private static Pod getRandomPod(KubernetesClient client, String name, String namespace) {
        Endpoints endpoints = (Endpoints)((ClientResource)((ClientNonNamespaceOperation)client.endpoints().inNamespace(namespace)).withName(name)).get();
        ArrayList<String> pods = new ArrayList<String>();
        if (endpoints != null) {
            for (EndpointSubset subset : endpoints.getSubsets()) {
                for (EndpointAddress address : subset.getAddresses()) {
                    String pod;
                    if (address.getTargetRef() == null || !POD.equals(address.getTargetRef().getKind()) || (pod = address.getTargetRef().getName()) == null || pod.isEmpty()) continue;
                    pods.add(pod);
                }
            }
        }
        if (pods.isEmpty()) {
            return null;
        }
        String chosen = (String)pods.get(RANDOM.nextInt(pods.size()));
        return (Pod)((ClientPodResource)((ClientNonNamespaceOperation)client.pods().inNamespace(namespace)).withName(chosen)).get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int findRandomFreeLocalPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

