/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.resolve;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.arquillian.cube.impl.util.IOUtil;
import org.arquillian.cube.kubernetes.api.DependencyResolver;
import org.arquillian.cube.kubernetes.api.Session;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;

public class ShrinkwrapResolver
implements DependencyResolver {
    public static final String JAR = "jar";
    public static final String JSON_SUFFIX = ".json";
    public static final String DEFAULT_PATH_TO_POM = "pom.xml";
    private final String pathToPomFile;
    private final boolean rethrowExceptions;

    public ShrinkwrapResolver() {
        this(DEFAULT_PATH_TO_POM, false);
    }

    public ShrinkwrapResolver(String pathToPomFile, boolean rethrowExceptions) {
        this.pathToPomFile = pathToPomFile;
        this.rethrowExceptions = rethrowExceptions;
    }

    @Override
    public List<URL> resolve(Session session) throws IOException {
        ArrayList<URL> dependencies = new ArrayList<URL>();
        try {
            File[] files;
            for (File f : files = ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile(this.pathToPomFile)).importTestDependencies()).resolve()).withoutTransitivity()).asFile()) {
                if (f.getName().endsWith(JAR) && this.hasKubernetesJson(f)) {
                    Path dir = Files.createTempDirectory(session.getId(), new FileAttribute[0]);
                    try (FileInputStream fis = new FileInputStream(f);
                         JarInputStream jis = new JarInputStream(fis);){
                        IOUtil.unzip((InputStream)new FileInputStream(f), (File)dir.toFile());
                        File jsonPath = dir.resolve("kubernetes.json").toFile();
                        if (!jsonPath.exists()) continue;
                        dependencies.add(jsonPath.toURI().toURL());
                        continue;
                    }
                }
                if (!f.getName().endsWith(JSON_SUFFIX)) continue;
                dependencies.add(f.toURI().toURL());
            }
        }
        catch (Exception e) {
            if (this.rethrowExceptions) {
                throw e;
            }
            session.getLogger().warn("Skipping maven project dependencies. Caused by:" + e.getMessage());
        }
        return dependencies;
    }

    private boolean hasKubernetesJson(File f) throws IOException {
        return this.hasResource(f, "kubernetes.json");
    }

    private boolean hasResource(File f, String name) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);
             JarInputStream jis = new JarInputStream(fis);){
            JarEntry entry = jis.getNextJarEntry();
            while (true) {
                if (entry != null) {
                    if (entry.getName().equals(name)) {
                        boolean bl = true;
                        return bl;
                    }
                    entry = jis.getNextJarEntry();
                    continue;
                }
                break;
            }
        }
        return false;
    }
}

