/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.api.AnnotationProvider;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.DependencyResolver;
import org.arquillian.cube.kubernetes.api.KubernetesResourceLocator;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.impl.ShutdownHook;
import org.arquillian.cube.kubernetes.impl.event.AfterStart;
import org.arquillian.cube.kubernetes.impl.event.Start;
import org.arquillian.cube.kubernetes.impl.event.Stop;
import org.arquillian.cube.kubernetes.impl.visitor.CompositeVisitor;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;

public class SessionCreatedListener {
    @Inject
    Instance<KubernetesClient> kubernetesClient;
    @Inject
    Instance<Configuration> configuration;
    @Inject
    Instance<AnnotationProvider> annotationProvider;
    @Inject
    Instance<NamespaceService> namespaceService;
    @Inject
    Instance<KubernetesResourceLocator> kubernetesResourceLocator;
    @Inject
    Instance<DependencyResolver> dependencyResolver;
    @Inject
    Instance<ServiceLoader> serviceLoader;
    @Inject
    Event<AfterStart> afterStartEvent;
    private ShutdownHook shutdownHook;

    public void start(@Observes Start event) throws Exception {
        KubernetesClient kubernetesClient = (KubernetesClient)this.kubernetesClient.get();
        ServiceLoader serviceLoader = (ServiceLoader)this.serviceLoader.get();
        Configuration configuration = (Configuration)this.configuration.get();
        NamespaceService namespaceService = (NamespaceService)this.namespaceService.get();
        final Session session = event.getSession();
        Logger log = session.getLogger();
        String namespace = session.getNamespace();
        log.status("Using Kubernetes at: " + kubernetesClient.getMasterUrl());
        log.status("Creating kubernetes resources inside namespace: " + namespace);
        log.info("if you use OpenShift then type this switch namespaces:     oc project " + namespace);
        log.info("if you use kubernetes then type this to switch namespaces: kubectl namespace " + namespace);
        String namespaceToUse = configuration.getNamespace();
        if (Strings.isNullOrEmpty((String)namespaceToUse)) {
            namespaceService.create(session.getNamespace());
        } else if (!namespaceService.exists(session.getNamespace()).booleanValue()) {
            if (configuration.isNamespaceLazyCreateEnabled()) {
                namespaceService.create(session.getNamespace());
            } else {
                throw new IllegalStateException("Namespace [" + session.getNamespace() + "] doesn't exists");
            }
        }
        this.shutdownHook = new ShutdownHook(new Runnable(){

            @Override
            public void run() {
                SessionCreatedListener.this.cleanupSession(session, "ABORTED");
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        ArrayList visitors = new ArrayList(serviceLoader.all(Visitor.class));
        CompositeVisitor compositeVisitor = new CompositeVisitor(visitors);
        ArrayList all = new ArrayList();
        try {
            List<URL> dependencyUrls;
            URL configUrl = configuration.getEnvironmentConfigUrl();
            List<URL> list = dependencyUrls = !configuration.getEnvironmentDependencies().isEmpty() ? configuration.getEnvironmentDependencies() : ((DependencyResolver)this.dependencyResolver.get()).resolve(session);
            if (configuration.isEnvironmentInitEnabled()) {
                for (URL dependencyUrl : dependencyUrls) {
                    log.info("Found dependency: " + dependencyUrl);
                    InputStream is2 = dependencyUrl.openStream();
                    Throwable throwable = null;
                    try {
                        all.addAll((Collection)((ListVisitFromServerGetDeleteRecreateWaitApplicable)kubernetesClient.load(is2).accept(compositeVisitor)).createOrReplace());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is2 == null) continue;
                        if (throwable != null) {
                            try {
                                is2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is2.close();
                    }
                }
                if (configUrl == null) {
                    configUrl = ((KubernetesResourceLocator)this.kubernetesResourceLocator.get()).locate();
                }
                if (configUrl != null) {
                    log.status("Applying kubernetes configuration from: " + configUrl);
                    InputStream is = configUrl.openStream();
                    Object object = null;
                    try {
                        all.addAll((Collection)kubernetesClient.load(is).get());
                    }
                    catch (Throwable is2) {
                        object = is2;
                        throw is2;
                    }
                    finally {
                        if (is != null) {
                            if (object != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable is2) {
                                    ((Throwable)object).addSuppressed(is2);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                } else {
                    log.warn("Did not find any kubernetes configuration.");
                }
            }
            if (configuration.isEnvironmentInitEnabled()) {
                try {
                    ((Waitable)kubernetesClient.resourceList(all).createOrReplaceAnd()).waitUntilReady(configuration.getWaitTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (KubernetesClientTimeoutException t) {
                    log.warn("The are resources in not ready state.");
                    for (HasMetadata r : t.getResourcesNotReady()) {
                        log.error(r.getKind() + " name: " + r.getMetadata().getName() + " namespace:" + r.getMetadata().getNamespace());
                    }
                    throw new IllegalStateException("Environment not initialized in time.", t);
                }
            }
            this.displaySessionStatus(session);
            this.afterStartEvent.fire((Object)new AfterStart(session));
        }
        catch (Exception e) {
            try {
                this.cleanupSession(session, "ERROR");
            }
            catch (Exception me) {
                throw e;
            }
            finally {
                if (this.shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Observes Stop event, Configuration configuration) throws Exception {
        try {
            Session session = event.getSession();
            this.cleanupSession(session, this.getSessionStatus(session));
        }
        finally {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
    }

    private void cleanupSession(Session session, String status) {
        NamespaceService namespaceService = (NamespaceService)this.namespaceService.get();
        AnnotationProvider annotationProvider = (AnnotationProvider)this.annotationProvider.get();
        Configuration configuration = (Configuration)this.configuration.get();
        String namespace = session.getNamespace();
        if (configuration.isNamespaceCleanupEnabled()) {
            namespaceService.clean(namespace);
            namespaceService.destroy(namespace);
        } else {
            namespaceService.annotate(session.getNamespace(), annotationProvider.create(session.getId(), status));
        }
    }

    private void displaySessionStatus(Session session) throws Exception {
        KubernetesClient kubernetesClient = (KubernetesClient)this.kubernetesClient.get();
        for (ReplicationController replicationController : ((ReplicationControllerList)((ClientNonNamespaceOperation)kubernetesClient.replicationControllers().inNamespace(session.getNamespace())).list()).getItems()) {
            session.getLogger().info("Replication controller: [" + replicationController.getMetadata().getName() + "]");
        }
        for (Pod pod : ((PodList)((ClientNonNamespaceOperation)kubernetesClient.pods().inNamespace(session.getNamespace())).list()).getItems()) {
            session.getLogger().info("Pod: [" + pod.getMetadata().getName() + "] Status: [" + pod.getStatus().getPhase() + "]");
        }
        for (Service service : ((ServiceList)((ClientNonNamespaceOperation)kubernetesClient.services().inNamespace(session.getNamespace())).list()).getItems()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Service: [").append(service.getMetadata().getName()).append("]").append(" IP: [").append(service.getSpec().getClusterIP()).append("]").append(" Ports: [ ");
            for (ServicePort servicePort : service.getSpec().getPorts()) {
                sb.append(servicePort.getPort()).append(" ");
            }
            sb.append("]");
            session.getLogger().info(sb.toString());
        }
    }

    private String getSessionStatus(Session session) {
        if (session.getFailed().get() > 0) {
            return "FAILED";
        }
        return "PASSED";
    }
}

