/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.portforward;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio._private.Messages;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class ChannelUtils {
    public static <I extends StreamSourceChannel, O extends StreamSinkChannel> void initiateTransfer(long count, I source, O sink, Pool<ByteBuffer> pool) {
        ChannelUtils.initiateTransfer(count, source, sink, ChannelListeners.closingChannelListener(), ChannelListeners.writeShutdownChannelListener((ChannelListener)ChannelListeners.closingChannelListener(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), ChannelListeners.closingChannelExceptionHandler(), ChannelListeners.closingChannelExceptionHandler(), pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends StreamSourceChannel, O extends StreamSinkChannel> void initiateTransfer(long count, I source, O sink, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener, ChannelExceptionHandler<? super I> readExceptionHandler, ChannelExceptionHandler<? super O> writeExceptionHandler, Pool<ByteBuffer> pool) {
        if (pool == null) {
            throw Messages.msg.nullParameter("pool");
        }
        Pooled allocated = pool.allocate();
        boolean free = true;
        try {
            block35: {
                ByteBuffer buffer = (ByteBuffer)allocated.getResource();
                do {
                    long transferred;
                    try {
                        transferred = source.transferTo(count, buffer, sink);
                    }
                    catch (IOException e) {
                        ChannelListeners.invokeChannelExceptionHandler(source, readExceptionHandler, (IOException)e);
                        if (free) {
                            allocated.free();
                        }
                        return;
                    }
                    if (transferred == 0L && !buffer.hasRemaining()) break block35;
                    if (transferred == -1L) {
                        if (count == Long.MAX_VALUE) {
                            Channels.setReadListener(source, sourceListener);
                            if (sourceListener == null) {
                                source.suspendReads();
                            } else {
                                source.wakeupReads();
                            }
                            Channels.setWriteListener(sink, sinkListener);
                            if (sinkListener == null) {
                                sink.suspendWrites();
                            } else {
                                sink.wakeupWrites();
                            }
                        } else {
                            source.suspendReads();
                            sink.suspendWrites();
                            ChannelListeners.invokeChannelExceptionHandler(source, readExceptionHandler, (IOException)new EOFException());
                        }
                        return;
                    }
                    if (count != Long.MAX_VALUE) {
                        count -= transferred;
                    }
                    while (buffer.hasRemaining()) {
                        int res;
                        try {
                            res = sink.write(buffer);
                        }
                        catch (IOException e) {
                            ChannelListeners.invokeChannelExceptionHandler(sink, writeExceptionHandler, (IOException)e);
                            if (free) {
                                allocated.free();
                            }
                            return;
                        }
                        if (res == 0) {
                            final TransferListener<? super I, ? super O> listener = new TransferListener<I, O>(count, (Pooled<ByteBuffer>)allocated, source, sink, sourceListener, sinkListener, writeExceptionHandler, readExceptionHandler, 1);
                            source.suspendReads();
                            source.getReadSetter().set(listener);
                            sink.getWriteSetter().set(ChannelListeners.flushingChannelListener(listener, (ChannelExceptionHandler)new ChannelExceptionHandler<Channel>(){

                                public void handleException(Channel channel, IOException exception) {
                                    listener.writeFailed(exception);
                                }
                            }));
                            sink.resumeWrites();
                            free = false;
                            return;
                        }
                        if (count == Long.MAX_VALUE) continue;
                        count -= (long)res;
                    }
                } while (count != 0L);
                Channels.setReadListener(source, sourceListener);
                if (sourceListener == null) {
                    source.suspendReads();
                } else {
                    source.wakeupReads();
                }
                Channels.setWriteListener(sink, sinkListener);
                if (sinkListener == null) {
                    sink.suspendWrites();
                } else {
                    sink.wakeupWrites();
                }
                return;
            }
            if (!sink.flush()) {
                final TransferListener<? super I, ? super O> listener = new TransferListener<I, O>(count, (Pooled<ByteBuffer>)allocated, source, sink, sourceListener, sinkListener, writeExceptionHandler, readExceptionHandler, 1);
                source.suspendReads();
                source.getReadSetter().set(listener);
                sink.getWriteSetter().set(ChannelListeners.flushingChannelListener(listener, (ChannelExceptionHandler)new ChannelExceptionHandler<Channel>(){

                    public void handleException(Channel channel, IOException exception) {
                        listener.writeFailed(exception);
                    }
                }));
                sink.resumeWrites();
                free = false;
                return;
            }
            TransferListener<? super I, ? super O> listener = new TransferListener<I, O>(count, (Pooled<ByteBuffer>)allocated, source, sink, sourceListener, sinkListener, writeExceptionHandler, readExceptionHandler, 0);
            sink.suspendWrites();
            sink.getWriteSetter().set(listener);
            source.getReadSetter().set(listener);
            source.resumeReads();
            free = false;
            return;
        }
        finally {
            if (free) {
                allocated.free();
            }
        }
    }

    private ChannelUtils() {
    }

    static final class TransferListener<I extends StreamSourceChannel, O extends StreamSinkChannel>
    implements ChannelListener<Channel> {
        private final Pooled<ByteBuffer> pooledBuffer;
        private final I source;
        private final O sink;
        private final ChannelListener<? super I> sourceListener;
        private final ChannelListener<? super O> sinkListener;
        private final ChannelExceptionHandler<? super O> writeExceptionHandler;
        private final ChannelExceptionHandler<? super I> readExceptionHandler;
        private long count;
        private volatile int state;

        TransferListener(long count, Pooled<ByteBuffer> pooledBuffer, I source, O sink, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener, ChannelExceptionHandler<? super O> writeExceptionHandler, ChannelExceptionHandler<? super I> readExceptionHandler, int state) {
            this.count = count;
            this.pooledBuffer = pooledBuffer;
            this.source = source;
            this.sink = sink;
            this.sourceListener = sourceListener;
            this.sinkListener = sinkListener;
            this.writeExceptionHandler = writeExceptionHandler;
            this.readExceptionHandler = readExceptionHandler;
            this.state = state;
        }

        /*
         * Exception decompiling
         */
        public void handleEvent(Channel channel) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[DOLOOP]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void writeFailed(IOException e) {
            try {
                this.source.suspendReads();
                this.sink.suspendWrites();
                ChannelListeners.invokeChannelExceptionHandler(this.sink, this.writeExceptionHandler, (IOException)e);
            }
            finally {
                this.pooledBuffer.free();
            }
        }

        private void readFailed(IOException e) {
            try {
                this.source.suspendReads();
                this.sink.suspendWrites();
                ChannelListeners.invokeChannelExceptionHandler(this.source, this.readExceptionHandler, (IOException)e);
            }
            finally {
                this.pooledBuffer.free();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void done() {
            try {
                ChannelListener<? super I> sourceListener = this.sourceListener;
                ChannelListener<? super O> sinkListener = this.sinkListener;
                I source = this.source;
                O sink = this.sink;
                Channels.setReadListener(source, sourceListener);
                if (sourceListener == null) {
                    source.suspendReads();
                } else {
                    source.wakeupReads();
                }
                Channels.setWriteListener(sink, sinkListener);
                if (sinkListener == null) {
                    sink.suspendWrites();
                } else {
                    sink.wakeupWrites();
                }
            }
            finally {
                this.pooledBuffer.free();
            }
        }

        public String toString() {
            return "Transfer channel listener (" + this.source + " to " + this.sink + ") -> (" + this.sourceListener + " and " + this.sinkListener + ")";
        }
    }
}

