package org.arquillian.cube.kubernetes.impl;

import java.util.ArrayList;
import java.util.RandomAccess;
import org.arquillian.cube.kubernetes.api.Configuration;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.net.URL;
import java.util.AbstractList;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class DefaultConfigurationBuilder extends DefaultConfigurationFluentImpl<DefaultConfigurationBuilder> implements VisitableBuilder<DefaultConfiguration,DefaultConfigurationBuilder>{

     DefaultConfigurationFluent<?> fluent;

    public DefaultConfigurationBuilder(){
        this.fluent = this;
    }
    public DefaultConfigurationBuilder( DefaultConfigurationFluent<?> fluent ){
        this.fluent = fluent;
    }
    public DefaultConfigurationBuilder( DefaultConfigurationFluent<?> fluent , DefaultConfiguration instance ){
        this.fluent = fluent; fluent.withSessionId(instance.getSessionId()); fluent.withMasterUrl(instance.getMasterUrl()); fluent.withNamespace(instance.getNamespace()); fluent.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl()); fluent.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl()); fluent.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl()); fluent.withEnvironmentDependencies(instance.getEnvironmentDependencies()); fluent.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled()); fluent.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled()); fluent.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout()); fluent.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled()); fluent.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled()); fluent.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled()); fluent.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout()); fluent.withWaitTimeout(instance.getWaitTimeout()); fluent.withWaitPollInterval(instance.getWaitPollInterval()); fluent.withWaitForServiceList(instance.getWaitForServiceList()); fluent.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled()); fluent.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled()); fluent.withKubernetesDomain(instance.getKubernetesDomain()); fluent.withDockerRegistry(instance.getDockerRegistry()); 
    }
    public DefaultConfigurationBuilder( DefaultConfiguration instance ){
        this.fluent = this; this.withSessionId(instance.getSessionId()); this.withMasterUrl(instance.getMasterUrl()); this.withNamespace(instance.getNamespace()); this.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl()); this.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl()); this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl()); this.withEnvironmentDependencies(instance.getEnvironmentDependencies()); this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled()); this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled()); this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout()); this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled()); this.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled()); this.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled()); this.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout()); this.withWaitTimeout(instance.getWaitTimeout()); this.withWaitPollInterval(instance.getWaitPollInterval()); this.withWaitForServiceList(instance.getWaitForServiceList()); this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled()); this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled()); this.withKubernetesDomain(instance.getKubernetesDomain()); this.withDockerRegistry(instance.getDockerRegistry()); 
    }

public DefaultConfiguration build(){
    DefaultConfiguration buildable = new DefaultConfiguration(fluent.getSessionId(),fluent.getMasterUrl(),fluent.getNamespace(),fluent.getEnvironmentSetupScriptUrl(),fluent.getEnvironmentTeardownScriptUrl(),fluent.getEnvironmentConfigUrl(),fluent.getEnvironmentDependencies(),fluent.isNamespaceLazyCreateEnabled(),fluent.isNamespaceCleanupEnabled(),fluent.getNamespaceCleanupTimeout(),fluent.isNamespaceCleanupConfirmationEnabled(),fluent.isNamespaceDestroyEnabled(),fluent.isNamespaceDestroyConfirmationEnabled(),fluent.getNamespaceDestroyTimeout(),fluent.getWaitTimeout(),fluent.getWaitPollInterval(),fluent.getWaitForServiceList(),fluent.isAnsiLoggerEnabled(),fluent.isEnvironmentInitEnabled(),fluent.getKubernetesDomain(),fluent.getDockerRegistry());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DefaultConfigurationBuilder that = (DefaultConfigurationBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {}


}
    
