/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.api.SessionListener;

public class DefaultSession
implements Session {
    private final String id;
    private final Logger logger;
    private final String namespace;
    private final AtomicInteger passed = new AtomicInteger();
    private final AtomicInteger failed = new AtomicInteger();
    private final AtomicInteger skipped = new AtomicInteger();
    private final List<SessionListener> listeners = new ArrayList<SessionListener>();

    public DefaultSession(String id, String namespace, Logger logger) {
        this.id = id;
        this.logger = logger;
        this.namespace = namespace;
    }

    void init() {
        this.logger.status("Initializing Session:" + this.id);
    }

    void destroy() {
        this.logger.status("Destroying Session:" + this.id);
        System.out.flush();
        for (SessionListener listener : this.listeners) {
            try {
                listener.onClose();
            }
            catch (Throwable t) {
                this.logger.warn("Error calling session listener: [" + listener + "]");
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public AtomicInteger getPassed() {
        return this.passed;
    }

    @Override
    public AtomicInteger getFailed() {
        return this.failed;
    }

    @Override
    public AtomicInteger getSkipped() {
        return this.skipped;
    }

    @Override
    public void addListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(SessionListener listener) {
        this.listeners.remove(listener);
    }
}

