/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.concurrent.atomic.AtomicReference;
import org.arquillian.cube.kubernetes.api.AnnotationProvider;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.DependencyResolver;
import org.arquillian.cube.kubernetes.api.KubernetesResourceLocator;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.api.ResourceInstaller;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.impl.SessionManager;
import org.arquillian.cube.kubernetes.impl.event.AfterStart;
import org.arquillian.cube.kubernetes.impl.event.Start;
import org.arquillian.cube.kubernetes.impl.event.Stop;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class SessionManagerLifecycle {
    @Inject
    Instance<KubernetesClient> kubernetesClient;
    @Inject
    Instance<Configuration> configuration;
    @Inject
    Instance<AnnotationProvider> annotationProvider;
    @Inject
    Instance<NamespaceService> namespaceService;
    @Inject
    Instance<KubernetesResourceLocator> kubernetesResourceLocator;
    @Inject
    Instance<DependencyResolver> dependencyResolver;
    @Inject
    Instance<ResourceInstaller> resourceInstaller;
    @Inject
    Event<AfterStart> afterStartEvent;
    AtomicReference<SessionManager> sessionManagerRef = new AtomicReference();

    public void start(@Observes Start event) throws Exception {
        Session session = event.getSession();
        SessionManager sessionManager = new SessionManager(session, (KubernetesClient)this.kubernetesClient.get(), (Configuration)this.configuration.get(), (AnnotationProvider)this.annotationProvider.get(), (NamespaceService)((NamespaceService)this.namespaceService.get()).toImmutable(), (KubernetesResourceLocator)((KubernetesResourceLocator)this.kubernetesResourceLocator.get()).toImmutable(), (DependencyResolver)((DependencyResolver)this.dependencyResolver.get()).toImmutable(), (ResourceInstaller)((ResourceInstaller)this.resourceInstaller.get()).toImmutable());
        this.sessionManagerRef.set(sessionManager);
        sessionManager.start();
        this.afterStartEvent.fire((Object)new AfterStart(session));
    }

    public void stop(@Observes Stop event, Configuration configuration) throws Exception {
        SessionManager sessionManager = this.sessionManagerRef.get();
        if (sessionManager != null) {
            sessionManager.stop();
        }
    }
}

