/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.api.Logger;

public class ProcessUtil {
    public static int runCommand(Logger log, URL scriptUrl) throws IOException {
        return ProcessUtil.runCommand(log, scriptUrl, Collections.emptyMap());
    }

    public static int runCommand(Logger log, URL scriptUrl, Map<String, String> env) throws IOException {
        File scriptFile = File.createTempFile("arquillian-cube-script", ProcessUtil.getSuffix());
        FileUtils.copyURLToFile((URL)scriptUrl, (File)scriptFile);
        scriptFile.setExecutable(true, false);
        return ProcessUtil.runCommand(log, ProcessUtil.getCommand(), Arrays.asList(scriptFile.getAbsolutePath()), env, true);
    }

    public static int runCommand(Logger log, String command, List<String> args, Map<String, String> env, boolean withShutdownHook) throws IOException {
        String[] commandWithArgs = ProcessUtil.prepareCommandArray(command, args);
        String[] envp = ProcessUtil.prepareEnvp(env);
        Process process = Runtime.getRuntime().exec(commandWithArgs, envp);
        if (withShutdownHook) {
            ProcessUtil.addShutdownHook(log, process, command);
        }
        List<Thread> threads = ProcessUtil.startLoggingThreads(process, log, command + " " + Strings.join(args, (String)" "));
        try {
            int answer = process.waitFor();
            ProcessUtil.joinThreads(threads, log);
            return answer;
        }
        catch (InterruptedException e) {
            return process.exitValue();
        }
    }

    private static void joinThreads(List<Thread> threads, Logger log) {
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.warn("Caught " + e.getMessage());
            }
        }
    }

    private static void addShutdownHook(final Logger log, final Process process, final String command) {
        Runtime.getRuntime().addShutdownHook(new Thread(command){

            @Override
            public void run() {
                if (process != null) {
                    log.info("Terminating process [" + command + "]");
                    try {
                        process.destroy();
                    }
                    catch (Exception e) {
                        log.error("Failed to terminate process [" + command + "]");
                    }
                }
            }
        });
    }

    private static String[] prepareCommandArray(String command, List<String> args) {
        int i;
        List nCmd = Strings.splitAndTrimAsList((String)command, (String)" ");
        ArrayList nArgs = args != null ? args : new ArrayList();
        String[] commandWithArgs = new String[nCmd.size() + nArgs.size()];
        for (i = 0; i < nCmd.size(); ++i) {
            commandWithArgs[i] = (String)nCmd.get(i);
        }
        for (i = 0; i < nArgs.size(); ++i) {
            commandWithArgs[i + nCmd.size()] = (String)nArgs.get(i);
        }
        return commandWithArgs;
    }

    private static String[] prepareEnvp(Map<String, String> env) {
        String[] envp = new String[env.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : env.entrySet()) {
            envp[i++] = entry.getKey() + "=" + entry.getValue();
        }
        return envp;
    }

    private static void processOutput(InputStream inputStream, Function<String, Void> function) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                function.apply(line);
            }
        }
    }

    private static List<Thread> startLoggingThreads(Process process, Logger log, String commandDesc) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        threads.add(ProcessUtil.startOutputLoggingThread(process, log, commandDesc));
        threads.add(ProcessUtil.startErrorLoggingThread(process, log, commandDesc));
        return threads;
    }

    private static Thread startErrorLoggingThread(final Process process, final Logger log, final String commandDesc) {
        Thread logThread = new Thread("[ERR] " + commandDesc){

            @Override
            public void run() {
                try {
                    ProcessUtil.processOutput(process.getErrorStream(), ProcessUtil.createErrorHandler(log));
                }
                catch (IOException e) {
                    log.error("Failed to read error stream from [" + commandDesc + "] : [" + e.getMessage() + "]");
                }
            }
        };
        logThread.setDaemon(true);
        logThread.start();
        return logThread;
    }

    private static Thread startOutputLoggingThread(final Process process, final Logger log, final String commandDesc) {
        Thread logThread = new Thread("[OUT] " + commandDesc){

            @Override
            public void run() {
                try {
                    ProcessUtil.processOutput(process.getInputStream(), ProcessUtil.createOutputHandler(log));
                }
                catch (IOException e) {
                    log.error("Failed to read output stream from [" + commandDesc + "] : [" + e.getMessage() + "]");
                }
            }
        };
        logThread.setDaemon(true);
        logThread.start();
        return logThread;
    }

    private static Function<String, Void> createOutputHandler(final Logger log) {
        return new Function<String, Void>(){

            @Override
            public Void apply(String outputLine) {
                log.info(outputLine);
                return null;
            }
        };
    }

    private static Function<String, Void> createErrorHandler(final Logger log) {
        return new Function<String, Void>(){

            @Override
            public Void apply(String outputLine) {
                log.error(outputLine);
                return null;
            }
        };
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    private static final String getCommand() {
        if (ProcessUtil.isWindows()) {
            return "cmd /c start";
        }
        return "/bin/sh -c";
    }

    private static final String getSuffix() {
        if (ProcessUtil.isWindows()) {
            return ".bat";
        }
        return ".sh";
    }
}

