/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.enricher.internal;

import io.fabric8.kubernetes.api.model.v4_0.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v4_0.apps.ReplicaSetList;
import io.fabric8.kubernetes.clnt.v4_0.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v4_0.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_0.dsl.RollableScalableResource;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.kubernetes.impl.enricher.AbstractKubernetesResourceProvider;
import org.jboss.arquillian.test.api.ArquillianResource;

public class ReplicaSetResourceProvider
extends AbstractKubernetesResourceProvider {
    public boolean canProvide(Class<?> type) {
        return ReplicaSet.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        String name = this.getName(qualifiers);
        String namespace = this.getNamespace(qualifiers);
        if (name != null) {
            return ((RollableScalableResource)((NonNamespaceOperation)this.getClient().extensions().replicaSets().inNamespace(namespace)).withName(name)).get();
        }
        Map<String, String> labels = this.getLabels(qualifiers);
        ReplicaSetList list = (ReplicaSetList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getClient().extensions().replicaSets().inNamespace(namespace)).withLabels(labels)).list();
        List replicaSets = list.getItems();
        if (!replicaSets.isEmpty()) {
            return replicaSets.get(0);
        }
        return null;
    }
}

