package org.arquillian.cube.kubernetes.impl;

import java.util.ArrayList;
import java.util.RandomAccess;
import org.arquillian.cube.kubernetes.api.Configuration;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.List;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.net.URL;
import java.util.AbstractList;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import java.io.IOException;
import io.fabric8.kubernetes.api.builder.v4_0.Visitable;
import io.fabric8.kubernetes.api.builder.v4_0.Fluent;
import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;

public class DefaultConfigurationFluentImpl<A extends DefaultConfigurationFluent<A>> extends BaseFluent<A> implements DefaultConfigurationFluent<A>{

     String sessionId;     String namespace;     URL masterUrl;     Map<String, String> scriptEnvironmentVariables = new HashMap();     URL environmentSetupScriptUrl;     URL environmentTeardownScriptUrl;     URL environmentConfigUrl;     List<URL> environmentDependencies = new ArrayList();     boolean namespaceLazyCreateEnabled;     boolean namespaceCleanupEnabled;     long namespaceCleanupTimeout;     boolean namespaceCleanupConfirmationEnabled;     boolean namespaceUseCurrentEnabled;     boolean namespaceDestroyEnabled;     boolean namespaceDestroyConfirmationEnabled;     long namespaceDestroyTimeout;     boolean waitEnabled;     long waitTimeout;     long waitPollInterval;     List<String> waitForServiceList = new ArrayList();     boolean ansiLoggerEnabled;     boolean environmentInitEnabled;     boolean logCopyEnabled;     String logPath;     String kubernetesDomain;     String dockerRegistry;     String username;     String password;     String apiVersion;     boolean trustCerts;     boolean fmpBuildEnabled;     boolean fmpBuildForMavenDisable;     boolean fmpDebugOutput;     boolean fmpLogsEnabled;     String fmpPomPath;     List<String> fmpProfiles = new ArrayList();     List<String> fmpSystemProperties = new ArrayList();     String fmpBuildOptions;     String token;
public DefaultConfigurationFluentImpl(){
    
}
public DefaultConfigurationFluentImpl( DefaultConfiguration instance ){
    this.withSessionId(instance.getSessionId()); this.withMasterUrl(instance.getMasterUrl()); this.withNamespace(instance.getNamespace()); this.withScriptEnvironmentVariables(instance.getScriptEnvironmentVariables()); this.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl()); this.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl()); this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl()); this.withEnvironmentDependencies(instance.getEnvironmentDependencies()); this.withNamespaceUseCurrentEnabled(instance.isNamespaceUseCurrentEnabled()); this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled()); this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled()); this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout()); this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled()); this.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled()); this.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled()); this.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout()); this.withWaitEnabled(instance.isWaitEnabled()); this.withWaitTimeout(instance.getWaitTimeout()); this.withWaitPollInterval(instance.getWaitPollInterval()); this.withWaitForServiceList(instance.getWaitForServiceList()); this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled()); this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled()); this.withLogCopyEnabled(instance.isLogCopyEnabled()); this.withLogPath(instance.getLogPath()); this.withKubernetesDomain(instance.getKubernetesDomain()); this.withDockerRegistry(instance.getDockerRegistry()); this.withToken(instance.getToken()); this.withUsername(instance.getUsername()); this.withPassword(instance.getPassword()); this.withApiVersion(instance.getApiVersion()); this.withTrustCerts(instance.isTrustCerts()); this.withFmpBuildEnabled(instance.isFmpBuildEnabled()); this.withFmpBuildForMavenDisable(instance.isFmpBuildForMavenDisable()); this.withFmpDebugOutput(instance.isFmpDebugOutput()); this.withFmpLogsEnabled(instance.isFmpLogsEnabled()); this.withFmpPomPath(instance.getFmpPomPath()); this.withFmpProfiles(instance.getFmpProfiles()); this.withFmpSystemProperties(instance.getFmpSystemProperties()); this.withFmpBuildOptions(instance.getFmpBuildOptions()); 
}

    public String getSessionId(){
    return this.sessionId;
    }
    public A withSessionId( String sessionId){
    this.sessionId=sessionId; return (A) this;
    }
    public String getNamespace(){
    return this.namespace;
    }
    public A withNamespace( String namespace){
    this.namespace=namespace; return (A) this;
    }
    public URL getMasterUrl(){
    return this.masterUrl;
    }
    public A withMasterUrl( URL masterUrl){
    this.masterUrl=masterUrl; return (A) this;
    }
    public A addToScriptEnvironmentVariables( String key,  String value){
    if(key != null && value != null) {this.scriptEnvironmentVariables.put(key, value);} return (A)this;
    }
    public A addToScriptEnvironmentVariables( Map<String, String> map){
    if(map != null) { this.scriptEnvironmentVariables.putAll(map);} return (A)this;
    }
    public A removeFromScriptEnvironmentVariables( String key){
    if(key != null) {this.scriptEnvironmentVariables.remove(key);} return (A)this;
    }
    public A removeFromScriptEnvironmentVariables( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.scriptEnvironmentVariables.remove(key);}} return (A)this;
    }
    public Map<String, String> getScriptEnvironmentVariables(){
    return this.scriptEnvironmentVariables;
    }
    public A withScriptEnvironmentVariables( Map<String, String> scriptEnvironmentVariables){
    this.scriptEnvironmentVariables.clear();if (scriptEnvironmentVariables != null) {this.scriptEnvironmentVariables.putAll(scriptEnvironmentVariables);} return (A) this;
    }
    public URL getEnvironmentSetupScriptUrl(){
    return this.environmentSetupScriptUrl;
    }
    public A withEnvironmentSetupScriptUrl( URL environmentSetupScriptUrl){
    this.environmentSetupScriptUrl=environmentSetupScriptUrl; return (A) this;
    }
    public URL getEnvironmentTeardownScriptUrl(){
    return this.environmentTeardownScriptUrl;
    }
    public A withEnvironmentTeardownScriptUrl( URL environmentTeardownScriptUrl){
    this.environmentTeardownScriptUrl=environmentTeardownScriptUrl; return (A) this;
    }
    public URL getEnvironmentConfigUrl(){
    return this.environmentConfigUrl;
    }
    public A withEnvironmentConfigUrl( URL environmentConfigUrl){
    this.environmentConfigUrl=environmentConfigUrl; return (A) this;
    }
    public A addToEnvironmentDependencies( URL ...items){
    for (URL item : items) {this.environmentDependencies.add(item);} return (A)this;
    }
    public A removeFromEnvironmentDependencies( URL ...items){
    for (URL item : items) {this.environmentDependencies.remove(item);} return (A)this;
    }
    public List<URL> getEnvironmentDependencies(){
    return this.environmentDependencies;
    }
    public A withEnvironmentDependencies( List<URL> environmentDependencies){
    this.environmentDependencies.clear();if (environmentDependencies != null) {for (URL item : environmentDependencies){this.addToEnvironmentDependencies(item);}} return (A) this;
    }
    public A withEnvironmentDependencies( URL ...environmentDependencies){
    this.environmentDependencies.clear(); if (environmentDependencies != null) {for (URL item :environmentDependencies){ this.addToEnvironmentDependencies(item);}} return (A) this;
    }
    public boolean isNamespaceLazyCreateEnabled(){
    return this.namespaceLazyCreateEnabled;
    }
    public A withNamespaceLazyCreateEnabled( boolean namespaceLazyCreateEnabled){
    this.namespaceLazyCreateEnabled=namespaceLazyCreateEnabled; return (A) this;
    }
    public boolean isNamespaceCleanupEnabled(){
    return this.namespaceCleanupEnabled;
    }
    public A withNamespaceCleanupEnabled( boolean namespaceCleanupEnabled){
    this.namespaceCleanupEnabled=namespaceCleanupEnabled; return (A) this;
    }
    public long getNamespaceCleanupTimeout(){
    return this.namespaceCleanupTimeout;
    }
    public A withNamespaceCleanupTimeout( long namespaceCleanupTimeout){
    this.namespaceCleanupTimeout=namespaceCleanupTimeout; return (A) this;
    }
    public boolean isNamespaceCleanupConfirmationEnabled(){
    return this.namespaceCleanupConfirmationEnabled;
    }
    public A withNamespaceCleanupConfirmationEnabled( boolean namespaceCleanupConfirmationEnabled){
    this.namespaceCleanupConfirmationEnabled=namespaceCleanupConfirmationEnabled; return (A) this;
    }
    public boolean isNamespaceUseCurrentEnabled(){
    return this.namespaceUseCurrentEnabled;
    }
    public A withNamespaceUseCurrentEnabled( boolean namespaceUseCurrentEnabled){
    this.namespaceUseCurrentEnabled=namespaceUseCurrentEnabled; return (A) this;
    }
    public boolean isNamespaceDestroyEnabled(){
    return this.namespaceDestroyEnabled;
    }
    public A withNamespaceDestroyEnabled( boolean namespaceDestroyEnabled){
    this.namespaceDestroyEnabled=namespaceDestroyEnabled; return (A) this;
    }
    public boolean isNamespaceDestroyConfirmationEnabled(){
    return this.namespaceDestroyConfirmationEnabled;
    }
    public A withNamespaceDestroyConfirmationEnabled( boolean namespaceDestroyConfirmationEnabled){
    this.namespaceDestroyConfirmationEnabled=namespaceDestroyConfirmationEnabled; return (A) this;
    }
    public long getNamespaceDestroyTimeout(){
    return this.namespaceDestroyTimeout;
    }
    public A withNamespaceDestroyTimeout( long namespaceDestroyTimeout){
    this.namespaceDestroyTimeout=namespaceDestroyTimeout; return (A) this;
    }
    public boolean isWaitEnabled(){
    return this.waitEnabled;
    }
    public A withWaitEnabled( boolean waitEnabled){
    this.waitEnabled=waitEnabled; return (A) this;
    }
    public long getWaitTimeout(){
    return this.waitTimeout;
    }
    public A withWaitTimeout( long waitTimeout){
    this.waitTimeout=waitTimeout; return (A) this;
    }
    public long getWaitPollInterval(){
    return this.waitPollInterval;
    }
    public A withWaitPollInterval( long waitPollInterval){
    this.waitPollInterval=waitPollInterval; return (A) this;
    }
    public A addToWaitForServiceList( String ...items){
    for (String item : items) {this.waitForServiceList.add(item);} return (A)this;
    }
    public A removeFromWaitForServiceList( String ...items){
    for (String item : items) {this.waitForServiceList.remove(item);} return (A)this;
    }
    public List<String> getWaitForServiceList(){
    return this.waitForServiceList;
    }
    public A withWaitForServiceList( List<String> waitForServiceList){
    this.waitForServiceList.clear();if (waitForServiceList != null) {for (String item : waitForServiceList){this.addToWaitForServiceList(item);}} return (A) this;
    }
    public A withWaitForServiceList( String ...waitForServiceList){
    this.waitForServiceList.clear(); if (waitForServiceList != null) {for (String item :waitForServiceList){ this.addToWaitForServiceList(item);}} return (A) this;
    }
    public boolean isAnsiLoggerEnabled(){
    return this.ansiLoggerEnabled;
    }
    public A withAnsiLoggerEnabled( boolean ansiLoggerEnabled){
    this.ansiLoggerEnabled=ansiLoggerEnabled; return (A) this;
    }
    public boolean isEnvironmentInitEnabled(){
    return this.environmentInitEnabled;
    }
    public A withEnvironmentInitEnabled( boolean environmentInitEnabled){
    this.environmentInitEnabled=environmentInitEnabled; return (A) this;
    }
    public boolean isLogCopyEnabled(){
    return this.logCopyEnabled;
    }
    public A withLogCopyEnabled( boolean logCopyEnabled){
    this.logCopyEnabled=logCopyEnabled; return (A) this;
    }
    public String getLogPath(){
    return this.logPath;
    }
    public A withLogPath( String logPath){
    this.logPath=logPath; return (A) this;
    }
    public String getKubernetesDomain(){
    return this.kubernetesDomain;
    }
    public A withKubernetesDomain( String kubernetesDomain){
    this.kubernetesDomain=kubernetesDomain; return (A) this;
    }
    public String getDockerRegistry(){
    return this.dockerRegistry;
    }
    public A withDockerRegistry( String dockerRegistry){
    this.dockerRegistry=dockerRegistry; return (A) this;
    }
    public String getUsername(){
    return this.username;
    }
    public A withUsername( String username){
    this.username=username; return (A) this;
    }
    public String getPassword(){
    return this.password;
    }
    public A withPassword( String password){
    this.password=password; return (A) this;
    }
    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public boolean isTrustCerts(){
    return this.trustCerts;
    }
    public A withTrustCerts( boolean trustCerts){
    this.trustCerts=trustCerts; return (A) this;
    }
    public boolean isFmpBuildEnabled(){
    return this.fmpBuildEnabled;
    }
    public A withFmpBuildEnabled( boolean fmpBuildEnabled){
    this.fmpBuildEnabled=fmpBuildEnabled; return (A) this;
    }
    public boolean isFmpBuildForMavenDisable(){
    return this.fmpBuildForMavenDisable;
    }
    public A withFmpBuildForMavenDisable( boolean fmpBuildForMavenDisable){
    this.fmpBuildForMavenDisable=fmpBuildForMavenDisable; return (A) this;
    }
    public boolean isFmpDebugOutput(){
    return this.fmpDebugOutput;
    }
    public A withFmpDebugOutput( boolean fmpDebugOutput){
    this.fmpDebugOutput=fmpDebugOutput; return (A) this;
    }
    public boolean isFmpLogsEnabled(){
    return this.fmpLogsEnabled;
    }
    public A withFmpLogsEnabled( boolean fmpLogsEnabled){
    this.fmpLogsEnabled=fmpLogsEnabled; return (A) this;
    }
    public String getFmpPomPath(){
    return this.fmpPomPath;
    }
    public A withFmpPomPath( String fmpPomPath){
    this.fmpPomPath=fmpPomPath; return (A) this;
    }
    public A addToFmpProfiles( String ...items){
    for (String item : items) {this.fmpProfiles.add(item);} return (A)this;
    }
    public A removeFromFmpProfiles( String ...items){
    for (String item : items) {this.fmpProfiles.remove(item);} return (A)this;
    }
    public List<String> getFmpProfiles(){
    return this.fmpProfiles;
    }
    public A withFmpProfiles( List<String> fmpProfiles){
    this.fmpProfiles.clear();if (fmpProfiles != null) {for (String item : fmpProfiles){this.addToFmpProfiles(item);}} return (A) this;
    }
    public A withFmpProfiles( String ...fmpProfiles){
    this.fmpProfiles.clear(); if (fmpProfiles != null) {for (String item :fmpProfiles){ this.addToFmpProfiles(item);}} return (A) this;
    }
    public A addToFmpSystemProperties( String ...items){
    for (String item : items) {this.fmpSystemProperties.add(item);} return (A)this;
    }
    public A removeFromFmpSystemProperties( String ...items){
    for (String item : items) {this.fmpSystemProperties.remove(item);} return (A)this;
    }
    public List<String> getFmpSystemProperties(){
    return this.fmpSystemProperties;
    }
    public A withFmpSystemProperties( List<String> fmpSystemProperties){
    this.fmpSystemProperties.clear();if (fmpSystemProperties != null) {for (String item : fmpSystemProperties){this.addToFmpSystemProperties(item);}} return (A) this;
    }
    public A withFmpSystemProperties( String ...fmpSystemProperties){
    this.fmpSystemProperties.clear(); if (fmpSystemProperties != null) {for (String item :fmpSystemProperties){ this.addToFmpSystemProperties(item);}} return (A) this;
    }
    public String getFmpBuildOptions(){
    return this.fmpBuildOptions;
    }
    public A withFmpBuildOptions( String fmpBuildOptions){
    this.fmpBuildOptions=fmpBuildOptions; return (A) this;
    }
    public String getToken(){
    return this.token;
    }
    public A withToken( String token){
    this.token=token; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DefaultConfigurationFluentImpl that = (DefaultConfigurationFluentImpl) o;
if (sessionId != null ? !sessionId.equals(that.sessionId) :that.sessionId != null) return false;
if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
if (masterUrl != null ? !masterUrl.equals(that.masterUrl) :that.masterUrl != null) return false;
if (scriptEnvironmentVariables != null ? !scriptEnvironmentVariables.equals(that.scriptEnvironmentVariables) :that.scriptEnvironmentVariables != null) return false;
if (environmentSetupScriptUrl != null ? !environmentSetupScriptUrl.equals(that.environmentSetupScriptUrl) :that.environmentSetupScriptUrl != null) return false;
if (environmentTeardownScriptUrl != null ? !environmentTeardownScriptUrl.equals(that.environmentTeardownScriptUrl) :that.environmentTeardownScriptUrl != null) return false;
if (environmentConfigUrl != null ? !environmentConfigUrl.equals(that.environmentConfigUrl) :that.environmentConfigUrl != null) return false;
if (environmentDependencies != null ? !environmentDependencies.equals(that.environmentDependencies) :that.environmentDependencies != null) return false;
if (namespaceLazyCreateEnabled != that.namespaceLazyCreateEnabled) return false;
if (namespaceCleanupEnabled != that.namespaceCleanupEnabled) return false;
if (namespaceCleanupTimeout != that.namespaceCleanupTimeout) return false;
if (namespaceCleanupConfirmationEnabled != that.namespaceCleanupConfirmationEnabled) return false;
if (namespaceUseCurrentEnabled != that.namespaceUseCurrentEnabled) return false;
if (namespaceDestroyEnabled != that.namespaceDestroyEnabled) return false;
if (namespaceDestroyConfirmationEnabled != that.namespaceDestroyConfirmationEnabled) return false;
if (namespaceDestroyTimeout != that.namespaceDestroyTimeout) return false;
if (waitEnabled != that.waitEnabled) return false;
if (waitTimeout != that.waitTimeout) return false;
if (waitPollInterval != that.waitPollInterval) return false;
if (waitForServiceList != null ? !waitForServiceList.equals(that.waitForServiceList) :that.waitForServiceList != null) return false;
if (ansiLoggerEnabled != that.ansiLoggerEnabled) return false;
if (environmentInitEnabled != that.environmentInitEnabled) return false;
if (logCopyEnabled != that.logCopyEnabled) return false;
if (logPath != null ? !logPath.equals(that.logPath) :that.logPath != null) return false;
if (kubernetesDomain != null ? !kubernetesDomain.equals(that.kubernetesDomain) :that.kubernetesDomain != null) return false;
if (dockerRegistry != null ? !dockerRegistry.equals(that.dockerRegistry) :that.dockerRegistry != null) return false;
if (username != null ? !username.equals(that.username) :that.username != null) return false;
if (password != null ? !password.equals(that.password) :that.password != null) return false;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (trustCerts != that.trustCerts) return false;
if (fmpBuildEnabled != that.fmpBuildEnabled) return false;
if (fmpBuildForMavenDisable != that.fmpBuildForMavenDisable) return false;
if (fmpDebugOutput != that.fmpDebugOutput) return false;
if (fmpLogsEnabled != that.fmpLogsEnabled) return false;
if (fmpPomPath != null ? !fmpPomPath.equals(that.fmpPomPath) :that.fmpPomPath != null) return false;
if (fmpProfiles != null ? !fmpProfiles.equals(that.fmpProfiles) :that.fmpProfiles != null) return false;
if (fmpSystemProperties != null ? !fmpSystemProperties.equals(that.fmpSystemProperties) :that.fmpSystemProperties != null) return false;
if (fmpBuildOptions != null ? !fmpBuildOptions.equals(that.fmpBuildOptions) :that.fmpBuildOptions != null) return false;
if (token != null ? !token.equals(that.token) :that.token != null) return false;
return true;

    }



}
