package org.arquillian.cube.kubernetes.impl;

import java.util.ArrayList;
import java.util.RandomAccess;
import org.arquillian.cube.kubernetes.api.Configuration;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.List;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.net.URL;
import java.util.AbstractList;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import java.io.IOException;
import io.fabric8.kubernetes.api.builder.v4_0.Visitable;
import io.fabric8.kubernetes.api.builder.v4_0.Visitable;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.v4_0.Fluent;
import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Builder;

public class DefaultConfigurationBuilder extends DefaultConfigurationFluentImpl<DefaultConfigurationBuilder> implements VisitableBuilder<DefaultConfiguration,DefaultConfigurationBuilder>{

     DefaultConfigurationFluent<?> fluent;

    public DefaultConfigurationBuilder(){
        this.fluent = this;
    }
    public DefaultConfigurationBuilder( DefaultConfigurationFluent<?> fluent ){
        this.fluent = fluent;
    }
    public DefaultConfigurationBuilder( DefaultConfigurationFluent<?> fluent , DefaultConfiguration instance ){
        this.fluent = fluent; fluent.withSessionId(instance.getSessionId()); fluent.withMasterUrl(instance.getMasterUrl()); fluent.withNamespace(instance.getNamespace()); fluent.withScriptEnvironmentVariables(instance.getScriptEnvironmentVariables()); fluent.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl()); fluent.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl()); fluent.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl()); fluent.withEnvironmentDependencies(instance.getEnvironmentDependencies()); fluent.withNamespaceUseCurrentEnabled(instance.isNamespaceUseCurrentEnabled()); fluent.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled()); fluent.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled()); fluent.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout()); fluent.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled()); fluent.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled()); fluent.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled()); fluent.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout()); fluent.withWaitEnabled(instance.isWaitEnabled()); fluent.withWaitTimeout(instance.getWaitTimeout()); fluent.withWaitPollInterval(instance.getWaitPollInterval()); fluent.withWaitForServiceList(instance.getWaitForServiceList()); fluent.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled()); fluent.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled()); fluent.withLogCopyEnabled(instance.isLogCopyEnabled()); fluent.withLogPath(instance.getLogPath()); fluent.withKubernetesDomain(instance.getKubernetesDomain()); fluent.withDockerRegistry(instance.getDockerRegistry()); fluent.withToken(instance.getToken()); fluent.withUsername(instance.getUsername()); fluent.withPassword(instance.getPassword()); fluent.withApiVersion(instance.getApiVersion()); fluent.withTrustCerts(instance.isTrustCerts()); fluent.withFmpBuildEnabled(instance.isFmpBuildEnabled()); fluent.withFmpBuildForMavenDisable(instance.isFmpBuildForMavenDisable()); fluent.withFmpDebugOutput(instance.isFmpDebugOutput()); fluent.withFmpLogsEnabled(instance.isFmpLogsEnabled()); fluent.withFmpPomPath(instance.getFmpPomPath()); fluent.withFmpProfiles(instance.getFmpProfiles()); fluent.withFmpSystemProperties(instance.getFmpSystemProperties()); fluent.withFmpBuildOptions(instance.getFmpBuildOptions()); 
    }
    public DefaultConfigurationBuilder( DefaultConfiguration instance ){
        this.fluent = this; this.withSessionId(instance.getSessionId()); this.withMasterUrl(instance.getMasterUrl()); this.withNamespace(instance.getNamespace()); this.withScriptEnvironmentVariables(instance.getScriptEnvironmentVariables()); this.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl()); this.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl()); this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl()); this.withEnvironmentDependencies(instance.getEnvironmentDependencies()); this.withNamespaceUseCurrentEnabled(instance.isNamespaceUseCurrentEnabled()); this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled()); this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled()); this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout()); this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled()); this.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled()); this.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled()); this.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout()); this.withWaitEnabled(instance.isWaitEnabled()); this.withWaitTimeout(instance.getWaitTimeout()); this.withWaitPollInterval(instance.getWaitPollInterval()); this.withWaitForServiceList(instance.getWaitForServiceList()); this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled()); this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled()); this.withLogCopyEnabled(instance.isLogCopyEnabled()); this.withLogPath(instance.getLogPath()); this.withKubernetesDomain(instance.getKubernetesDomain()); this.withDockerRegistry(instance.getDockerRegistry()); this.withToken(instance.getToken()); this.withUsername(instance.getUsername()); this.withPassword(instance.getPassword()); this.withApiVersion(instance.getApiVersion()); this.withTrustCerts(instance.isTrustCerts()); this.withFmpBuildEnabled(instance.isFmpBuildEnabled()); this.withFmpBuildForMavenDisable(instance.isFmpBuildForMavenDisable()); this.withFmpDebugOutput(instance.isFmpDebugOutput()); this.withFmpLogsEnabled(instance.isFmpLogsEnabled()); this.withFmpPomPath(instance.getFmpPomPath()); this.withFmpProfiles(instance.getFmpProfiles()); this.withFmpSystemProperties(instance.getFmpSystemProperties()); this.withFmpBuildOptions(instance.getFmpBuildOptions()); 
    }

public DefaultConfiguration build(){
    DefaultConfiguration buildable = new DefaultConfiguration(fluent.getSessionId(),fluent.getMasterUrl(),fluent.getNamespace(),fluent.getScriptEnvironmentVariables(),fluent.getEnvironmentSetupScriptUrl(),fluent.getEnvironmentTeardownScriptUrl(),fluent.getEnvironmentConfigUrl(),fluent.getEnvironmentDependencies(),fluent.isNamespaceUseCurrentEnabled(),fluent.isNamespaceLazyCreateEnabled(),fluent.isNamespaceCleanupEnabled(),fluent.getNamespaceCleanupTimeout(),fluent.isNamespaceCleanupConfirmationEnabled(),fluent.isNamespaceDestroyEnabled(),fluent.isNamespaceDestroyConfirmationEnabled(),fluent.getNamespaceDestroyTimeout(),fluent.isWaitEnabled(),fluent.getWaitTimeout(),fluent.getWaitPollInterval(),fluent.getWaitForServiceList(),fluent.isAnsiLoggerEnabled(),fluent.isEnvironmentInitEnabled(),fluent.isLogCopyEnabled(),fluent.getLogPath(),fluent.getKubernetesDomain(),fluent.getDockerRegistry(),fluent.getToken(),fluent.getUsername(),fluent.getPassword(),fluent.getApiVersion(),fluent.isTrustCerts(),fluent.isFmpBuildEnabled(),fluent.isFmpBuildForMavenDisable(),fluent.isFmpDebugOutput(),fluent.isFmpLogsEnabled(),fluent.getFmpPomPath(),fluent.getFmpProfiles(),fluent.getFmpSystemProperties(),fluent.getFmpBuildOptions());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DefaultConfigurationBuilder that = (DefaultConfigurationBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {}


}
    
