/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import java.util.HashMap;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.impl.DefaultSession;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;

public class TestListener {
    @Inject
    Instance<DefaultSession> session;
    @Inject
    Instance<NamespaceService> namespaceService;

    static String getPackage(TestLifecycleEvent event) {
        if (event.getTestClass() == null) {
            return "";
        }
        if (event.getTestClass().getJavaClass() == null) {
            return "";
        }
        if (event.getTestClass().getJavaClass().getPackage() == null) {
            return "";
        }
        return event.getTestClass().getJavaClass().getPackage().getName();
    }

    static String getClassName(TestLifecycleEvent event) {
        if (event.getTestClass() == null) {
            throw new IllegalArgumentException("TestLifecycleEvent does not have a valid test class");
        }
        if (event.getTestClass().getJavaClass() == null) {
            throw new IllegalArgumentException("TestLifecycleEvent does not have a valid test class");
        }
        return event.getTestClass().getJavaClass().getName();
    }

    static String getMethodName(TestLifecycleEvent event) {
        if (event.getTestMethod() == null) {
            throw new IllegalArgumentException("TestLifecycleEvent does not have a valid method name");
        }
        return event.getTestMethod().getName();
    }

    static String trimName(String packageName, String className, String methodName) {
        StringBuilder sb = new StringBuilder();
        String trimmedPackage = TestListener.trimPackage(packageName);
        if (Strings.isNotNullOrEmpty((String)packageName)) {
            sb.append(trimmedPackage).append(".");
        }
        sb.append(className).append(".").append(methodName);
        String result = sb.toString();
        int prefixLength = "fabric8.io/test-status-%s".length() - 1;
        if (prefixLength + result.length() > 63) {
            result = result.substring(prefixLength + result.length() - 63);
        }
        if (result.charAt(0) == '.') {
            result = result.substring(1);
        }
        return result;
    }

    static String trimPackage(String pkg) {
        if (Strings.isNullOrEmpty((String)pkg)) {
            return pkg;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String part : pkg.split("\\.")) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(part.substring(0, 1));
        }
        return sb.toString();
    }

    public void start(@Observes(precedence=-2147483648) Before event) {
        Session session = (Session)this.session.get();
        NamespaceService namespaceService = (NamespaceService)this.namespaceService.get();
        String pkg = TestListener.getPackage((TestLifecycleEvent)event);
        String className = TestListener.getClassName((TestLifecycleEvent)event);
        String methodName = TestListener.getMethodName((TestLifecycleEvent)event);
        session.setCurrentMethodName(methodName);
        HashMap<String, String> annotations = new HashMap<String, String>();
        String testCase = TestListener.trimName(pkg, className, methodName);
        annotations.put(String.format("fabric8.io/test-status-%s", testCase), "RUNNING");
        try {
            namespaceService.annotate(session.getNamespace(), annotations);
        }
        catch (Throwable t) {
            session.getLogger().warn("Could not annotate namespace:[" + session.getNamespace() + "] with test: [" + className + "] method: [" + methodName + "] state:[" + "RUNNING" + "]");
        }
    }

    public void stop(@Observes(precedence=-2147483648) After event, TestResult result) {
        Session session = (Session)this.session.get();
        NamespaceService namespaceService = (NamespaceService)this.namespaceService.get();
        String pkg = TestListener.getPackage((TestLifecycleEvent)event);
        String className = TestListener.getClassName((TestLifecycleEvent)event);
        String methodName = TestListener.getMethodName((TestLifecycleEvent)event);
        session.setCurrentMethodName(null);
        HashMap<String, String> annotations = new HashMap<String, String>();
        String testCase = TestListener.trimName(pkg, className, methodName);
        annotations.put(String.format("fabric8.io/test-status-%s", testCase), result.getStatus().name());
        try {
            namespaceService.annotate(session.getNamespace(), annotations);
        }
        catch (Throwable t) {
            session.getLogger().warn("Could not annotate namespace:[" + session.getNamespace() + "] with test: [" + className + "] method: [" + methodName + "] result:[" + result.getStatus().name() + "]");
        }
        switch (result.getStatus()) {
            case PASSED: {
                session.getPassed().incrementAndGet();
                break;
            }
            case FAILED: {
                session.getFailed().incrementAndGet();
                break;
            }
            case SKIPPED: {
                session.getSkipped().incrementAndGet();
            }
        }
    }
}

