/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.enricher.internal;

import io.fabric8.kubernetes.api.model.v4_0.Pod;
import io.fabric8.kubernetes.api.model.v4_0.PodList;
import io.fabric8.kubernetes.clnt.v4_0.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v4_0.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_0.dsl.PodResource;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.kubernetes.impl.enricher.AbstractKubernetesResourceProvider;
import org.jboss.arquillian.test.api.ArquillianResource;

public class PodResourceProvider
extends AbstractKubernetesResourceProvider {
    public boolean canProvide(Class<?> type) {
        return Pod.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        String name = this.getName(qualifiers);
        String namespace = this.getNamespace(qualifiers);
        if (name != null) {
            return ((PodResource)((NonNamespaceOperation)this.getClient().pods().inNamespace(namespace)).withName(name)).get();
        }
        Map<String, String> labels = this.getLabels(qualifiers);
        PodList list = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getClient().pods().inNamespace(namespace)).withLabels(labels)).list();
        List pods = list.getItems();
        if (!pods.isEmpty()) {
            return pods.get(0);
        }
        return null;
    }
}

