package org.arquillian.cube.kubernetes.impl;

import io.sundr.builder.VisitableBuilder;
public class DefaultConfigurationBuilder extends DefaultConfigurationFluent<DefaultConfigurationBuilder> implements VisitableBuilder<DefaultConfiguration,DefaultConfigurationBuilder>{
  public DefaultConfigurationBuilder() {
    this.fluent = this;
  }
  
  public DefaultConfigurationBuilder(DefaultConfigurationFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public DefaultConfigurationBuilder(DefaultConfigurationFluent<?> fluent,DefaultConfiguration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DefaultConfigurationBuilder(DefaultConfiguration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DefaultConfigurationFluent<?> fluent;
  
  public DefaultConfiguration build() {
    DefaultConfiguration buildable = new DefaultConfiguration(fluent.getSessionId(),fluent.getMasterUrl(),fluent.getNamespace(),fluent.getScriptEnvironmentVariables(),fluent.getEnvironmentSetupScriptUrl(),fluent.getEnvironmentTeardownScriptUrl(),fluent.getEnvironmentConfigUrl(),fluent.getEnvironmentDependencies(),fluent.isNamespaceUseCurrentEnabled(),fluent.isNamespaceLazyCreateEnabled(),fluent.isNamespaceCleanupEnabled(),fluent.getNamespaceCleanupTimeout(),fluent.isNamespaceCleanupConfirmationEnabled(),fluent.isNamespaceDestroyEnabled(),fluent.isNamespaceDestroyConfirmationEnabled(),fluent.getNamespaceDestroyTimeout(),fluent.isWaitEnabled(),fluent.getWaitTimeout(),fluent.getWaitPollInterval(),fluent.getWaitForServiceList(),fluent.isAnsiLoggerEnabled(),fluent.isEnvironmentInitEnabled(),fluent.isLogCopyEnabled(),fluent.getLogPath(),fluent.getKubernetesDomain(),fluent.getDockerRegistry(),fluent.getToken(),fluent.getUsername(),fluent.getPassword(),fluent.getApiVersion(),fluent.isTrustCerts(),fluent.isFmpBuildEnabled(),fluent.isFmpBuildForMavenDisable(),fluent.isFmpDebugOutput(),fluent.isFmpLogsEnabled(),fluent.getFmpPomPath(),fluent.getFmpProfiles(),fluent.getFmpSystemProperties(),fluent.getFmpBuildOptions());
    return buildable;
  }
  

}