package org.arquillian.cube.kubernetes.impl;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.sundr.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DefaultConfigurationFluent<A extends DefaultConfigurationFluent<A>> extends BaseFluent<A>{
  public DefaultConfigurationFluent() {
  }
  
  public DefaultConfigurationFluent(DefaultConfiguration instance) {
    this.copyInstance(instance);
  }
  private String sessionId;
  private String namespace;
  private URL masterUrl;
  private Map<String,String> scriptEnvironmentVariables = new LinkedHashMap<String,String>();
  private URL environmentSetupScriptUrl;
  private URL environmentTeardownScriptUrl;
  private URL environmentConfigUrl;
  private List<URL> environmentDependencies = new ArrayList<URL>();
  private boolean namespaceLazyCreateEnabled;
  private boolean namespaceCleanupEnabled;
  private long namespaceCleanupTimeout;
  private boolean namespaceCleanupConfirmationEnabled;
  private boolean namespaceUseCurrentEnabled;
  private boolean namespaceDestroyEnabled;
  private boolean namespaceDestroyConfirmationEnabled;
  private long namespaceDestroyTimeout;
  private boolean waitEnabled;
  private long waitTimeout;
  private long waitPollInterval;
  private List<String> waitForServiceList = new ArrayList<String>();
  private boolean ansiLoggerEnabled;
  private boolean environmentInitEnabled;
  private boolean logCopyEnabled;
  private String logPath;
  private String kubernetesDomain;
  private String dockerRegistry;
  private String username;
  private String password;
  private String apiVersion;
  private boolean trustCerts;
  private boolean fmpBuildEnabled;
  private boolean fmpBuildForMavenDisable;
  private boolean fmpDebugOutput;
  private boolean fmpLogsEnabled;
  private String fmpPomPath;
  private List<String> fmpProfiles = new ArrayList<String>();
  private List<String> fmpSystemProperties = new ArrayList<String>();
  private String fmpBuildOptions;
  private String token;
  
  protected void copyInstance(DefaultConfiguration instance) {
    if (instance != null) {
          this.withSessionId(instance.getSessionId());
          this.withMasterUrl(instance.getMasterUrl());
          this.withNamespace(instance.getNamespace());
          this.withScriptEnvironmentVariables(instance.getScriptEnvironmentVariables());
          this.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl());
          this.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl());
          this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl());
          this.withEnvironmentDependencies(instance.getEnvironmentDependencies());
          this.withNamespaceUseCurrentEnabled(instance.isNamespaceUseCurrentEnabled());
          this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled());
          this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled());
          this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout());
          this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled());
          this.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled());
          this.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled());
          this.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout());
          this.withWaitEnabled(instance.isWaitEnabled());
          this.withWaitTimeout(instance.getWaitTimeout());
          this.withWaitPollInterval(instance.getWaitPollInterval());
          this.withWaitForServiceList(instance.getWaitForServiceList());
          this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled());
          this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled());
          this.withLogCopyEnabled(instance.isLogCopyEnabled());
          this.withLogPath(instance.getLogPath());
          this.withKubernetesDomain(instance.getKubernetesDomain());
          this.withDockerRegistry(instance.getDockerRegistry());
          this.withToken(instance.getToken());
          this.withUsername(instance.getUsername());
          this.withPassword(instance.getPassword());
          this.withApiVersion(instance.getApiVersion());
          this.withTrustCerts(instance.isTrustCerts());
          this.withFmpBuildEnabled(instance.isFmpBuildEnabled());
          this.withFmpBuildForMavenDisable(instance.isFmpBuildForMavenDisable());
          this.withFmpDebugOutput(instance.isFmpDebugOutput());
          this.withFmpLogsEnabled(instance.isFmpLogsEnabled());
          this.withFmpPomPath(instance.getFmpPomPath());
          this.withFmpProfiles(instance.getFmpProfiles());
          this.withFmpSystemProperties(instance.getFmpSystemProperties());
          this.withFmpBuildOptions(instance.getFmpBuildOptions());
        }
  }
  
  public String getSessionId() {
    return this.sessionId;
  }
  
  public A withSessionId(String sessionId) {
    this.sessionId = sessionId;
    return (A) this;
  }
  
  public boolean hasSessionId() {
    return this.sessionId != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace = namespace;
    return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public URL getMasterUrl() {
    return this.masterUrl;
  }
  
  public A withMasterUrl(URL masterUrl) {
    this.masterUrl = masterUrl;
    return (A) this;
  }
  
  public boolean hasMasterUrl() {
    return this.masterUrl != null;
  }
  
  public A addToScriptEnvironmentVariables(String key,String value) {
    if(this.scriptEnvironmentVariables == null && key != null && value != null) { this.scriptEnvironmentVariables = new LinkedHashMap(); }
    if(key != null && value != null) {this.scriptEnvironmentVariables.put(key, value);} return (A)this;
  }
  
  public A addToScriptEnvironmentVariables(Map<String,String> map) {
    if(this.scriptEnvironmentVariables == null && map != null) { this.scriptEnvironmentVariables = new LinkedHashMap(); }
    if(map != null) { this.scriptEnvironmentVariables.putAll(map);} return (A)this;
  }
  
  public A removeFromScriptEnvironmentVariables(String key) {
    if(this.scriptEnvironmentVariables == null) { return (A) this; }
    if(key != null && this.scriptEnvironmentVariables != null) {this.scriptEnvironmentVariables.remove(key);} return (A)this;
  }
  
  public A removeFromScriptEnvironmentVariables(Map<String,String> map) {
    if(this.scriptEnvironmentVariables == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.scriptEnvironmentVariables != null){this.scriptEnvironmentVariables.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getScriptEnvironmentVariables() {
    return this.scriptEnvironmentVariables;
  }
  
  public <K,V>A withScriptEnvironmentVariables(Map<String,String> scriptEnvironmentVariables) {
    if (scriptEnvironmentVariables == null) {
      this.scriptEnvironmentVariables = null;
    } else {
      this.scriptEnvironmentVariables = new LinkedHashMap(scriptEnvironmentVariables);
    }
    return (A) this;
  }
  
  public boolean hasScriptEnvironmentVariables() {
    return this.scriptEnvironmentVariables != null;
  }
  
  public URL getEnvironmentSetupScriptUrl() {
    return this.environmentSetupScriptUrl;
  }
  
  public A withEnvironmentSetupScriptUrl(URL environmentSetupScriptUrl) {
    this.environmentSetupScriptUrl = environmentSetupScriptUrl;
    return (A) this;
  }
  
  public boolean hasEnvironmentSetupScriptUrl() {
    return this.environmentSetupScriptUrl != null;
  }
  
  public URL getEnvironmentTeardownScriptUrl() {
    return this.environmentTeardownScriptUrl;
  }
  
  public A withEnvironmentTeardownScriptUrl(URL environmentTeardownScriptUrl) {
    this.environmentTeardownScriptUrl = environmentTeardownScriptUrl;
    return (A) this;
  }
  
  public boolean hasEnvironmentTeardownScriptUrl() {
    return this.environmentTeardownScriptUrl != null;
  }
  
  public URL getEnvironmentConfigUrl() {
    return this.environmentConfigUrl;
  }
  
  public A withEnvironmentConfigUrl(URL environmentConfigUrl) {
    this.environmentConfigUrl = environmentConfigUrl;
    return (A) this;
  }
  
  public boolean hasEnvironmentConfigUrl() {
    return this.environmentConfigUrl != null;
  }
  
  public A addToEnvironmentDependencies(int index,URL item) {
    if (this.environmentDependencies == null) {this.environmentDependencies = new ArrayList<URL>();}
    this.environmentDependencies.add(index, item);
    return (A)this;
  }
  
  public A setToEnvironmentDependencies(int index,URL item) {
    if (this.environmentDependencies == null) {this.environmentDependencies = new ArrayList<URL>();}
    this.environmentDependencies.set(index, item); return (A)this;
  }
  
  public A addToEnvironmentDependencies(java.net.URL... items) {
    if (this.environmentDependencies == null) {this.environmentDependencies = new ArrayList<URL>();}
    for (URL item : items) {this.environmentDependencies.add(item);} return (A)this;
  }
  
  public A addAllToEnvironmentDependencies(Collection<URL> items) {
    if (this.environmentDependencies == null) {this.environmentDependencies = new ArrayList<URL>();}
    for (URL item : items) {this.environmentDependencies.add(item);} return (A)this;
  }
  
  public A removeFromEnvironmentDependencies(java.net.URL... items) {
    if (this.environmentDependencies == null) return (A)this;
    for (URL item : items) { this.environmentDependencies.remove(item);} return (A)this;
  }
  
  public A removeAllFromEnvironmentDependencies(Collection<URL> items) {
    if (this.environmentDependencies == null) return (A)this;
    for (URL item : items) { this.environmentDependencies.remove(item);} return (A)this;
  }
  
  public List<URL> getEnvironmentDependencies() {
    return this.environmentDependencies;
  }
  
  public URL getEnvironmentDependency(int index) {
    return this.environmentDependencies.get(index);
  }
  
  public URL getFirstEnvironmentDependency() {
    return this.environmentDependencies.get(0);
  }
  
  public URL getLastEnvironmentDependency() {
    return this.environmentDependencies.get(environmentDependencies.size() - 1);
  }
  
  public URL getMatchingEnvironmentDependency(Predicate<URL> predicate) {
      for (URL item : environmentDependencies) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnvironmentDependency(Predicate<URL> predicate) {
      for (URL item : environmentDependencies) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEnvironmentDependencies(List<URL> environmentDependencies) {
    if (environmentDependencies != null) {
        this.environmentDependencies = new ArrayList();
        for (URL item : environmentDependencies) {
          this.addToEnvironmentDependencies(item);
        }
    } else {
      this.environmentDependencies = null;
    }
    return (A) this;
  }
  
  public A withEnvironmentDependencies(java.net.URL... environmentDependencies) {
    if (this.environmentDependencies != null) {
        this.environmentDependencies.clear();
        _visitables.remove("environmentDependencies");
    }
    if (environmentDependencies != null) {
      for (URL item : environmentDependencies) {
        this.addToEnvironmentDependencies(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEnvironmentDependencies() {
    return this.environmentDependencies != null && !this.environmentDependencies.isEmpty();
  }
  
  public boolean isNamespaceLazyCreateEnabled() {
    return this.namespaceLazyCreateEnabled;
  }
  
  public A withNamespaceLazyCreateEnabled(boolean namespaceLazyCreateEnabled) {
    this.namespaceLazyCreateEnabled = namespaceLazyCreateEnabled;
    return (A) this;
  }
  
  public boolean hasNamespaceLazyCreateEnabled() {
    return true;
  }
  
  public boolean isNamespaceCleanupEnabled() {
    return this.namespaceCleanupEnabled;
  }
  
  public A withNamespaceCleanupEnabled(boolean namespaceCleanupEnabled) {
    this.namespaceCleanupEnabled = namespaceCleanupEnabled;
    return (A) this;
  }
  
  public boolean hasNamespaceCleanupEnabled() {
    return true;
  }
  
  public long getNamespaceCleanupTimeout() {
    return this.namespaceCleanupTimeout;
  }
  
  public A withNamespaceCleanupTimeout(long namespaceCleanupTimeout) {
    this.namespaceCleanupTimeout = namespaceCleanupTimeout;
    return (A) this;
  }
  
  public boolean hasNamespaceCleanupTimeout() {
    return true;
  }
  
  public boolean isNamespaceCleanupConfirmationEnabled() {
    return this.namespaceCleanupConfirmationEnabled;
  }
  
  public A withNamespaceCleanupConfirmationEnabled(boolean namespaceCleanupConfirmationEnabled) {
    this.namespaceCleanupConfirmationEnabled = namespaceCleanupConfirmationEnabled;
    return (A) this;
  }
  
  public boolean hasNamespaceCleanupConfirmationEnabled() {
    return true;
  }
  
  public boolean isNamespaceUseCurrentEnabled() {
    return this.namespaceUseCurrentEnabled;
  }
  
  public A withNamespaceUseCurrentEnabled(boolean namespaceUseCurrentEnabled) {
    this.namespaceUseCurrentEnabled = namespaceUseCurrentEnabled;
    return (A) this;
  }
  
  public boolean hasNamespaceUseCurrentEnabled() {
    return true;
  }
  
  public boolean isNamespaceDestroyEnabled() {
    return this.namespaceDestroyEnabled;
  }
  
  public A withNamespaceDestroyEnabled(boolean namespaceDestroyEnabled) {
    this.namespaceDestroyEnabled = namespaceDestroyEnabled;
    return (A) this;
  }
  
  public boolean hasNamespaceDestroyEnabled() {
    return true;
  }
  
  public boolean isNamespaceDestroyConfirmationEnabled() {
    return this.namespaceDestroyConfirmationEnabled;
  }
  
  public A withNamespaceDestroyConfirmationEnabled(boolean namespaceDestroyConfirmationEnabled) {
    this.namespaceDestroyConfirmationEnabled = namespaceDestroyConfirmationEnabled;
    return (A) this;
  }
  
  public boolean hasNamespaceDestroyConfirmationEnabled() {
    return true;
  }
  
  public long getNamespaceDestroyTimeout() {
    return this.namespaceDestroyTimeout;
  }
  
  public A withNamespaceDestroyTimeout(long namespaceDestroyTimeout) {
    this.namespaceDestroyTimeout = namespaceDestroyTimeout;
    return (A) this;
  }
  
  public boolean hasNamespaceDestroyTimeout() {
    return true;
  }
  
  public boolean isWaitEnabled() {
    return this.waitEnabled;
  }
  
  public A withWaitEnabled(boolean waitEnabled) {
    this.waitEnabled = waitEnabled;
    return (A) this;
  }
  
  public boolean hasWaitEnabled() {
    return true;
  }
  
  public long getWaitTimeout() {
    return this.waitTimeout;
  }
  
  public A withWaitTimeout(long waitTimeout) {
    this.waitTimeout = waitTimeout;
    return (A) this;
  }
  
  public boolean hasWaitTimeout() {
    return true;
  }
  
  public long getWaitPollInterval() {
    return this.waitPollInterval;
  }
  
  public A withWaitPollInterval(long waitPollInterval) {
    this.waitPollInterval = waitPollInterval;
    return (A) this;
  }
  
  public boolean hasWaitPollInterval() {
    return true;
  }
  
  public A addToWaitForServiceList(int index,String item) {
    if (this.waitForServiceList == null) {this.waitForServiceList = new ArrayList<String>();}
    this.waitForServiceList.add(index, item);
    return (A)this;
  }
  
  public A setToWaitForServiceList(int index,String item) {
    if (this.waitForServiceList == null) {this.waitForServiceList = new ArrayList<String>();}
    this.waitForServiceList.set(index, item); return (A)this;
  }
  
  public A addToWaitForServiceList(java.lang.String... items) {
    if (this.waitForServiceList == null) {this.waitForServiceList = new ArrayList<String>();}
    for (String item : items) {this.waitForServiceList.add(item);} return (A)this;
  }
  
  public A addAllToWaitForServiceList(Collection<String> items) {
    if (this.waitForServiceList == null) {this.waitForServiceList = new ArrayList<String>();}
    for (String item : items) {this.waitForServiceList.add(item);} return (A)this;
  }
  
  public A removeFromWaitForServiceList(java.lang.String... items) {
    if (this.waitForServiceList == null) return (A)this;
    for (String item : items) { this.waitForServiceList.remove(item);} return (A)this;
  }
  
  public A removeAllFromWaitForServiceList(Collection<String> items) {
    if (this.waitForServiceList == null) return (A)this;
    for (String item : items) { this.waitForServiceList.remove(item);} return (A)this;
  }
  
  public List<String> getWaitForServiceList() {
    return this.waitForServiceList;
  }
  
  public String getWaitForServiceList(int index) {
    return this.waitForServiceList.get(index);
  }
  
  public String getFirstWaitForServiceList() {
    return this.waitForServiceList.get(0);
  }
  
  public String getLastWaitForServiceList() {
    return this.waitForServiceList.get(waitForServiceList.size() - 1);
  }
  
  public String getMatchingWaitForServiceList(Predicate<String> predicate) {
      for (String item : waitForServiceList) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingWaitForServiceList(Predicate<String> predicate) {
      for (String item : waitForServiceList) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWaitForServiceList(List<String> waitForServiceList) {
    if (waitForServiceList != null) {
        this.waitForServiceList = new ArrayList();
        for (String item : waitForServiceList) {
          this.addToWaitForServiceList(item);
        }
    } else {
      this.waitForServiceList = null;
    }
    return (A) this;
  }
  
  public A withWaitForServiceList(java.lang.String... waitForServiceList) {
    if (this.waitForServiceList != null) {
        this.waitForServiceList.clear();
        _visitables.remove("waitForServiceList");
    }
    if (waitForServiceList != null) {
      for (String item : waitForServiceList) {
        this.addToWaitForServiceList(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasWaitForServiceList() {
    return this.waitForServiceList != null && !this.waitForServiceList.isEmpty();
  }
  
  public boolean isAnsiLoggerEnabled() {
    return this.ansiLoggerEnabled;
  }
  
  public A withAnsiLoggerEnabled(boolean ansiLoggerEnabled) {
    this.ansiLoggerEnabled = ansiLoggerEnabled;
    return (A) this;
  }
  
  public boolean hasAnsiLoggerEnabled() {
    return true;
  }
  
  public boolean isEnvironmentInitEnabled() {
    return this.environmentInitEnabled;
  }
  
  public A withEnvironmentInitEnabled(boolean environmentInitEnabled) {
    this.environmentInitEnabled = environmentInitEnabled;
    return (A) this;
  }
  
  public boolean hasEnvironmentInitEnabled() {
    return true;
  }
  
  public boolean isLogCopyEnabled() {
    return this.logCopyEnabled;
  }
  
  public A withLogCopyEnabled(boolean logCopyEnabled) {
    this.logCopyEnabled = logCopyEnabled;
    return (A) this;
  }
  
  public boolean hasLogCopyEnabled() {
    return true;
  }
  
  public String getLogPath() {
    return this.logPath;
  }
  
  public A withLogPath(String logPath) {
    this.logPath = logPath;
    return (A) this;
  }
  
  public boolean hasLogPath() {
    return this.logPath != null;
  }
  
  public String getKubernetesDomain() {
    return this.kubernetesDomain;
  }
  
  public A withKubernetesDomain(String kubernetesDomain) {
    this.kubernetesDomain = kubernetesDomain;
    return (A) this;
  }
  
  public boolean hasKubernetesDomain() {
    return this.kubernetesDomain != null;
  }
  
  public String getDockerRegistry() {
    return this.dockerRegistry;
  }
  
  public A withDockerRegistry(String dockerRegistry) {
    this.dockerRegistry = dockerRegistry;
    return (A) this;
  }
  
  public boolean hasDockerRegistry() {
    return this.dockerRegistry != null;
  }
  
  public String getUsername() {
    return this.username;
  }
  
  public A withUsername(String username) {
    this.username = username;
    return (A) this;
  }
  
  public boolean hasUsername() {
    return this.username != null;
  }
  
  public String getPassword() {
    return this.password;
  }
  
  public A withPassword(String password) {
    this.password = password;
    return (A) this;
  }
  
  public boolean hasPassword() {
    return this.password != null;
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public boolean isTrustCerts() {
    return this.trustCerts;
  }
  
  public A withTrustCerts(boolean trustCerts) {
    this.trustCerts = trustCerts;
    return (A) this;
  }
  
  public boolean hasTrustCerts() {
    return true;
  }
  
  public boolean isFmpBuildEnabled() {
    return this.fmpBuildEnabled;
  }
  
  public A withFmpBuildEnabled(boolean fmpBuildEnabled) {
    this.fmpBuildEnabled = fmpBuildEnabled;
    return (A) this;
  }
  
  public boolean hasFmpBuildEnabled() {
    return true;
  }
  
  public boolean isFmpBuildForMavenDisable() {
    return this.fmpBuildForMavenDisable;
  }
  
  public A withFmpBuildForMavenDisable(boolean fmpBuildForMavenDisable) {
    this.fmpBuildForMavenDisable = fmpBuildForMavenDisable;
    return (A) this;
  }
  
  public boolean hasFmpBuildForMavenDisable() {
    return true;
  }
  
  public boolean isFmpDebugOutput() {
    return this.fmpDebugOutput;
  }
  
  public A withFmpDebugOutput(boolean fmpDebugOutput) {
    this.fmpDebugOutput = fmpDebugOutput;
    return (A) this;
  }
  
  public boolean hasFmpDebugOutput() {
    return true;
  }
  
  public boolean isFmpLogsEnabled() {
    return this.fmpLogsEnabled;
  }
  
  public A withFmpLogsEnabled(boolean fmpLogsEnabled) {
    this.fmpLogsEnabled = fmpLogsEnabled;
    return (A) this;
  }
  
  public boolean hasFmpLogsEnabled() {
    return true;
  }
  
  public String getFmpPomPath() {
    return this.fmpPomPath;
  }
  
  public A withFmpPomPath(String fmpPomPath) {
    this.fmpPomPath = fmpPomPath;
    return (A) this;
  }
  
  public boolean hasFmpPomPath() {
    return this.fmpPomPath != null;
  }
  
  public A addToFmpProfiles(int index,String item) {
    if (this.fmpProfiles == null) {this.fmpProfiles = new ArrayList<String>();}
    this.fmpProfiles.add(index, item);
    return (A)this;
  }
  
  public A setToFmpProfiles(int index,String item) {
    if (this.fmpProfiles == null) {this.fmpProfiles = new ArrayList<String>();}
    this.fmpProfiles.set(index, item); return (A)this;
  }
  
  public A addToFmpProfiles(java.lang.String... items) {
    if (this.fmpProfiles == null) {this.fmpProfiles = new ArrayList<String>();}
    for (String item : items) {this.fmpProfiles.add(item);} return (A)this;
  }
  
  public A addAllToFmpProfiles(Collection<String> items) {
    if (this.fmpProfiles == null) {this.fmpProfiles = new ArrayList<String>();}
    for (String item : items) {this.fmpProfiles.add(item);} return (A)this;
  }
  
  public A removeFromFmpProfiles(java.lang.String... items) {
    if (this.fmpProfiles == null) return (A)this;
    for (String item : items) { this.fmpProfiles.remove(item);} return (A)this;
  }
  
  public A removeAllFromFmpProfiles(Collection<String> items) {
    if (this.fmpProfiles == null) return (A)this;
    for (String item : items) { this.fmpProfiles.remove(item);} return (A)this;
  }
  
  public List<String> getFmpProfiles() {
    return this.fmpProfiles;
  }
  
  public String getFmpProfile(int index) {
    return this.fmpProfiles.get(index);
  }
  
  public String getFirstFmpProfile() {
    return this.fmpProfiles.get(0);
  }
  
  public String getLastFmpProfile() {
    return this.fmpProfiles.get(fmpProfiles.size() - 1);
  }
  
  public String getMatchingFmpProfile(Predicate<String> predicate) {
      for (String item : fmpProfiles) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingFmpProfile(Predicate<String> predicate) {
      for (String item : fmpProfiles) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFmpProfiles(List<String> fmpProfiles) {
    if (fmpProfiles != null) {
        this.fmpProfiles = new ArrayList();
        for (String item : fmpProfiles) {
          this.addToFmpProfiles(item);
        }
    } else {
      this.fmpProfiles = null;
    }
    return (A) this;
  }
  
  public A withFmpProfiles(java.lang.String... fmpProfiles) {
    if (this.fmpProfiles != null) {
        this.fmpProfiles.clear();
        _visitables.remove("fmpProfiles");
    }
    if (fmpProfiles != null) {
      for (String item : fmpProfiles) {
        this.addToFmpProfiles(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFmpProfiles() {
    return this.fmpProfiles != null && !this.fmpProfiles.isEmpty();
  }
  
  public A addToFmpSystemProperties(int index,String item) {
    if (this.fmpSystemProperties == null) {this.fmpSystemProperties = new ArrayList<String>();}
    this.fmpSystemProperties.add(index, item);
    return (A)this;
  }
  
  public A setToFmpSystemProperties(int index,String item) {
    if (this.fmpSystemProperties == null) {this.fmpSystemProperties = new ArrayList<String>();}
    this.fmpSystemProperties.set(index, item); return (A)this;
  }
  
  public A addToFmpSystemProperties(java.lang.String... items) {
    if (this.fmpSystemProperties == null) {this.fmpSystemProperties = new ArrayList<String>();}
    for (String item : items) {this.fmpSystemProperties.add(item);} return (A)this;
  }
  
  public A addAllToFmpSystemProperties(Collection<String> items) {
    if (this.fmpSystemProperties == null) {this.fmpSystemProperties = new ArrayList<String>();}
    for (String item : items) {this.fmpSystemProperties.add(item);} return (A)this;
  }
  
  public A removeFromFmpSystemProperties(java.lang.String... items) {
    if (this.fmpSystemProperties == null) return (A)this;
    for (String item : items) { this.fmpSystemProperties.remove(item);} return (A)this;
  }
  
  public A removeAllFromFmpSystemProperties(Collection<String> items) {
    if (this.fmpSystemProperties == null) return (A)this;
    for (String item : items) { this.fmpSystemProperties.remove(item);} return (A)this;
  }
  
  public List<String> getFmpSystemProperties() {
    return this.fmpSystemProperties;
  }
  
  public String getFmpSystemProperty(int index) {
    return this.fmpSystemProperties.get(index);
  }
  
  public String getFirstFmpSystemProperty() {
    return this.fmpSystemProperties.get(0);
  }
  
  public String getLastFmpSystemProperty() {
    return this.fmpSystemProperties.get(fmpSystemProperties.size() - 1);
  }
  
  public String getMatchingFmpSystemProperty(Predicate<String> predicate) {
      for (String item : fmpSystemProperties) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingFmpSystemProperty(Predicate<String> predicate) {
      for (String item : fmpSystemProperties) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFmpSystemProperties(List<String> fmpSystemProperties) {
    if (fmpSystemProperties != null) {
        this.fmpSystemProperties = new ArrayList();
        for (String item : fmpSystemProperties) {
          this.addToFmpSystemProperties(item);
        }
    } else {
      this.fmpSystemProperties = null;
    }
    return (A) this;
  }
  
  public A withFmpSystemProperties(java.lang.String... fmpSystemProperties) {
    if (this.fmpSystemProperties != null) {
        this.fmpSystemProperties.clear();
        _visitables.remove("fmpSystemProperties");
    }
    if (fmpSystemProperties != null) {
      for (String item : fmpSystemProperties) {
        this.addToFmpSystemProperties(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFmpSystemProperties() {
    return this.fmpSystemProperties != null && !this.fmpSystemProperties.isEmpty();
  }
  
  public String getFmpBuildOptions() {
    return this.fmpBuildOptions;
  }
  
  public A withFmpBuildOptions(String fmpBuildOptions) {
    this.fmpBuildOptions = fmpBuildOptions;
    return (A) this;
  }
  
  public boolean hasFmpBuildOptions() {
    return this.fmpBuildOptions != null;
  }
  
  public String getToken() {
    return this.token;
  }
  
  public A withToken(String token) {
    this.token = token;
    return (A) this;
  }
  
  public boolean hasToken() {
    return this.token != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DefaultConfigurationFluent that = (DefaultConfigurationFluent) o;
    if (!java.util.Objects.equals(sessionId, that.sessionId)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(masterUrl, that.masterUrl)) return false;
    if (!java.util.Objects.equals(scriptEnvironmentVariables, that.scriptEnvironmentVariables)) return false;
    if (!java.util.Objects.equals(environmentSetupScriptUrl, that.environmentSetupScriptUrl)) return false;
    if (!java.util.Objects.equals(environmentTeardownScriptUrl, that.environmentTeardownScriptUrl)) return false;
    if (!java.util.Objects.equals(environmentConfigUrl, that.environmentConfigUrl)) return false;
    if (!java.util.Objects.equals(environmentDependencies, that.environmentDependencies)) return false;
    if (namespaceLazyCreateEnabled != that.namespaceLazyCreateEnabled) return false;
    if (namespaceCleanupEnabled != that.namespaceCleanupEnabled) return false;
    if (namespaceCleanupTimeout != that.namespaceCleanupTimeout) return false;
    if (namespaceCleanupConfirmationEnabled != that.namespaceCleanupConfirmationEnabled) return false;
    if (namespaceUseCurrentEnabled != that.namespaceUseCurrentEnabled) return false;
    if (namespaceDestroyEnabled != that.namespaceDestroyEnabled) return false;
    if (namespaceDestroyConfirmationEnabled != that.namespaceDestroyConfirmationEnabled) return false;
    if (namespaceDestroyTimeout != that.namespaceDestroyTimeout) return false;
    if (waitEnabled != that.waitEnabled) return false;
    if (waitTimeout != that.waitTimeout) return false;
    if (waitPollInterval != that.waitPollInterval) return false;
    if (!java.util.Objects.equals(waitForServiceList, that.waitForServiceList)) return false;
    if (ansiLoggerEnabled != that.ansiLoggerEnabled) return false;
    if (environmentInitEnabled != that.environmentInitEnabled) return false;
    if (logCopyEnabled != that.logCopyEnabled) return false;
    if (!java.util.Objects.equals(logPath, that.logPath)) return false;
    if (!java.util.Objects.equals(kubernetesDomain, that.kubernetesDomain)) return false;
    if (!java.util.Objects.equals(dockerRegistry, that.dockerRegistry)) return false;
    if (!java.util.Objects.equals(username, that.username)) return false;
    if (!java.util.Objects.equals(password, that.password)) return false;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (trustCerts != that.trustCerts) return false;
    if (fmpBuildEnabled != that.fmpBuildEnabled) return false;
    if (fmpBuildForMavenDisable != that.fmpBuildForMavenDisable) return false;
    if (fmpDebugOutput != that.fmpDebugOutput) return false;
    if (fmpLogsEnabled != that.fmpLogsEnabled) return false;
    if (!java.util.Objects.equals(fmpPomPath, that.fmpPomPath)) return false;
    if (!java.util.Objects.equals(fmpProfiles, that.fmpProfiles)) return false;
    if (!java.util.Objects.equals(fmpSystemProperties, that.fmpSystemProperties)) return false;
    if (!java.util.Objects.equals(fmpBuildOptions, that.fmpBuildOptions)) return false;
    if (!java.util.Objects.equals(token, that.token)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(sessionId,  namespace,  masterUrl,  scriptEnvironmentVariables,  environmentSetupScriptUrl,  environmentTeardownScriptUrl,  environmentConfigUrl,  environmentDependencies,  namespaceLazyCreateEnabled,  namespaceCleanupEnabled,  namespaceCleanupTimeout,  namespaceCleanupConfirmationEnabled,  namespaceUseCurrentEnabled,  namespaceDestroyEnabled,  namespaceDestroyConfirmationEnabled,  namespaceDestroyTimeout,  waitEnabled,  waitTimeout,  waitPollInterval,  waitForServiceList,  ansiLoggerEnabled,  environmentInitEnabled,  logCopyEnabled,  logPath,  kubernetesDomain,  dockerRegistry,  username,  password,  apiVersion,  trustCerts,  fmpBuildEnabled,  fmpBuildForMavenDisable,  fmpDebugOutput,  fmpLogsEnabled,  fmpPomPath,  fmpProfiles,  fmpSystemProperties,  fmpBuildOptions,  token,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sessionId != null) { sb.append("sessionId:"); sb.append(sessionId + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (masterUrl != null) { sb.append("masterUrl:"); sb.append(masterUrl + ","); }
    if (scriptEnvironmentVariables != null && !scriptEnvironmentVariables.isEmpty()) { sb.append("scriptEnvironmentVariables:"); sb.append(scriptEnvironmentVariables + ","); }
    if (environmentSetupScriptUrl != null) { sb.append("environmentSetupScriptUrl:"); sb.append(environmentSetupScriptUrl + ","); }
    if (environmentTeardownScriptUrl != null) { sb.append("environmentTeardownScriptUrl:"); sb.append(environmentTeardownScriptUrl + ","); }
    if (environmentConfigUrl != null) { sb.append("environmentConfigUrl:"); sb.append(environmentConfigUrl + ","); }
    if (environmentDependencies != null && !environmentDependencies.isEmpty()) { sb.append("environmentDependencies:"); sb.append(environmentDependencies + ","); }
    sb.append("namespaceLazyCreateEnabled:"); sb.append(namespaceLazyCreateEnabled + ",");
    sb.append("namespaceCleanupEnabled:"); sb.append(namespaceCleanupEnabled + ",");
    sb.append("namespaceCleanupTimeout:"); sb.append(namespaceCleanupTimeout + ",");
    sb.append("namespaceCleanupConfirmationEnabled:"); sb.append(namespaceCleanupConfirmationEnabled + ",");
    sb.append("namespaceUseCurrentEnabled:"); sb.append(namespaceUseCurrentEnabled + ",");
    sb.append("namespaceDestroyEnabled:"); sb.append(namespaceDestroyEnabled + ",");
    sb.append("namespaceDestroyConfirmationEnabled:"); sb.append(namespaceDestroyConfirmationEnabled + ",");
    sb.append("namespaceDestroyTimeout:"); sb.append(namespaceDestroyTimeout + ",");
    sb.append("waitEnabled:"); sb.append(waitEnabled + ",");
    sb.append("waitTimeout:"); sb.append(waitTimeout + ",");
    sb.append("waitPollInterval:"); sb.append(waitPollInterval + ",");
    if (waitForServiceList != null && !waitForServiceList.isEmpty()) { sb.append("waitForServiceList:"); sb.append(waitForServiceList + ","); }
    sb.append("ansiLoggerEnabled:"); sb.append(ansiLoggerEnabled + ",");
    sb.append("environmentInitEnabled:"); sb.append(environmentInitEnabled + ",");
    sb.append("logCopyEnabled:"); sb.append(logCopyEnabled + ",");
    if (logPath != null) { sb.append("logPath:"); sb.append(logPath + ","); }
    if (kubernetesDomain != null) { sb.append("kubernetesDomain:"); sb.append(kubernetesDomain + ","); }
    if (dockerRegistry != null) { sb.append("dockerRegistry:"); sb.append(dockerRegistry + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (password != null) { sb.append("password:"); sb.append(password + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    sb.append("trustCerts:"); sb.append(trustCerts + ",");
    sb.append("fmpBuildEnabled:"); sb.append(fmpBuildEnabled + ",");
    sb.append("fmpBuildForMavenDisable:"); sb.append(fmpBuildForMavenDisable + ",");
    sb.append("fmpDebugOutput:"); sb.append(fmpDebugOutput + ",");
    sb.append("fmpLogsEnabled:"); sb.append(fmpLogsEnabled + ",");
    if (fmpPomPath != null) { sb.append("fmpPomPath:"); sb.append(fmpPomPath + ","); }
    if (fmpProfiles != null && !fmpProfiles.isEmpty()) { sb.append("fmpProfiles:"); sb.append(fmpProfiles + ","); }
    if (fmpSystemProperties != null && !fmpSystemProperties.isEmpty()) { sb.append("fmpSystemProperties:"); sb.append(fmpSystemProperties + ","); }
    if (fmpBuildOptions != null) { sb.append("fmpBuildOptions:"); sb.append(fmpBuildOptions + ","); }
    if (token != null) { sb.append("token:"); sb.append(token); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withNamespaceLazyCreateEnabled() {
    return withNamespaceLazyCreateEnabled(true);
  }
  
  public A withNamespaceCleanupEnabled() {
    return withNamespaceCleanupEnabled(true);
  }
  
  public A withNamespaceCleanupConfirmationEnabled() {
    return withNamespaceCleanupConfirmationEnabled(true);
  }
  
  public A withNamespaceUseCurrentEnabled() {
    return withNamespaceUseCurrentEnabled(true);
  }
  
  public A withNamespaceDestroyEnabled() {
    return withNamespaceDestroyEnabled(true);
  }
  
  public A withNamespaceDestroyConfirmationEnabled() {
    return withNamespaceDestroyConfirmationEnabled(true);
  }
  
  public A withWaitEnabled() {
    return withWaitEnabled(true);
  }
  
  public A withAnsiLoggerEnabled() {
    return withAnsiLoggerEnabled(true);
  }
  
  public A withEnvironmentInitEnabled() {
    return withEnvironmentInitEnabled(true);
  }
  
  public A withLogCopyEnabled() {
    return withLogCopyEnabled(true);
  }
  
  public A withTrustCerts() {
    return withTrustCerts(true);
  }
  
  public A withFmpBuildEnabled() {
    return withFmpBuildEnabled(true);
  }
  
  public A withFmpBuildForMavenDisable() {
    return withFmpBuildForMavenDisable(true);
  }
  
  public A withFmpDebugOutput() {
    return withFmpDebugOutput(true);
  }
  
  public A withFmpLogsEnabled() {
    return withFmpLogsEnabled(true);
  }
  

}