/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import java.util.Map;
import org.arquillian.cube.kubernetes.impl.DefaultConfiguration;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;

public class DefaultConfigurationTest {
    @Test
    public void shouldParseNullMap() throws Exception {
        Map result = DefaultConfiguration.parseMap(null);
        Assertions.assertThat((Map)result).hasSize(0);
    }

    @Test
    public void shouldParseEmptyMap() throws Exception {
        Map result = DefaultConfiguration.parseMap((String)"");
        Assertions.assertThat((Map)result).hasSize(0);
    }

    @Test
    public void shouldParseJustAKey() throws Exception {
        String s = "KEY1";
        Map result = DefaultConfiguration.parseMap((String)s);
        Assertions.assertThat((Map)result).hasSize(1);
    }

    @Test
    public void shouldParseNormalMap() throws Exception {
        String s = "KEY1=VALUE1\nKEY_TWO=VALUE2\nKEY3=VALUE3\nkey4=VALUE4\nKEY_5=VALUE5";
        Map result = DefaultConfiguration.parseMap((String)s);
        ((MapAssert)Assertions.assertThat((Map)result).hasSize(5)).containsKeys((Object[])new String[]{"KEY3", "key4", "KEY_5"});
    }
}

