/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.arquillian.cube.kubernetes.annotations.Named;
import org.arquillian.cube.kubernetes.impl.requirement.RequiresKubernetes;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={RequiresKubernetes.class})
public class PodInjection {
    @ArquillianResource
    private KubernetesClient client;
    @ArquillianResource
    private PodList podList;
    @Named(value="test-pod")
    @ArquillianResource
    private Pod pod;
    @Named(value="test-pod-second", namespace="test-secondary-namespace")
    @ArquillianResource
    private Pod secondaryPod;

    @Test
    public void testPodListInjection() {
        Assert.assertNotNull((Object)this.podList);
        Assert.assertEquals((long)1L, (long)this.podList.getItems().size());
        Assert.assertEquals((Object)"test-pod", (Object)((Pod)this.podList.getItems().get(0)).getMetadata().getName());
        Assert.assertNotNull((Object)this.pod);
        Assert.assertEquals((Object)"test-pod", (Object)this.pod.getMetadata().getName());
        Assert.assertNotNull((Object)this.secondaryPod);
        Assert.assertEquals((Object)"test-pod-second", (Object)this.secondaryPod.getMetadata().getName());
        Assert.assertEquals((Object)"test-secondary-namespace", (Object)this.secondaryPod.getMetadata().getNamespace());
    }
}

