/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import java.net.Inet4Address;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class PortForwarderTest {
    private final String[] portsToForwardStringBackward = new String[]{"test:1234", "test:9999", "test:9990", "test:8080"};
    private final String[] portsToForwardString = new String[]{"test:0:1234", "test:0:9999", "test:0:9990", "test:0:8080"};
    private final String[] useSamePortsToForwardString = new String[]{"test::1234", "test::9999", "test::9990", "test::8080"};
    private Set<String> portsToForward = new HashSet<String>();
    private Map<Integer, Integer> proxiedPorts = new HashMap<Integer, Integer>();

    @Test
    public void testAlleatoryPortBackwardCapabilities() {
        this.resolvePorts("aleatoryPortBackward");
        for (Map.Entry<Integer, Integer> entry : this.proxiedPorts.entrySet()) {
            Assert.assertNotEquals((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    @Test
    public void testAlleatoryPort() {
        this.resolvePorts("aleatoryPort");
        for (Map.Entry<Integer, Integer> entry : this.proxiedPorts.entrySet()) {
            Assert.assertNotEquals((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    @Test
    public void testSamePort() {
        this.resolvePorts("samePort");
        for (Map.Entry<Integer, Integer> entry : this.proxiedPorts.entrySet()) {
            Assert.assertEquals((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    @Test
    public void testSameAndAleatoryPort() {
        this.portsToForward.add("test:8080");
        this.resolvePorts("none");
        for (Map.Entry<Integer, Integer> entry : this.proxiedPorts.entrySet()) {
            Assert.assertNotEquals((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.portsToForward.add("test::8180");
        this.resolvePorts("none");
        for (Map.Entry<Integer, Integer> entry : this.proxiedPorts.entrySet()) {
            Assert.assertEquals((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.portsToForward.add("test:0:8280");
        this.resolvePorts("none");
        for (Map.Entry<Integer, Integer> entry : this.proxiedPorts.entrySet()) {
            Assert.assertNotEquals((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.portsToForward.add("test:8380:8380");
        this.resolvePorts("none");
        for (Map.Entry<Integer, Integer> entry : this.proxiedPorts.entrySet()) {
            Assert.assertEquals((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testNegativePort() {
        Assert.assertEquals((long)-1L, (long)this.allocateLocalPort(-1));
    }

    private void resolvePorts(String method) {
        int i;
        this.portsToForward = new HashSet<String>();
        if ("aleatoryPortBackward".equals(method)) {
            for (i = 0; i < this.portsToForwardStringBackward.length; ++i) {
                this.portsToForward.add(this.portsToForwardStringBackward[i]);
            }
        } else if ("aleatoryPort".equals(method)) {
            for (i = 0; i < this.portsToForwardString.length; ++i) {
                this.portsToForward.add(this.portsToForwardString[i]);
            }
        } else if ("samePort".equals(method)) {
            for (i = 0; i < this.useSamePortsToForwardString.length; ++i) {
                this.portsToForward.add(this.useSamePortsToForwardString[i]);
            }
        }
        for (String proxy : this.portsToForward) {
            String[] split = proxy.split(":");
            if (split.length != 2 && split.length != 3) continue;
            int containerPort = !"".equals(split[1]) ? Integer.valueOf(split[1]) : Integer.valueOf(split[2]);
            int mappedPort = 0;
            mappedPort = split.length == 3 && "".equals(split[1]) ? this.allocateLocalPort(Integer.valueOf(split[2])) : (split.length == 3 && "0".equals(split[1]) ? this.allocateLocalPort(Integer.valueOf(split[1])) : this.allocateLocalPort(0));
            this.proxiedPorts.put(containerPort, mappedPort);
        }
    }

    private int allocateLocalPort(int port) {
        int n;
        ServerSocket serverSocket = new ServerSocket(port, 0, Inet4Address.getLocalHost());
        try {
            n = serverSocket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new IllegalStateException("Could not allocate local port for forwarding proxy", t);
            }
        }
        serverSocket.close();
        return n;
    }
}

