/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.arquillian.cube.kubernetes.annotations.Named;
import org.arquillian.cube.kubernetes.impl.requirement.RequiresKubernetes;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@Category(value={RequiresKubernetes.class})
public class ServiceInjection {
    @ArquillianResource
    private KubernetesClient client;
    @ArquillianResource
    private ServiceList serviceList;
    @Named(value="test-service")
    @ArquillianResource
    private Service service;
    @Named(value="test-service-second", namespace="test-secondary-namespace")
    @ArquillianResource
    private Service serviceInSecondaryNamespace;

    @Test
    public void testServicesInjection() {
        Assert.assertNotNull((Object)this.serviceList);
        Assert.assertEquals((long)1L, (long)this.serviceList.getItems().size());
        Assert.assertEquals((Object)"test-service", (Object)((Service)this.serviceList.getItems().get(0)).getMetadata().getName());
        Assert.assertNotNull((Object)this.service);
        Assert.assertEquals((Object)"test-service", (Object)this.service.getMetadata().getName());
        Assert.assertNotNull((Object)this.serviceInSecondaryNamespace);
        Assert.assertEquals((Object)"test-service-second", (Object)this.serviceInSecondaryNamespace.getMetadata().getName());
        Assert.assertEquals((Object)"test-secondary-namespace", (Object)this.serviceInSecondaryNamespace.getMetadata().getNamespace());
    }
}

