/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.sundr.builder.BaseFluent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.arquillian.cube.kubernetes.impl.DefaultConfiguration;

public class DefaultConfigurationFluent<A extends DefaultConfigurationFluent<A>>
extends BaseFluent<A> {
    private String sessionId;
    private String namespace;
    private URL masterUrl;
    private Map<String, String> scriptEnvironmentVariables = new LinkedHashMap<String, String>();
    private URL environmentSetupScriptUrl;
    private URL environmentTeardownScriptUrl;
    private URL environmentConfigUrl;
    private List<URL> environmentDependencies = new ArrayList<URL>();
    private boolean namespaceLazyCreateEnabled;
    private boolean namespaceCleanupEnabled;
    private long namespaceCleanupTimeout;
    private boolean namespaceCleanupConfirmationEnabled;
    private boolean namespaceUseCurrentEnabled;
    private boolean namespaceDestroyEnabled;
    private boolean namespaceDestroyConfirmationEnabled;
    private long namespaceDestroyTimeout;
    private boolean waitEnabled;
    private long waitTimeout;
    private long waitPollInterval;
    private List<String> waitForServiceList = new ArrayList<String>();
    private boolean ansiLoggerEnabled;
    private boolean environmentInitEnabled;
    private boolean logCopyEnabled;
    private String logPath;
    private String kubernetesDomain;
    private String dockerRegistry;
    private String username;
    private String password;
    private String apiVersion;
    private boolean trustCerts;
    private boolean fmpBuildEnabled;
    private boolean fmpBuildForMavenDisable;
    private boolean fmpDebugOutput;
    private boolean fmpLogsEnabled;
    private String fmpPomPath;
    private List<String> fmpProfiles = new ArrayList<String>();
    private List<String> fmpSystemProperties = new ArrayList<String>();
    private String fmpBuildOptions;
    private String token;

    public DefaultConfigurationFluent() {
    }

    public DefaultConfigurationFluent(DefaultConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DefaultConfiguration instance) {
        if (instance != null) {
            this.withSessionId(instance.getSessionId());
            this.withMasterUrl(instance.getMasterUrl());
            this.withNamespace(instance.getNamespace());
            this.withScriptEnvironmentVariables(instance.getScriptEnvironmentVariables());
            this.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl());
            this.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl());
            this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl());
            this.withEnvironmentDependencies(instance.getEnvironmentDependencies());
            this.withNamespaceUseCurrentEnabled(instance.isNamespaceUseCurrentEnabled());
            this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled());
            this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled());
            this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout());
            this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled());
            this.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled());
            this.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled());
            this.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout());
            this.withWaitEnabled(instance.isWaitEnabled());
            this.withWaitTimeout(instance.getWaitTimeout());
            this.withWaitPollInterval(instance.getWaitPollInterval());
            this.withWaitForServiceList(instance.getWaitForServiceList());
            this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled());
            this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled());
            this.withLogCopyEnabled(instance.isLogCopyEnabled());
            this.withLogPath(instance.getLogPath());
            this.withKubernetesDomain(instance.getKubernetesDomain());
            this.withDockerRegistry(instance.getDockerRegistry());
            this.withToken(instance.getToken());
            this.withUsername(instance.getUsername());
            this.withPassword(instance.getPassword());
            this.withApiVersion(instance.getApiVersion());
            this.withTrustCerts(instance.isTrustCerts());
            this.withFmpBuildEnabled(instance.isFmpBuildEnabled());
            this.withFmpBuildForMavenDisable(instance.isFmpBuildForMavenDisable());
            this.withFmpDebugOutput(instance.isFmpDebugOutput());
            this.withFmpLogsEnabled(instance.isFmpLogsEnabled());
            this.withFmpPomPath(instance.getFmpPomPath());
            this.withFmpProfiles(instance.getFmpProfiles());
            this.withFmpSystemProperties(instance.getFmpSystemProperties());
            this.withFmpBuildOptions(instance.getFmpBuildOptions());
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public A withSessionId(String sessionId) {
        this.sessionId = sessionId;
        return (A)((Object)this);
    }

    public boolean hasSessionId() {
        return this.sessionId != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public URL getMasterUrl() {
        return this.masterUrl;
    }

    public A withMasterUrl(URL masterUrl) {
        this.masterUrl = masterUrl;
        return (A)((Object)this);
    }

    public boolean hasMasterUrl() {
        return this.masterUrl != null;
    }

    public A addToScriptEnvironmentVariables(String key, String value) {
        if (this.scriptEnvironmentVariables == null && key != null && value != null) {
            this.scriptEnvironmentVariables = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.scriptEnvironmentVariables.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToScriptEnvironmentVariables(Map<String, String> map) {
        if (this.scriptEnvironmentVariables == null && map != null) {
            this.scriptEnvironmentVariables = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.scriptEnvironmentVariables.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromScriptEnvironmentVariables(String key) {
        if (this.scriptEnvironmentVariables == null) {
            return (A)((Object)this);
        }
        if (key != null && this.scriptEnvironmentVariables != null) {
            this.scriptEnvironmentVariables.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromScriptEnvironmentVariables(Map<String, String> map) {
        if (this.scriptEnvironmentVariables == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.scriptEnvironmentVariables == null) continue;
                this.scriptEnvironmentVariables.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getScriptEnvironmentVariables() {
        return this.scriptEnvironmentVariables;
    }

    public <K, V> A withScriptEnvironmentVariables(Map<String, String> scriptEnvironmentVariables) {
        this.scriptEnvironmentVariables = scriptEnvironmentVariables == null ? null : new LinkedHashMap<String, String>(scriptEnvironmentVariables);
        return (A)((Object)this);
    }

    public boolean hasScriptEnvironmentVariables() {
        return this.scriptEnvironmentVariables != null;
    }

    public URL getEnvironmentSetupScriptUrl() {
        return this.environmentSetupScriptUrl;
    }

    public A withEnvironmentSetupScriptUrl(URL environmentSetupScriptUrl) {
        this.environmentSetupScriptUrl = environmentSetupScriptUrl;
        return (A)((Object)this);
    }

    public boolean hasEnvironmentSetupScriptUrl() {
        return this.environmentSetupScriptUrl != null;
    }

    public URL getEnvironmentTeardownScriptUrl() {
        return this.environmentTeardownScriptUrl;
    }

    public A withEnvironmentTeardownScriptUrl(URL environmentTeardownScriptUrl) {
        this.environmentTeardownScriptUrl = environmentTeardownScriptUrl;
        return (A)((Object)this);
    }

    public boolean hasEnvironmentTeardownScriptUrl() {
        return this.environmentTeardownScriptUrl != null;
    }

    public URL getEnvironmentConfigUrl() {
        return this.environmentConfigUrl;
    }

    public A withEnvironmentConfigUrl(URL environmentConfigUrl) {
        this.environmentConfigUrl = environmentConfigUrl;
        return (A)((Object)this);
    }

    public boolean hasEnvironmentConfigUrl() {
        return this.environmentConfigUrl != null;
    }

    public A addToEnvironmentDependencies(int index, URL item) {
        if (this.environmentDependencies == null) {
            this.environmentDependencies = new ArrayList<URL>();
        }
        this.environmentDependencies.add(index, item);
        return (A)((Object)this);
    }

    public A setToEnvironmentDependencies(int index, URL item) {
        if (this.environmentDependencies == null) {
            this.environmentDependencies = new ArrayList<URL>();
        }
        this.environmentDependencies.set(index, item);
        return (A)((Object)this);
    }

    public A addToEnvironmentDependencies(URL ... items) {
        if (this.environmentDependencies == null) {
            this.environmentDependencies = new ArrayList<URL>();
        }
        for (URL item : items) {
            this.environmentDependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEnvironmentDependencies(Collection<URL> items) {
        if (this.environmentDependencies == null) {
            this.environmentDependencies = new ArrayList<URL>();
        }
        for (URL item : items) {
            this.environmentDependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEnvironmentDependencies(URL ... items) {
        if (this.environmentDependencies == null) {
            return (A)((Object)this);
        }
        for (URL item : items) {
            this.environmentDependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnvironmentDependencies(Collection<URL> items) {
        if (this.environmentDependencies == null) {
            return (A)((Object)this);
        }
        for (URL item : items) {
            this.environmentDependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public List<URL> getEnvironmentDependencies() {
        return this.environmentDependencies;
    }

    public URL getEnvironmentDependency(int index) {
        return this.environmentDependencies.get(index);
    }

    public URL getFirstEnvironmentDependency() {
        return this.environmentDependencies.get(0);
    }

    public URL getLastEnvironmentDependency() {
        return this.environmentDependencies.get(this.environmentDependencies.size() - 1);
    }

    public URL getMatchingEnvironmentDependency(Predicate<URL> predicate) {
        for (URL item : this.environmentDependencies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEnvironmentDependency(Predicate<URL> predicate) {
        for (URL item : this.environmentDependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnvironmentDependencies(List<URL> environmentDependencies) {
        if (environmentDependencies != null) {
            this.environmentDependencies = new ArrayList<URL>();
            for (URL item : environmentDependencies) {
                this.addToEnvironmentDependencies(item);
            }
        } else {
            this.environmentDependencies = null;
        }
        return (A)((Object)this);
    }

    public A withEnvironmentDependencies(URL ... environmentDependencies) {
        if (this.environmentDependencies != null) {
            this.environmentDependencies.clear();
            this._visitables.remove((Object)"environmentDependencies");
        }
        if (environmentDependencies != null) {
            for (URL item : environmentDependencies) {
                this.addToEnvironmentDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnvironmentDependencies() {
        return this.environmentDependencies != null && !this.environmentDependencies.isEmpty();
    }

    public boolean isNamespaceLazyCreateEnabled() {
        return this.namespaceLazyCreateEnabled;
    }

    public A withNamespaceLazyCreateEnabled(boolean namespaceLazyCreateEnabled) {
        this.namespaceLazyCreateEnabled = namespaceLazyCreateEnabled;
        return (A)((Object)this);
    }

    public boolean hasNamespaceLazyCreateEnabled() {
        return true;
    }

    public boolean isNamespaceCleanupEnabled() {
        return this.namespaceCleanupEnabled;
    }

    public A withNamespaceCleanupEnabled(boolean namespaceCleanupEnabled) {
        this.namespaceCleanupEnabled = namespaceCleanupEnabled;
        return (A)((Object)this);
    }

    public boolean hasNamespaceCleanupEnabled() {
        return true;
    }

    public long getNamespaceCleanupTimeout() {
        return this.namespaceCleanupTimeout;
    }

    public A withNamespaceCleanupTimeout(long namespaceCleanupTimeout) {
        this.namespaceCleanupTimeout = namespaceCleanupTimeout;
        return (A)((Object)this);
    }

    public boolean hasNamespaceCleanupTimeout() {
        return true;
    }

    public boolean isNamespaceCleanupConfirmationEnabled() {
        return this.namespaceCleanupConfirmationEnabled;
    }

    public A withNamespaceCleanupConfirmationEnabled(boolean namespaceCleanupConfirmationEnabled) {
        this.namespaceCleanupConfirmationEnabled = namespaceCleanupConfirmationEnabled;
        return (A)((Object)this);
    }

    public boolean hasNamespaceCleanupConfirmationEnabled() {
        return true;
    }

    public boolean isNamespaceUseCurrentEnabled() {
        return this.namespaceUseCurrentEnabled;
    }

    public A withNamespaceUseCurrentEnabled(boolean namespaceUseCurrentEnabled) {
        this.namespaceUseCurrentEnabled = namespaceUseCurrentEnabled;
        return (A)((Object)this);
    }

    public boolean hasNamespaceUseCurrentEnabled() {
        return true;
    }

    public boolean isNamespaceDestroyEnabled() {
        return this.namespaceDestroyEnabled;
    }

    public A withNamespaceDestroyEnabled(boolean namespaceDestroyEnabled) {
        this.namespaceDestroyEnabled = namespaceDestroyEnabled;
        return (A)((Object)this);
    }

    public boolean hasNamespaceDestroyEnabled() {
        return true;
    }

    public boolean isNamespaceDestroyConfirmationEnabled() {
        return this.namespaceDestroyConfirmationEnabled;
    }

    public A withNamespaceDestroyConfirmationEnabled(boolean namespaceDestroyConfirmationEnabled) {
        this.namespaceDestroyConfirmationEnabled = namespaceDestroyConfirmationEnabled;
        return (A)((Object)this);
    }

    public boolean hasNamespaceDestroyConfirmationEnabled() {
        return true;
    }

    public long getNamespaceDestroyTimeout() {
        return this.namespaceDestroyTimeout;
    }

    public A withNamespaceDestroyTimeout(long namespaceDestroyTimeout) {
        this.namespaceDestroyTimeout = namespaceDestroyTimeout;
        return (A)((Object)this);
    }

    public boolean hasNamespaceDestroyTimeout() {
        return true;
    }

    public boolean isWaitEnabled() {
        return this.waitEnabled;
    }

    public A withWaitEnabled(boolean waitEnabled) {
        this.waitEnabled = waitEnabled;
        return (A)((Object)this);
    }

    public boolean hasWaitEnabled() {
        return true;
    }

    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    public A withWaitTimeout(long waitTimeout) {
        this.waitTimeout = waitTimeout;
        return (A)((Object)this);
    }

    public boolean hasWaitTimeout() {
        return true;
    }

    public long getWaitPollInterval() {
        return this.waitPollInterval;
    }

    public A withWaitPollInterval(long waitPollInterval) {
        this.waitPollInterval = waitPollInterval;
        return (A)((Object)this);
    }

    public boolean hasWaitPollInterval() {
        return true;
    }

    public A addToWaitForServiceList(int index, String item) {
        if (this.waitForServiceList == null) {
            this.waitForServiceList = new ArrayList<String>();
        }
        this.waitForServiceList.add(index, item);
        return (A)((Object)this);
    }

    public A setToWaitForServiceList(int index, String item) {
        if (this.waitForServiceList == null) {
            this.waitForServiceList = new ArrayList<String>();
        }
        this.waitForServiceList.set(index, item);
        return (A)((Object)this);
    }

    public A addToWaitForServiceList(String ... items) {
        if (this.waitForServiceList == null) {
            this.waitForServiceList = new ArrayList<String>();
        }
        for (String item : items) {
            this.waitForServiceList.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToWaitForServiceList(Collection<String> items) {
        if (this.waitForServiceList == null) {
            this.waitForServiceList = new ArrayList<String>();
        }
        for (String item : items) {
            this.waitForServiceList.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromWaitForServiceList(String ... items) {
        if (this.waitForServiceList == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.waitForServiceList.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromWaitForServiceList(Collection<String> items) {
        if (this.waitForServiceList == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.waitForServiceList.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getWaitForServiceList() {
        return this.waitForServiceList;
    }

    public String getWaitForServiceList(int index) {
        return this.waitForServiceList.get(index);
    }

    public String getFirstWaitForServiceList() {
        return this.waitForServiceList.get(0);
    }

    public String getLastWaitForServiceList() {
        return this.waitForServiceList.get(this.waitForServiceList.size() - 1);
    }

    public String getMatchingWaitForServiceList(Predicate<String> predicate) {
        for (String item : this.waitForServiceList) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingWaitForServiceList(Predicate<String> predicate) {
        for (String item : this.waitForServiceList) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withWaitForServiceList(List<String> waitForServiceList) {
        if (waitForServiceList != null) {
            this.waitForServiceList = new ArrayList<String>();
            for (String item : waitForServiceList) {
                this.addToWaitForServiceList(item);
            }
        } else {
            this.waitForServiceList = null;
        }
        return (A)((Object)this);
    }

    public A withWaitForServiceList(String ... waitForServiceList) {
        if (this.waitForServiceList != null) {
            this.waitForServiceList.clear();
            this._visitables.remove((Object)"waitForServiceList");
        }
        if (waitForServiceList != null) {
            for (String item : waitForServiceList) {
                this.addToWaitForServiceList(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasWaitForServiceList() {
        return this.waitForServiceList != null && !this.waitForServiceList.isEmpty();
    }

    public boolean isAnsiLoggerEnabled() {
        return this.ansiLoggerEnabled;
    }

    public A withAnsiLoggerEnabled(boolean ansiLoggerEnabled) {
        this.ansiLoggerEnabled = ansiLoggerEnabled;
        return (A)((Object)this);
    }

    public boolean hasAnsiLoggerEnabled() {
        return true;
    }

    public boolean isEnvironmentInitEnabled() {
        return this.environmentInitEnabled;
    }

    public A withEnvironmentInitEnabled(boolean environmentInitEnabled) {
        this.environmentInitEnabled = environmentInitEnabled;
        return (A)((Object)this);
    }

    public boolean hasEnvironmentInitEnabled() {
        return true;
    }

    public boolean isLogCopyEnabled() {
        return this.logCopyEnabled;
    }

    public A withLogCopyEnabled(boolean logCopyEnabled) {
        this.logCopyEnabled = logCopyEnabled;
        return (A)((Object)this);
    }

    public boolean hasLogCopyEnabled() {
        return true;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public A withLogPath(String logPath) {
        this.logPath = logPath;
        return (A)((Object)this);
    }

    public boolean hasLogPath() {
        return this.logPath != null;
    }

    public String getKubernetesDomain() {
        return this.kubernetesDomain;
    }

    public A withKubernetesDomain(String kubernetesDomain) {
        this.kubernetesDomain = kubernetesDomain;
        return (A)((Object)this);
    }

    public boolean hasKubernetesDomain() {
        return this.kubernetesDomain != null;
    }

    public String getDockerRegistry() {
        return this.dockerRegistry;
    }

    public A withDockerRegistry(String dockerRegistry) {
        this.dockerRegistry = dockerRegistry;
        return (A)((Object)this);
    }

    public boolean hasDockerRegistry() {
        return this.dockerRegistry != null;
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)((Object)this);
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public String getPassword() {
        return this.password;
    }

    public A withPassword(String password) {
        this.password = password;
        return (A)((Object)this);
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    public A withTrustCerts(boolean trustCerts) {
        this.trustCerts = trustCerts;
        return (A)((Object)this);
    }

    public boolean hasTrustCerts() {
        return true;
    }

    public boolean isFmpBuildEnabled() {
        return this.fmpBuildEnabled;
    }

    public A withFmpBuildEnabled(boolean fmpBuildEnabled) {
        this.fmpBuildEnabled = fmpBuildEnabled;
        return (A)((Object)this);
    }

    public boolean hasFmpBuildEnabled() {
        return true;
    }

    public boolean isFmpBuildForMavenDisable() {
        return this.fmpBuildForMavenDisable;
    }

    public A withFmpBuildForMavenDisable(boolean fmpBuildForMavenDisable) {
        this.fmpBuildForMavenDisable = fmpBuildForMavenDisable;
        return (A)((Object)this);
    }

    public boolean hasFmpBuildForMavenDisable() {
        return true;
    }

    public boolean isFmpDebugOutput() {
        return this.fmpDebugOutput;
    }

    public A withFmpDebugOutput(boolean fmpDebugOutput) {
        this.fmpDebugOutput = fmpDebugOutput;
        return (A)((Object)this);
    }

    public boolean hasFmpDebugOutput() {
        return true;
    }

    public boolean isFmpLogsEnabled() {
        return this.fmpLogsEnabled;
    }

    public A withFmpLogsEnabled(boolean fmpLogsEnabled) {
        this.fmpLogsEnabled = fmpLogsEnabled;
        return (A)((Object)this);
    }

    public boolean hasFmpLogsEnabled() {
        return true;
    }

    public String getFmpPomPath() {
        return this.fmpPomPath;
    }

    public A withFmpPomPath(String fmpPomPath) {
        this.fmpPomPath = fmpPomPath;
        return (A)((Object)this);
    }

    public boolean hasFmpPomPath() {
        return this.fmpPomPath != null;
    }

    public A addToFmpProfiles(int index, String item) {
        if (this.fmpProfiles == null) {
            this.fmpProfiles = new ArrayList<String>();
        }
        this.fmpProfiles.add(index, item);
        return (A)((Object)this);
    }

    public A setToFmpProfiles(int index, String item) {
        if (this.fmpProfiles == null) {
            this.fmpProfiles = new ArrayList<String>();
        }
        this.fmpProfiles.set(index, item);
        return (A)((Object)this);
    }

    public A addToFmpProfiles(String ... items) {
        if (this.fmpProfiles == null) {
            this.fmpProfiles = new ArrayList<String>();
        }
        for (String item : items) {
            this.fmpProfiles.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToFmpProfiles(Collection<String> items) {
        if (this.fmpProfiles == null) {
            this.fmpProfiles = new ArrayList<String>();
        }
        for (String item : items) {
            this.fmpProfiles.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromFmpProfiles(String ... items) {
        if (this.fmpProfiles == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.fmpProfiles.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFmpProfiles(Collection<String> items) {
        if (this.fmpProfiles == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.fmpProfiles.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getFmpProfiles() {
        return this.fmpProfiles;
    }

    public String getFmpProfile(int index) {
        return this.fmpProfiles.get(index);
    }

    public String getFirstFmpProfile() {
        return this.fmpProfiles.get(0);
    }

    public String getLastFmpProfile() {
        return this.fmpProfiles.get(this.fmpProfiles.size() - 1);
    }

    public String getMatchingFmpProfile(Predicate<String> predicate) {
        for (String item : this.fmpProfiles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingFmpProfile(Predicate<String> predicate) {
        for (String item : this.fmpProfiles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFmpProfiles(List<String> fmpProfiles) {
        if (fmpProfiles != null) {
            this.fmpProfiles = new ArrayList<String>();
            for (String item : fmpProfiles) {
                this.addToFmpProfiles(item);
            }
        } else {
            this.fmpProfiles = null;
        }
        return (A)((Object)this);
    }

    public A withFmpProfiles(String ... fmpProfiles) {
        if (this.fmpProfiles != null) {
            this.fmpProfiles.clear();
            this._visitables.remove((Object)"fmpProfiles");
        }
        if (fmpProfiles != null) {
            for (String item : fmpProfiles) {
                this.addToFmpProfiles(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFmpProfiles() {
        return this.fmpProfiles != null && !this.fmpProfiles.isEmpty();
    }

    public A addToFmpSystemProperties(int index, String item) {
        if (this.fmpSystemProperties == null) {
            this.fmpSystemProperties = new ArrayList<String>();
        }
        this.fmpSystemProperties.add(index, item);
        return (A)((Object)this);
    }

    public A setToFmpSystemProperties(int index, String item) {
        if (this.fmpSystemProperties == null) {
            this.fmpSystemProperties = new ArrayList<String>();
        }
        this.fmpSystemProperties.set(index, item);
        return (A)((Object)this);
    }

    public A addToFmpSystemProperties(String ... items) {
        if (this.fmpSystemProperties == null) {
            this.fmpSystemProperties = new ArrayList<String>();
        }
        for (String item : items) {
            this.fmpSystemProperties.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToFmpSystemProperties(Collection<String> items) {
        if (this.fmpSystemProperties == null) {
            this.fmpSystemProperties = new ArrayList<String>();
        }
        for (String item : items) {
            this.fmpSystemProperties.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromFmpSystemProperties(String ... items) {
        if (this.fmpSystemProperties == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.fmpSystemProperties.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFmpSystemProperties(Collection<String> items) {
        if (this.fmpSystemProperties == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.fmpSystemProperties.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getFmpSystemProperties() {
        return this.fmpSystemProperties;
    }

    public String getFmpSystemProperty(int index) {
        return this.fmpSystemProperties.get(index);
    }

    public String getFirstFmpSystemProperty() {
        return this.fmpSystemProperties.get(0);
    }

    public String getLastFmpSystemProperty() {
        return this.fmpSystemProperties.get(this.fmpSystemProperties.size() - 1);
    }

    public String getMatchingFmpSystemProperty(Predicate<String> predicate) {
        for (String item : this.fmpSystemProperties) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingFmpSystemProperty(Predicate<String> predicate) {
        for (String item : this.fmpSystemProperties) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFmpSystemProperties(List<String> fmpSystemProperties) {
        if (fmpSystemProperties != null) {
            this.fmpSystemProperties = new ArrayList<String>();
            for (String item : fmpSystemProperties) {
                this.addToFmpSystemProperties(item);
            }
        } else {
            this.fmpSystemProperties = null;
        }
        return (A)((Object)this);
    }

    public A withFmpSystemProperties(String ... fmpSystemProperties) {
        if (this.fmpSystemProperties != null) {
            this.fmpSystemProperties.clear();
            this._visitables.remove((Object)"fmpSystemProperties");
        }
        if (fmpSystemProperties != null) {
            for (String item : fmpSystemProperties) {
                this.addToFmpSystemProperties(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFmpSystemProperties() {
        return this.fmpSystemProperties != null && !this.fmpSystemProperties.isEmpty();
    }

    public String getFmpBuildOptions() {
        return this.fmpBuildOptions;
    }

    public A withFmpBuildOptions(String fmpBuildOptions) {
        this.fmpBuildOptions = fmpBuildOptions;
        return (A)((Object)this);
    }

    public boolean hasFmpBuildOptions() {
        return this.fmpBuildOptions != null;
    }

    public String getToken() {
        return this.token;
    }

    public A withToken(String token) {
        this.token = token;
        return (A)((Object)this);
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultConfigurationFluent that = (DefaultConfigurationFluent)((Object)o);
        if (!Objects.equals(this.sessionId, that.sessionId)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.masterUrl, that.masterUrl)) {
            return false;
        }
        if (!Objects.equals(this.scriptEnvironmentVariables, that.scriptEnvironmentVariables)) {
            return false;
        }
        if (!Objects.equals(this.environmentSetupScriptUrl, that.environmentSetupScriptUrl)) {
            return false;
        }
        if (!Objects.equals(this.environmentTeardownScriptUrl, that.environmentTeardownScriptUrl)) {
            return false;
        }
        if (!Objects.equals(this.environmentConfigUrl, that.environmentConfigUrl)) {
            return false;
        }
        if (!Objects.equals(this.environmentDependencies, that.environmentDependencies)) {
            return false;
        }
        if (this.namespaceLazyCreateEnabled != that.namespaceLazyCreateEnabled) {
            return false;
        }
        if (this.namespaceCleanupEnabled != that.namespaceCleanupEnabled) {
            return false;
        }
        if (this.namespaceCleanupTimeout != that.namespaceCleanupTimeout) {
            return false;
        }
        if (this.namespaceCleanupConfirmationEnabled != that.namespaceCleanupConfirmationEnabled) {
            return false;
        }
        if (this.namespaceUseCurrentEnabled != that.namespaceUseCurrentEnabled) {
            return false;
        }
        if (this.namespaceDestroyEnabled != that.namespaceDestroyEnabled) {
            return false;
        }
        if (this.namespaceDestroyConfirmationEnabled != that.namespaceDestroyConfirmationEnabled) {
            return false;
        }
        if (this.namespaceDestroyTimeout != that.namespaceDestroyTimeout) {
            return false;
        }
        if (this.waitEnabled != that.waitEnabled) {
            return false;
        }
        if (this.waitTimeout != that.waitTimeout) {
            return false;
        }
        if (this.waitPollInterval != that.waitPollInterval) {
            return false;
        }
        if (!Objects.equals(this.waitForServiceList, that.waitForServiceList)) {
            return false;
        }
        if (this.ansiLoggerEnabled != that.ansiLoggerEnabled) {
            return false;
        }
        if (this.environmentInitEnabled != that.environmentInitEnabled) {
            return false;
        }
        if (this.logCopyEnabled != that.logCopyEnabled) {
            return false;
        }
        if (!Objects.equals(this.logPath, that.logPath)) {
            return false;
        }
        if (!Objects.equals(this.kubernetesDomain, that.kubernetesDomain)) {
            return false;
        }
        if (!Objects.equals(this.dockerRegistry, that.dockerRegistry)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (this.trustCerts != that.trustCerts) {
            return false;
        }
        if (this.fmpBuildEnabled != that.fmpBuildEnabled) {
            return false;
        }
        if (this.fmpBuildForMavenDisable != that.fmpBuildForMavenDisable) {
            return false;
        }
        if (this.fmpDebugOutput != that.fmpDebugOutput) {
            return false;
        }
        if (this.fmpLogsEnabled != that.fmpLogsEnabled) {
            return false;
        }
        if (!Objects.equals(this.fmpPomPath, that.fmpPomPath)) {
            return false;
        }
        if (!Objects.equals(this.fmpProfiles, that.fmpProfiles)) {
            return false;
        }
        if (!Objects.equals(this.fmpSystemProperties, that.fmpSystemProperties)) {
            return false;
        }
        if (!Objects.equals(this.fmpBuildOptions, that.fmpBuildOptions)) {
            return false;
        }
        return Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.namespace, this.masterUrl, this.scriptEnvironmentVariables, this.environmentSetupScriptUrl, this.environmentTeardownScriptUrl, this.environmentConfigUrl, this.environmentDependencies, this.namespaceLazyCreateEnabled, this.namespaceCleanupEnabled, this.namespaceCleanupTimeout, this.namespaceCleanupConfirmationEnabled, this.namespaceUseCurrentEnabled, this.namespaceDestroyEnabled, this.namespaceDestroyConfirmationEnabled, this.namespaceDestroyTimeout, this.waitEnabled, this.waitTimeout, this.waitPollInterval, this.waitForServiceList, this.ansiLoggerEnabled, this.environmentInitEnabled, this.logCopyEnabled, this.logPath, this.kubernetesDomain, this.dockerRegistry, this.username, this.password, this.apiVersion, this.trustCerts, this.fmpBuildEnabled, this.fmpBuildForMavenDisable, this.fmpDebugOutput, this.fmpLogsEnabled, this.fmpPomPath, this.fmpProfiles, this.fmpSystemProperties, this.fmpBuildOptions, this.token, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sessionId != null) {
            sb.append("sessionId:");
            sb.append(this.sessionId + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.masterUrl != null) {
            sb.append("masterUrl:");
            sb.append(this.masterUrl + ",");
        }
        if (this.scriptEnvironmentVariables != null && !this.scriptEnvironmentVariables.isEmpty()) {
            sb.append("scriptEnvironmentVariables:");
            sb.append(this.scriptEnvironmentVariables + ",");
        }
        if (this.environmentSetupScriptUrl != null) {
            sb.append("environmentSetupScriptUrl:");
            sb.append(this.environmentSetupScriptUrl + ",");
        }
        if (this.environmentTeardownScriptUrl != null) {
            sb.append("environmentTeardownScriptUrl:");
            sb.append(this.environmentTeardownScriptUrl + ",");
        }
        if (this.environmentConfigUrl != null) {
            sb.append("environmentConfigUrl:");
            sb.append(this.environmentConfigUrl + ",");
        }
        if (this.environmentDependencies != null && !this.environmentDependencies.isEmpty()) {
            sb.append("environmentDependencies:");
            sb.append(this.environmentDependencies + ",");
        }
        sb.append("namespaceLazyCreateEnabled:");
        sb.append(this.namespaceLazyCreateEnabled + ",");
        sb.append("namespaceCleanupEnabled:");
        sb.append(this.namespaceCleanupEnabled + ",");
        sb.append("namespaceCleanupTimeout:");
        sb.append(this.namespaceCleanupTimeout + ",");
        sb.append("namespaceCleanupConfirmationEnabled:");
        sb.append(this.namespaceCleanupConfirmationEnabled + ",");
        sb.append("namespaceUseCurrentEnabled:");
        sb.append(this.namespaceUseCurrentEnabled + ",");
        sb.append("namespaceDestroyEnabled:");
        sb.append(this.namespaceDestroyEnabled + ",");
        sb.append("namespaceDestroyConfirmationEnabled:");
        sb.append(this.namespaceDestroyConfirmationEnabled + ",");
        sb.append("namespaceDestroyTimeout:");
        sb.append(this.namespaceDestroyTimeout + ",");
        sb.append("waitEnabled:");
        sb.append(this.waitEnabled + ",");
        sb.append("waitTimeout:");
        sb.append(this.waitTimeout + ",");
        sb.append("waitPollInterval:");
        sb.append(this.waitPollInterval + ",");
        if (this.waitForServiceList != null && !this.waitForServiceList.isEmpty()) {
            sb.append("waitForServiceList:");
            sb.append(this.waitForServiceList + ",");
        }
        sb.append("ansiLoggerEnabled:");
        sb.append(this.ansiLoggerEnabled + ",");
        sb.append("environmentInitEnabled:");
        sb.append(this.environmentInitEnabled + ",");
        sb.append("logCopyEnabled:");
        sb.append(this.logCopyEnabled + ",");
        if (this.logPath != null) {
            sb.append("logPath:");
            sb.append(this.logPath + ",");
        }
        if (this.kubernetesDomain != null) {
            sb.append("kubernetesDomain:");
            sb.append(this.kubernetesDomain + ",");
        }
        if (this.dockerRegistry != null) {
            sb.append("dockerRegistry:");
            sb.append(this.dockerRegistry + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        sb.append("trustCerts:");
        sb.append(this.trustCerts + ",");
        sb.append("fmpBuildEnabled:");
        sb.append(this.fmpBuildEnabled + ",");
        sb.append("fmpBuildForMavenDisable:");
        sb.append(this.fmpBuildForMavenDisable + ",");
        sb.append("fmpDebugOutput:");
        sb.append(this.fmpDebugOutput + ",");
        sb.append("fmpLogsEnabled:");
        sb.append(this.fmpLogsEnabled + ",");
        if (this.fmpPomPath != null) {
            sb.append("fmpPomPath:");
            sb.append(this.fmpPomPath + ",");
        }
        if (this.fmpProfiles != null && !this.fmpProfiles.isEmpty()) {
            sb.append("fmpProfiles:");
            sb.append(this.fmpProfiles + ",");
        }
        if (this.fmpSystemProperties != null && !this.fmpSystemProperties.isEmpty()) {
            sb.append("fmpSystemProperties:");
            sb.append(this.fmpSystemProperties + ",");
        }
        if (this.fmpBuildOptions != null) {
            sb.append("fmpBuildOptions:");
            sb.append(this.fmpBuildOptions + ",");
        }
        if (this.token != null) {
            sb.append("token:");
            sb.append(this.token);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withNamespaceLazyCreateEnabled() {
        return this.withNamespaceLazyCreateEnabled(true);
    }

    public A withNamespaceCleanupEnabled() {
        return this.withNamespaceCleanupEnabled(true);
    }

    public A withNamespaceCleanupConfirmationEnabled() {
        return this.withNamespaceCleanupConfirmationEnabled(true);
    }

    public A withNamespaceUseCurrentEnabled() {
        return this.withNamespaceUseCurrentEnabled(true);
    }

    public A withNamespaceDestroyEnabled() {
        return this.withNamespaceDestroyEnabled(true);
    }

    public A withNamespaceDestroyConfirmationEnabled() {
        return this.withNamespaceDestroyConfirmationEnabled(true);
    }

    public A withWaitEnabled() {
        return this.withWaitEnabled(true);
    }

    public A withAnsiLoggerEnabled() {
        return this.withAnsiLoggerEnabled(true);
    }

    public A withEnvironmentInitEnabled() {
        return this.withEnvironmentInitEnabled(true);
    }

    public A withLogCopyEnabled() {
        return this.withLogCopyEnabled(true);
    }

    public A withTrustCerts() {
        return this.withTrustCerts(true);
    }

    public A withFmpBuildEnabled() {
        return this.withFmpBuildEnabled(true);
    }

    public A withFmpBuildForMavenDisable() {
        return this.withFmpBuildForMavenDisable(true);
    }

    public A withFmpDebugOutput() {
        return this.withFmpDebugOutput(true);
    }

    public A withFmpLogsEnabled() {
        return this.withFmpLogsEnabled(true);
    }
}

