/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.Session;
import org.xnio.IoUtils;

public class WatchListener {
    private final Session session;
    private final KubernetesClient client;
    private final Configuration configuration;
    private FileWriter eventLogWriter;
    private String currentClassName;
    private String currentMethodName;
    private final Map<String, Collection<Closeable>> watchersMap = new ConcurrentHashMap<String, Collection<Closeable>>();
    private Watch watchLog;
    private Watch watchEvents;
    private String logPath;

    WatchListener(Session session, KubernetesClient client, Configuration configuration) {
        this.session = session;
        this.client = client;
        this.configuration = configuration;
    }

    void setupEventListener() {
        Watcher<Event> watcher = new Watcher<Event>(){

            public void eventReceived(Watcher.Action action, Event event) {
                Logger logger = WatchListener.this.session.getLogger();
                String watcherLogs = String.format("[%s] [%s] [%s:%s]: (%s) %s\n", event.getLastTimestamp(), event.getType(), event.getInvolvedObject().getKind(), event.getInvolvedObject().getName(), event.getReason(), event.getMessage());
                logger.info(watcherLogs);
                switch (action) {
                    case ADDED: 
                    case MODIFIED: 
                    case DELETED: 
                    case ERROR: {
                        try {
                            if (!WatchListener.this.configuration.isLogCopyEnabled()) break;
                            WatchListener.this.setupEventLogWriter();
                            WatchListener.this.eventLogWriter.append(watcherLogs);
                            WatchListener.this.eventLogWriter.flush();
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error storing kubernetes events", e);
                        }
                    }
                }
            }

            public void onClose(WatcherException cause) {
            }
        };
        this.watchEvents = ((NonNamespaceOperation)this.client.resources(Event.class).inNamespace(this.session.getNamespace())).watch((Watcher)watcher);
    }

    void cleanupEventsListener() {
        if (this.watchEvents != null) {
            this.watchEvents.close();
        }
        if (this.eventLogWriter != null) {
            try {
                this.eventLogWriter.close();
            }
            catch (IOException e) {
                this.session.getLogger().error("Error closing kubernetes events file: " + e);
            }
        }
    }

    void setupConsoleListener() {
        if (!this.configuration.isLogCopyEnabled()) {
            return;
        }
        this.logPath = this.configuration.getLogPath();
        if (Strings.isNullOrEmpty((String)this.logPath)) {
            this.logPath = String.format("%s/target/surefire-reports", System.getProperty("user.dir"));
        }
        this.session.getLogger().info(String.format("Storing pods console logs into dir %s", this.logPath));
        new File(this.logPath).mkdirs();
        Watcher<Pod> watcher = new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod pod) {
                switch (action) {
                    case ADDED: 
                    case MODIFIED: {
                        if (!pod.getStatus().getPhase().equalsIgnoreCase("Running")) break;
                        WatchListener.this.addConsole(pod.getMetadata().getName());
                        break;
                    }
                    case DELETED: 
                    case ERROR: {
                        WatchListener.this.delConsole(pod.getMetadata().getName());
                    }
                }
            }

            public void onClose(WatcherException cause) {
            }
        };
        this.watchLog = ((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).watch((Watcher)watcher);
    }

    void cleanupConsoleListener() {
        if (this.watchLog != null) {
            this.watchLog.close();
        }
        this.watchersMap.forEach((k, v) -> IoUtils.safeClose((Closeable[])v.toArray(new Closeable[0])));
        this.watchersMap.clear();
    }

    private void addConsole(String podName) {
        if (this.watchersMap.containsKey(podName)) {
            return;
        }
        String className = this.session.getCurrentClassName();
        String methodName = this.session.getCurrentMethodName();
        Object fileName = this.logPath;
        if (Strings.isNullOrEmpty((String)className)) {
            className = "NOCLASS";
        }
        fileName = (String)fileName + String.format("/%s", className);
        if (Strings.isNotNullOrEmpty((String)methodName)) {
            fileName = (String)fileName + String.format("-%s", methodName);
        }
        try {
            ArrayList<Object> fds = new ArrayList<Object>();
            List containers = ((Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).withName(podName)).get()).getSpec().getContainers();
            if (containers.size() == 1) {
                fileName = (String)fileName + String.format("-%s.log", podName);
                FileOutputStream stream = new FileOutputStream((String)fileName);
                LogWatch lw = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).withName(podName)).watchLog((OutputStream)stream);
                fds.add(lw);
                fds.add(stream);
            } else {
                for (Container container : containers) {
                    String containerName = container.getName();
                    String fileNameContainer = String.format("%s-%s-%s.log", fileName, podName, containerName);
                    FileOutputStream stream = new FileOutputStream(fileNameContainer);
                    LogWatch lw = ((ContainerResource)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).withName(podName)).inContainer((Object)containerName)).watchLog((OutputStream)stream);
                    fds.add(lw);
                    fds.add(stream);
                }
            }
            this.watchersMap.put(podName, fds);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("Error storing the console log for pod %s", podName), e);
        }
    }

    private void delConsole(String podName) {
        Collection<Closeable> lw = this.watchersMap.get(podName);
        if (lw == null) {
            return;
        }
        this.watchersMap.remove(podName);
        IoUtils.safeClose((Closeable[])lw.toArray(new Closeable[0]));
    }

    private void setupEventLogWriter() {
        String className = this.session.getCurrentClassName();
        String methodName = this.session.getCurrentMethodName();
        if (className != null && className.equals(this.currentClassName) && methodName != null && methodName.equals(this.currentMethodName)) {
            return;
        }
        this.currentClassName = className;
        this.currentMethodName = methodName;
        Object fileName = this.logPath;
        if (Strings.isNullOrEmpty((String)className)) {
            className = "NOCLASS";
        }
        fileName = (String)fileName + String.format("/%s", className);
        if (Strings.isNotNullOrEmpty((String)methodName)) {
            fileName = (String)fileName + String.format("-%s", methodName);
        }
        fileName = (String)fileName + "-KUBE_EVENTS.log";
        try {
            if (this.eventLogWriter != null) {
                this.eventLogWriter.close();
            }
            this.eventLogWriter = new FileWriter((String)fileName, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing kubernetes events", e);
        }
    }
}

