/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.enricher.external;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import org.arquillian.cube.kubernetes.impl.enricher.AbstractKubernetesResourceProvider;
import org.jboss.arquillian.test.api.ArquillianResource;

public class ClientResourceProvider
extends AbstractKubernetesResourceProvider {
    public boolean canProvide(Class<?> type) {
        return this.internalToUserType(KubernetesClient.class.getName()).equals(type.getName());
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        KubernetesClient client = this.getClient();
        if (client == null) {
            throw new IllegalStateException("Unable to inject Kubernetes client into test.");
        }
        return this.createUserClient(client);
    }

    private Object createUserClient(KubernetesClient client) {
        Config config = client.getConfiguration();
        Object userConfig = this.toUsersResource(config);
        Class userConfigClass = this.loadClass(this.internalToUserType(config.getClass().getName()));
        Class userClientClass = this.loadClass(this.internalToUserType(DefaultKubernetesClient.class.getName()));
        try {
            Constructor constructor = userClientClass.getConstructor(userConfigClass);
            return constructor.newInstance(userConfig);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

