/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.enricher.internal;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.kubernetes.impl.enricher.AbstractKubernetesResourceProvider;
import org.jboss.arquillian.test.api.ArquillianResource;

public class ServiceResourceProvider
extends AbstractKubernetesResourceProvider {
    public boolean canProvide(Class<?> type) {
        return Service.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        String name = this.getName(qualifiers);
        String namespace = this.getNamespace(qualifiers);
        if (name != null) {
            return ((ServiceResource)((NonNamespaceOperation)this.getClient().services().inNamespace(namespace)).withName(name)).get();
        }
        Map<String, String> labels = this.getLabels(qualifiers);
        ServiceList list = (ServiceList)((FilterWatchListDeletable)((NonNamespaceOperation)this.getClient().services().inNamespace(namespace)).withLabels(labels)).list();
        List services = list.getItems();
        if (!services.isEmpty()) {
            return services.get(0);
        }
        return null;
    }
}

